/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.network;

import net.minecraft.world.entity.player.Player;
import win.demistorm.network.BleedingParticleData;
import win.demistorm.network.BloodParticleData;
import win.demistorm.network.CatchCompleteData;
import win.demistorm.network.CatchData;
import win.demistorm.network.CatchUpdateData;
import win.demistorm.network.ConfigSyncData;
import win.demistorm.network.NetworkChannel;
import win.demistorm.network.NetworkHandlers;
import win.demistorm.network.ThrowData;

public class Network {
    public static final NetworkChannel INSTANCE = new NetworkChannel();

    public static void initialize() {
        Network.registerPackets();
    }

    private static void registerPackets() {
        INSTANCE.register(ThrowData.class, (data, buf) -> {
            buf.writeDouble(data.posX());
            buf.writeDouble(data.posY());
            buf.writeDouble(data.posZ());
            buf.writeDouble(data.velX());
            buf.writeDouble(data.velY());
            buf.writeDouble(data.velZ());
            buf.writeBoolean(data.wholeStack());
            buf.writeFloat(data.rollDeg());
        }, buf -> new ThrowData(buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readBoolean(), buf.readFloat()), (data, player) -> NetworkHandlers.handleThrow((Player)player, data));
        INSTANCE.register(CatchData.class, (data, buf) -> {
            buf.writeInt(data.entityId());
            buf.writeBoolean(data.startCatch());
        }, buf -> new CatchData(buf.readInt(), buf.readBoolean()), (data, player) -> NetworkHandlers.handleCatch((Player)player, data));
        INSTANCE.register(CatchUpdateData.class, (data, buf) -> {
            buf.writeInt(data.entityId());
            buf.writeDouble(data.velX());
            buf.writeDouble(data.velY());
            buf.writeDouble(data.velZ());
            buf.writeFloat(data.rollDeg());
        }, buf -> new CatchUpdateData(buf.readInt(), buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readFloat()), (data, player) -> NetworkHandlers.handleCatchUpdate((Player)player, data));
        INSTANCE.register(CatchCompleteData.class, (data, buf) -> buf.writeInt(data.entityId()), buf -> new CatchCompleteData(buf.readInt()), (data, player) -> NetworkHandlers.handleCatchComplete((Player)player, data));
        INSTANCE.register(BloodParticleData.class, (data, buf) -> {
            buf.writeDouble(data.posX());
            buf.writeDouble(data.posY());
            buf.writeDouble(data.posZ());
            buf.writeDouble(data.velX());
            buf.writeDouble(data.velY());
            buf.writeDouble(data.velZ());
        }, buf -> new BloodParticleData(buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readDouble()), (data, player) -> NetworkHandlers.handleBloodParticle((Player)player, data));
        INSTANCE.register(BleedingParticleData.class, (data, buf) -> {
            buf.writeDouble(data.posX());
            buf.writeDouble(data.posY());
            buf.writeDouble(data.posZ());
        }, buf -> new BleedingParticleData(buf.readDouble(), buf.readDouble(), buf.readDouble()), (data, player) -> NetworkHandlers.handleBleedingParticle((Player)player, data));
        INSTANCE.register(ConfigSyncData.class, (data, buf) -> {
            buf.m_130130_(data.json().length());
            buf.m_130070_(data.json());
        }, buf -> {
            int length = buf.m_130242_();
            return new ConfigSyncData(buf.m_130136_(length));
        }, (data, player) -> NetworkHandlers.handleConfigSync((Player)player, data));
    }
}

