/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.client;

import net.minecraft.class_10017;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_897;
import net.minecraft.class_918;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionfc;
import win.demistorm.ThrownProjectileEntity;

public class ThrownItemRenderer
extends class_897<ThrownProjectileEntity, ThrownItemRenderState> {
    private final class_918 itemRenderer = class_310.method_1551().method_1480();
    private final float scale;

    public ThrownItemRenderer(class_5617.class_5618 ctx) {
        super(ctx);
        this.scale = 0.7f;
        this.field_4673 = 0.0f;
    }

    @NotNull
    public ThrownItemRenderState createRenderState() {
        return new ThrownItemRenderState();
    }

    public void extractRenderState(ThrownProjectileEntity entity, ThrownItemRenderState state, float tickDelta) {
        state.itemStack = entity.method_7495();
        state.velocity = entity.method_18798();
        state.age = (float)entity.field_6012 + tickDelta;
        state.handRollDeg = entity.getHandRoll();
        state.isCatching = entity.isCatching();
        state.isBounceActive = entity.isBounceActive();
        state.isEmbedded = entity.isEmbedded();
        if (state.isEmbedded) {
            state.embedYawDeg = entity.getEmbedYaw();
            state.embedPitchDeg = entity.getEmbedPitch();
            state.embedRollDeg = entity.getEmbedRoll();
            state.embedTiltDeg = entity.getEmbedTilt();
        }
    }

    public void render(ThrownItemRenderState state, class_4587 matrices, class_4597 vcp, int light) {
        matrices.method_22903();
        if (state.isEmbedded) {
            matrices.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(90.0f - state.embedYawDeg));
            matrices.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(-state.embedPitchDeg));
            matrices.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(state.embedTiltDeg));
            matrices.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(state.embedRollDeg));
            matrices.method_22905(this.scale, this.scale, this.scale);
            matrices.method_22905(1.0f, 1.0f, -1.0f);
            try {
                this.itemRenderer.method_23177((class_1309)class_310.method_1551().field_1724, state.itemStack, class_811.field_4322, matrices, vcp, (class_1937)class_310.method_1551().field_1687, light, class_4608.field_21444, 0);
            }
            catch (Exception e) {
                System.err.println("VR Throwing Extensions: Could not render embedded item: " + e.getMessage());
            }
            matrices.method_22909();
            super.method_3936((class_10017)state, matrices, vcp, light);
            return;
        }
        class_243 vel = state.velocity;
        if (vel.method_1033() > 0.001) {
            float yaw = (float)(class_3532.method_15349((double)vel.field_1350, (double)vel.field_1352) * 180.0 / Math.PI);
            matrices.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(90.0f - yaw));
            float hor = class_3532.method_15355((float)((float)(vel.field_1352 * vel.field_1352 + vel.field_1350 * vel.field_1350)));
            float pitch = (float)(class_3532.method_15349((double)vel.field_1351, (double)hor) * 180.0 / Math.PI);
            matrices.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(-pitch));
            matrices.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(-state.handRollDeg));
        }
        if (state.isCatching) {
            float smoothSpin = state.age * 5.0f % 360.0f;
            matrices.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(smoothSpin));
            float bobOffset = class_3532.method_15374((float)(state.age * 0.5f)) * 0.05f;
            matrices.method_46416(0.0f, bobOffset, 0.0f);
        } else if (state.isBounceActive) {
            float returnSpin = state.age * 8.0f % 360.0f;
            matrices.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(returnSpin));
            float wobble = class_3532.method_15374((float)(state.age * 0.35f)) * 3.0f;
            matrices.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(wobble));
            float pulseScale = 1.0f + class_3532.method_15374((float)(state.age * 0.4f)) * 0.05f;
            matrices.method_22905(pulseScale, pulseScale, pulseScale);
        } else {
            float spinSpeed = 15.0f;
            float spin = state.age * spinSpeed % 360.0f;
            matrices.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(spin));
        }
        matrices.method_22905(1.0f, 1.0f, -1.0f);
        matrices.method_22905(this.scale, this.scale, this.scale);
        try {
            this.itemRenderer.method_23177((class_1309)class_310.method_1551().field_1724, state.itemStack, class_811.field_4322, matrices, vcp, (class_1937)class_310.method_1551().field_1687, light, class_4608.field_21444, 0);
        }
        catch (Exception e) {
            System.err.println("VR Throwing Extensions: Could not render thrown item: " + e.getMessage());
        }
        matrices.method_22909();
        super.method_3936((class_10017)state, matrices, vcp, light);
    }

    public static class ThrownItemRenderState
    extends class_10017 {
        public class_1799 itemStack = class_1799.field_8037;
        public class_243 velocity = class_243.field_1353;
        public float age = 0.0f;
        public float handRollDeg = 0.0f;
        public boolean isCatching = false;
        public boolean isBounceActive = false;
        public boolean isEmbedded = false;
        public float embedYawDeg = 0.0f;
        public float embedPitchDeg = 0.0f;
        public float embedRollDeg = 0.0f;
        public float embedTiltDeg = 0.0f;
    }
}

