/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.client.particles;

import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2390;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import win.demistorm.VRThrowingExtensions;
import win.demistorm.client.config.ClientOnlyConfig;
import win.demistorm.network.BloodParticleData;

public final class BloodParticle {
    private static final int particleCount = 32;
    private static final int particleVariation = 6;
    private static final double coneAngleBase = 12.0;
    private static final double coneAngleVariation = 10.0;
    private static final double mistSpread = 0.2;
    private static final double mistVelMultiplier = 0.3;
    private static final double dropletRatio = 0.6;
    private static final double dropletSideJitter = 0.12;
    private static final double dropletSpeedScale = 1.0;
    private static final float scaleBase = 1.0f;
    private static final float scaleVariation = 0.4f;

    public static void spawnParticles(BloodParticleData data) {
        if (!ClientOnlyConfig.ACTIVE.bloodEffect) {
            VRThrowingExtensions.log.debug("[Blood Effect] Blood particles disabled by config, skipping spawn at ({}, {}, {})", new Object[]{data.posX(), data.posY(), data.posZ()});
            return;
        }
        VRThrowingExtensions.log.debug("[Blood Effect] Spawning blood particles at ({}, {}, {}) with velocity ({}, {}, {})", new Object[]{data.posX(), data.posY(), data.posZ(), data.velX(), data.velY(), data.velZ()});
        class_243 pos = new class_243(data.posX(), data.posY(), data.posZ());
        class_243 velocity = new class_243(data.velX(), data.velY(), data.velZ());
        BloodParticle.spawnBloodParticles(pos, velocity);
    }

    private static void spawnBloodParticles(class_243 pos, class_243 velocity) {
        class_310 client = class_310.method_1551();
        if (client.field_1687 == null) {
            return;
        }
        ThreadLocalRandom rng = ThreadLocalRandom.current();
        double speed = velocity.method_1033();
        class_243 forward = BloodParticle.normalizeSafely(velocity, new class_243(0.0, 0.0, -1.0));
        Basis basis = BloodParticle.makePerpendicularBasis(forward);
        double coneDeg = 12.0 + rng.nextDouble() * 10.0;
        int count = 32 + rng.nextInt(-6, 7);
        for (int i = 0; i < count; ++i) {
            class_243 vel;
            boolean spawnDroplet;
            double ox = rng.nextDouble(-0.15, 0.15);
            double oy = rng.nextDouble(-0.15, 0.15);
            double oz = rng.nextDouble(-0.15, 0.15);
            class_243 sprayForward = BloodParticle.randomDirectionCone(basis, coneDeg, rng);
            float r = 0.6f + (float)rng.nextDouble(0.0, 0.4);
            float g = (float)rng.nextDouble(0.0, 0.1);
            float b = (float)rng.nextDouble(0.0, 0.05);
            float scale = 1.0f + (float)rng.nextDouble(-0.2f, 0.2f);
            boolean bl = spawnDroplet = rng.nextDouble() < 0.6;
            if (spawnDroplet) {
                double jitterU = rng.nextDouble(-0.12, 0.12);
                double jitterV = rng.nextDouble(-0.12, 0.12);
                class_243 jitter = basis.u.method_1021(jitterU).method_1019(basis.v.method_1021(jitterV));
                vel = sprayForward.method_1021(speed * 1.0).method_1019(jitter);
                client.field_1687.method_8406((class_2394)new class_2392(class_2398.field_11218, new class_1799((class_1935)class_1802.field_8264)), pos.field_1352 + ox, pos.field_1351 + oy, pos.field_1350 + oz, vel.field_1352, vel.field_1351, vel.field_1350);
                continue;
            }
            double mistU = rng.nextDouble(-0.2, 0.2);
            double mistV = rng.nextDouble(-0.2, 0.2);
            class_243 sideways = basis.u.method_1021(mistU).method_1019(basis.v.method_1021(mistV));
            vel = sprayForward.method_1021(0.3 * speed).method_1019(sideways);
            int packedColor = BloodParticle.packColor(r, g, b);
            class_2390 blood = new class_2390(packedColor, scale);
            client.field_1687.method_8406((class_2394)blood, pos.field_1352 + ox, pos.field_1351 + oy, pos.field_1350 + oz, vel.field_1352, vel.field_1351, vel.field_1350);
        }
    }

    private static class_243 normalizeSafely(class_243 v, class_243 fallback) {
        double len2 = v.method_1027();
        if (len2 < 1.0E-8) {
            return fallback;
        }
        return v.method_1021(1.0 / Math.sqrt(len2));
    }

    private static Basis makePerpendicularBasis(class_243 forward) {
        class_243 f = BloodParticle.normalizeSafely(forward, new class_243(0.0, 0.0, -1.0));
        class_243 up = Math.abs(f.field_1351) < 0.999 ? new class_243(0.0, 1.0, 0.0) : new class_243(1.0, 0.0, 0.0);
        class_243 u = f.method_1036(up);
        u = BloodParticle.normalizeSafely(u, new class_243(1.0, 0.0, 0.0));
        class_243 v = f.method_1036(u);
        return new Basis(f, u, v);
    }

    private static class_243 randomDirectionCone(Basis basis, double maxAngleDegrees, ThreadLocalRandom rng) {
        double maxRad = Math.toRadians(maxAngleDegrees);
        double cosAlpha = class_3532.method_16436((double)rng.nextDouble(), (double)Math.cos(maxRad), (double)1.0);
        double sinAlpha = Math.sqrt(Math.max(0.0, 1.0 - cosAlpha * cosAlpha));
        double theta = rng.nextDouble(0.0, Math.PI * 2);
        double ct = Math.cos(theta);
        double st = Math.sin(theta);
        class_243 lateral = basis.u.method_1021(ct).method_1019(basis.v.method_1021(st));
        return basis.f.method_1021(cosAlpha).method_1019(lateral.method_1021(sinAlpha)).method_1029();
    }

    private static int packColor(float r, float g, float b) {
        int ri = Math.max(0, Math.min(255, (int)(r * 255.0f)));
        int gi = Math.max(0, Math.min(255, (int)(g * 255.0f)));
        int bi = Math.max(0, Math.min(255, (int)(b * 255.0f)));
        return ri << 16 | gi << 8 | bi;
    }

    private BloodParticle() {
    }

    private record Basis(class_243 f, class_243 u, class_243 v) {
    }
}

