/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.client;

import java.util.Comparator;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.api.VRAPI;
import org.vivecraft.api.client.Tracker;
import org.vivecraft.api.client.VRClientAPI;
import org.vivecraft.api.data.VRBodyPart;
import org.vivecraft.api.data.VRBodyPartData;
import org.vivecraft.api.data.VRPose;
import org.vivecraft.api.data.VRPoseHistory;
import win.demistorm.ModCompat;
import win.demistorm.ThrownProjectileEntity;
import win.demistorm.VRThrowingExtensions;
import win.demistorm.client.AimHelper;
import win.demistorm.client.ClientNetworkHelper;

public class ThrowHelper {
    private static boolean active = false;
    private static boolean catchActive = false;
    private static boolean throwWholeStack = false;
    private static boolean cancelBreaking = false;
    private static class_1799 heldItem = class_1799.field_8037;
    private static ThrownProjectileEntity targetProjectile = null;
    private static int ticksHeld = 0;
    private static int catchTicksHeld = 0;
    private static final double minThrowDistance = 0.08;
    private static final int maxPoseHistoryTicks = 6;
    private static final double speedThreshold = 0.1;
    private static final double throwVelocityThreshold = 0.06;
    private static final double weakVelThreshold = 0.06;
    private static final double strongVelThreshold = 0.3;
    private static final double weakMultiplier = 3.5;
    private static final double strongMultiplier = 8.0;
    private static final double catchMaxDistance = 3.0;
    private static final double catchMagnetStrength = 0.1;
    private static final double catchCompletionDistance = 0.2;
    private static final int minCatchTicks = 3;

    public static boolean cancellingBreaks() {
        return active && cancelBreaking || catchActive;
    }

    public static boolean cancellingUse() {
        return active;
    }

    private static double calculateVelocityMultiplier(double velocity) {
        if (velocity <= 0.06) {
            return 3.5;
        }
        if (velocity >= 0.3) {
            return 8.0;
        }
        double t = (velocity - 0.06) / 0.24;
        t *= t;
        return 3.5 + t * 4.5;
    }

    private static boolean throwCatching(class_746 player, boolean attackPressed) {
        class_1799 activeStack = player.method_6047();
        if (!activeStack.method_7960()) {
            if (catchActive) {
                ThrowHelper.cancelCatch();
                VRThrowingExtensions.log.debug("[VR Catch] Canceled: Player switched to occupied slot");
            }
            return false;
        }
        VRPose pose = VRClientAPI.instance().getPreTickWorldPose();
        if (pose == null) {
            return catchActive;
        }
        VRBodyPartData hand = pose.getHand(class_1268.field_5808);
        if (hand == null) {
            return catchActive;
        }
        class_243 handPos = hand.getPos();
        if (!catchActive && attackPressed) {
            ThrownProjectileEntity nearestProjectile = ThrowHelper.findNearestProjectile(player, handPos);
            if (nearestProjectile != null) {
                ThrowHelper.startCatch(nearestProjectile);
                VRThrowingExtensions.log.debug("[VR Catch] Started catching projectile...");
                return true;
            }
        } else {
            if (catchActive && attackPressed) {
                if (targetProjectile == null || targetProjectile.method_31481()) {
                    ThrowHelper.cancelCatch();
                    VRThrowingExtensions.log.debug("[VR Catch] Canceled: Target projectile no longer exists");
                    return false;
                }
                ThrowHelper.updateCatchMagnetism(handPos, hand.getRotation());
                double distanceToHand = targetProjectile.method_73189().method_1022(handPos);
                if (distanceToHand <= 0.2 && ++catchTicksHeld >= 3) {
                    ThrowHelper.completeCatch();
                    VRThrowingExtensions.log.debug("[VR Catch] Completed catch!");
                    return false;
                }
                return true;
            }
            if (catchActive) {
                ThrowHelper.cancelCatch();
                VRThrowingExtensions.log.debug("[VR Catch] Canceled: Attack button released");
                return false;
            }
        }
        return catchActive;
    }

    private static ThrownProjectileEntity findNearestProjectile(class_746 player, class_243 handPos) {
        class_243 min = handPos.method_1023(3.0, 3.0, 3.0);
        class_243 max = handPos.method_1031(3.0, 3.0, 3.0);
        class_238 searchBox = new class_238(min, max);
        return player.method_73183().method_8390(ThrownProjectileEntity.class, searchBox, entity -> {
            if (entity.method_31481()) {
                return false;
            }
            double distance = entity.method_73189().method_1022(handPos);
            return distance <= 3.0;
        }).stream().min(Comparator.comparingDouble(e -> e.method_73189().method_1022(handPos))).orElse(null);
    }

    private static void startCatch(ThrownProjectileEntity projectile) {
        catchActive = true;
        targetProjectile = projectile;
        catchTicksHeld = 0;
        ClientNetworkHelper.sendCatchToServer(projectile, true);
    }

    private static void updateCatchMagnetism(class_243 handPos, Quaternionfc handRotation) {
        if (targetProjectile == null) {
            return;
        }
        class_243 projectilePos = targetProjectile.method_73189();
        class_243 toHand = handPos.method_1020(projectilePos);
        double distance = toHand.method_1033();
        if (distance > 0.001) {
            class_243 magnetEffect = toHand.method_1029().method_1021(0.1);
            class_243 currentVel = targetProjectile.method_18798();
            class_243 newVel = currentVel.method_1021(0.6).method_1019(magnetEffect);
            ClientNetworkHelper.sendCatchUpdateToServer(targetProjectile, newVel, handRotation);
        }
    }

    private static void completeCatch() {
        if (targetProjectile == null) {
            return;
        }
        ClientNetworkHelper.sendCatchCompleteToServer(targetProjectile);
        ThrowHelper.resetCatch();
        VRClientAPI.instance().triggerHapticPulse(VRBodyPart.fromInteractionHand((class_1268)class_1268.field_5808), 0.5f);
    }

    private static void cancelCatch() {
        if (targetProjectile != null) {
            ClientNetworkHelper.sendCatchToServer(targetProjectile, false);
        }
        ThrowHelper.resetCatch();
    }

    private static class_243 historicalHandPosition(VRPoseHistory hist) {
        try {
            VRPose pose2 = hist.getHistoricalData(2);
            VRBodyPartData hand2 = pose2.getHand(class_1268.field_5808);
            if (hand2 != null) {
                return hand2.getPos();
            }
        }
        catch (IllegalArgumentException pose2) {
            // empty catch block
        }
        VRPose now = VRClientAPI.instance().getPreTickWorldPose();
        assert (now != null);
        return now.getHand(class_1268.field_5808).getPos();
    }

    private static void resetCatch() {
        catchActive = false;
        targetProjectile = null;
        catchTicksHeld = 0;
    }

    private static void reset() {
        active = false;
        throwWholeStack = false;
        cancelBreaking = false;
        heldItem = class_1799.field_8037;
        ticksHeld = 0;
    }

    public static class ThrowTracker
    implements Tracker {
        public Tracker.ProcessType processType() {
            return Tracker.ProcessType.PER_TICK;
        }

        public boolean isActive(class_746 player) {
            return player != null && VRAPI.instance().isVRPlayer((class_1657)player);
        }

        public void activeProcess(class_746 player) {
            class_310 mc = class_310.method_1551();
            if (player == null || !VRAPI.instance().isVRPlayer((class_1657)player)) {
                return;
            }
            boolean attackPressed = mc.field_1690.field_1886.method_1434();
            boolean placePressed = mc.field_1690.field_1904.method_1434();
            if (ThrowHelper.throwCatching(player, attackPressed)) {
                return;
            }
            if (!active && attackPressed) {
                class_1799 held = player.method_6047();
                if (ModCompat.throwingDisabled(held)) {
                    return;
                }
                heldItem = held.method_7972();
                ticksHeld = 0;
                active = true;
                throwWholeStack = placePressed;
                cancelBreaking = false;
                VRThrowingExtensions.log.debug("[VR Throw] Hold trace started with item: {}", (Object)heldItem);
            } else if (active && attackPressed) {
                double speed;
                VRPoseHistory hist;
                ticksHeld = Math.min(ticksHeld + 1, 6);
                throwWholeStack |= placePressed;
                if (!cancelBreaking && (hist = VRAPI.instance().getHistoricalVRPoses((class_1657)player)) != null && (speed = hist.averageSpeed(VRBodyPart.MAIN_HAND, 2, true)) > 0.1) {
                    cancelBreaking = true;
                    VRThrowingExtensions.log.debug("[VR Throw] speed threshold crossed, mining blocked");
                }
            } else if (active) {
                if (ticksHeld >= 5) {
                    int usedTicks;
                    class_243 handMovement;
                    VRPoseHistory history = VRAPI.instance().getHistoricalVRPoses((class_1657)player);
                    if (history != null && (handMovement = history.netMovement(VRBodyPart.MAIN_HAND, usedTicks = Math.min(ticksHeld, 6), true)) != null) {
                        double relativeMovedDist = handMovement.method_1033();
                        if (relativeMovedDist > 0.08) {
                            class_243 relativeVel = history.averageVelocity(VRBodyPart.MAIN_HAND, usedTicks, true);
                            if (relativeVel != null) {
                                double velLength = relativeVel.method_1033();
                                if (velLength >= 0.06) {
                                    class_243 origin = ThrowHelper.historicalHandPosition(history);
                                    double dynamicMultiplier = ThrowHelper.calculateVelocityMultiplier(velLength);
                                    class_243 launchVel = relativeVel.method_1021(dynamicMultiplier);
                                    class_243 assistedVel = AimHelper.applyAimAssist(player, origin, launchVel);
                                    VRPose pose = VRClientAPI.instance().getPreTickWorldPose();
                                    assert (pose != null);
                                    VRBodyPartData hand = pose.getHand(class_1268.field_5808);
                                    Quaternionfc q = hand.getRotation();
                                    Vector3f fwd = new Vector3f(0.0f, 0.0f, -1.0f).rotate(q).normalize();
                                    Vector3f up = new Vector3f(0.0f, 1.0f, 0.0f).rotate(q).normalize();
                                    Vector3f projCtrlUp = up.sub((Vector3fc)new Vector3f((Vector3fc)fwd).mul(up.dot((Vector3fc)fwd))).normalize();
                                    Vector3f projWorldUp = new Vector3f(0.0f, 1.0f, 0.0f).sub((Vector3fc)new Vector3f((Vector3fc)fwd).mul(fwd.y)).normalize();
                                    float rollRad = projCtrlUp.angleSigned((Vector3fc)projWorldUp, (Vector3fc)fwd);
                                    float rollDeg = (float)Math.toDegrees(rollRad);
                                    try {
                                        ClientNetworkHelper.sendToServer(origin, assistedVel, throwWholeStack, rollDeg);
                                    }
                                    catch (Exception e) {
                                        VRThrowingExtensions.log.error("Error sending throw packet to server: {}", (Object)e.getMessage());
                                        ThrowHelper.reset();
                                        return;
                                    }
                                    VRClientAPI.instance().triggerHapticPulse(VRBodyPart.fromInteractionHand((class_1268)class_1268.field_5808), 0.2f);
                                } else {
                                    VRThrowingExtensions.log.debug("[VR Throw] Relative velocity too slow: {}", (Object)velLength);
                                }
                            }
                        } else {
                            VRThrowingExtensions.log.debug("[VR Throw] Insufficient relative movement: {}", (Object)relativeMovedDist);
                        }
                    }
                } else {
                    VRThrowingExtensions.log.debug("[VR Throw] Released too early. Held {} ticks.", (Object)ticksHeld);
                }
                ThrowHelper.reset();
            }
        }

        public void inactiveProcess(class_746 player) {
        }
    }
}

