/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.client.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import win.demistorm.VRThrowingExtensions;

public final class ClientOnlyConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIGDIR = Path.of("config", new String[0]);
    private static final Path FILE = CONFIGDIR.resolve("vr_throwing_extensions-client.json");
    public static final Data ACTIVE = new Data();

    public static void loadOrCreate() {
        Data d = ClientOnlyConfig.read();
        ClientOnlyConfig.write(d);
        ClientOnlyConfig.ACTIVE.bloodEffect = d.bloodEffect;
        VRThrowingExtensions.log.info("[Config] Blood effect setting loaded: {}", (Object)(ClientOnlyConfig.ACTIVE.bloodEffect ? "ENABLED" : "DISABLED"));
    }

    private static Data read() {
        try {
            if (Files.exists(FILE, new LinkOption[0])) {
                return (Data)GSON.fromJson(Files.readString(FILE), Data.class);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new Data();
    }

    public static void write(Data d) {
        try {
            Files.createDirectories(CONFIGDIR, new FileAttribute[0]);
            Files.writeString(FILE, (CharSequence)GSON.toJson((Object)d), new OpenOption[0]);
        }
        catch (IOException e) {
            VRThrowingExtensions.log.error("Unable to write client-only config!", (Throwable)e);
        }
    }

    private ClientOnlyConfig() {
    }

    public static final class Data {
        public boolean bloodEffect = true;
    }
}

