/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.neoforge;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import win.demistorm.ConfigHelper;
import win.demistorm.Platform;
import win.demistorm.VRThrowingExtensions;
import win.demistorm.client.VRThrowingExtensionsClient;
import win.demistorm.network.BleedingParticleData;
import win.demistorm.network.BloodParticleData;
import win.demistorm.network.ConfigSyncData;
import win.demistorm.network.NetworkHandlers;

public class ClientSetup {
    public static void doClientSetup() {
        VRThrowingExtensionsClient.initializeClient();
        Platform.registerClientInputEventHandlers();
    }

    public static void handleNetworkPacket(RegistryFriendlyByteBuf buffer) {
        Minecraft client = Minecraft.getInstance();
        if (client.player == null) {
            return;
        }
        FriendlyByteBuf friendlyBuf = new FriendlyByteBuf((ByteBuf)buffer);
        int packetId = friendlyBuf.readInt();
        switch (packetId) {
            case 4: {
                BloodParticleData bloodData = new BloodParticleData(friendlyBuf.readDouble(), friendlyBuf.readDouble(), friendlyBuf.readDouble(), friendlyBuf.readDouble(), friendlyBuf.readDouble(), friendlyBuf.readDouble());
                VRThrowingExtensions.log.debug("[NeoForge Client] Received blood particle packet ID 4 at ({}, {}, {})", new Object[]{bloodData.posX(), bloodData.posY(), bloodData.posZ()});
                NetworkHandlers.handleBloodParticle((Player)client.player, bloodData);
                break;
            }
            case 5: {
                BleedingParticleData bleedingData = new BleedingParticleData(friendlyBuf.readDouble(), friendlyBuf.readDouble(), friendlyBuf.readDouble());
                VRThrowingExtensions.log.debug("[NeoForge Client] Received bleeding particle packet ID 5 at ({}, {}, {})", new Object[]{bleedingData.posX(), bleedingData.posY(), bleedingData.posZ()});
                NetworkHandlers.handleBleedingParticle((Player)client.player, bleedingData);
                break;
            }
            case 6: {
                int length = friendlyBuf.readVarInt();
                String json = friendlyBuf.readUtf(length);
                ConfigSyncData configData = new ConfigSyncData(json);
                NetworkHandlers.handleConfigSync((Player)client.player, configData);
                break;
            }
            default: {
                VRThrowingExtensions.log.warn("[NeoForge Client] Received unknown packet ID: {}", (Object)packetId);
            }
        }
    }

    @SubscribeEvent
    public static void onClientLoggingOut(ClientPlayerNetworkEvent.LoggingOut event) {
        ConfigHelper.clientDisconnected();
        VRThrowingExtensions.log.debug("NeoForge client disconnected, restored local config");
    }
}

