/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm;

import com.google.common.collect.Multimap;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import win.demistorm.ConfigHelper;
import win.demistorm.VRThrowingExtensions;
import win.demistorm.WeaponEffectType;
import win.demistorm.effects.BoomerangEffect;
import win.demistorm.effects.EmbeddingEffect;
import win.demistorm.network.BloodParticleData;
import win.demistorm.network.Network;

public class ThrownProjectileEntity
extends ThrowableItemProjectile {
    private int stackSize = 1;
    public boolean catching = false;
    private Vec3 storedVelocity = Vec3.f_82478_;
    private int immunityTicks = 20;
    private int bounceReturnTicks = 0;
    private boolean reachedOriginOnce = false;
    public Vec3 originalThrowPos = Vec3.f_82478_;
    public boolean hasBounced = false;
    public boolean bounceActive = false;
    public Vec3 bounceCurveOffset = Vec3.f_82478_;
    public Vec3 bouncePlaneNormal = Vec3.f_82478_;
    public double bounceArcMag = 0.0;
    public boolean bounceInverse = true;
    private LivingEntity embeddedTarget = null;
    private Vec3 embeddedOffset = Vec3.f_82478_;
    private boolean alreadyDropped = false;
    private float embeddedLocalYaw = 0.0f;
    private float embeddedLocalPitch = 0.0f;
    private boolean damageDealt = false;
    private static final EntityDataAccessor<Float> HAND_ROLL = SynchedEntityData.m_135353_(ThrownProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> IS_CATCHING = SynchedEntityData.m_135353_(ThrownProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> BOUNCE_ACTIVE = SynchedEntityData.m_135353_(ThrownProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_EMBEDDED = SynchedEntityData.m_135353_(ThrownProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> EMBED_YAW = SynchedEntityData.m_135353_(ThrownProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> EMBED_PITCH = SynchedEntityData.m_135353_(ThrownProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> EMBED_ROLL = SynchedEntityData.m_135353_(ThrownProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> EMBED_TILT = SynchedEntityData.m_135353_(ThrownProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);

    public ThrownProjectileEntity(EntityType<? extends ThrowableItemProjectile> type, Level level) {
        super(type, level);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HAND_ROLL, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(IS_CATCHING, (Object)false);
        this.f_19804_.m_135372_(BOUNCE_ACTIVE, (Object)false);
        this.f_19804_.m_135372_(IS_EMBEDDED, (Object)false);
        this.f_19804_.m_135372_(EMBED_YAW, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(EMBED_PITCH, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(EMBED_ROLL, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(EMBED_TILT, (Object)Float.valueOf(0.0f));
    }

    public ThrownProjectileEntity(Level level, LivingEntity owner, ItemStack carried, boolean isWholeStack) {
        super(VRThrowingExtensions.THROWN_ITEM_TYPE, level);
        this.m_5602_((Entity)owner);
        this.m_37446_(carried.m_255036_(1));
        this.stackSize = isWholeStack ? carried.m_41613_() : 1;
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (this.m_9236_().f_46443_ && this.f_19797_ < 40) {
            VRThrowingExtensions.log.debug("[Client] Data updated for {}: item now {}", (Object)this.m_19879_(), (Object)this.m_7846_());
        }
    }

    public void setHandRoll(float deg) {
        this.f_19804_.m_135381_(HAND_ROLL, (Object)Float.valueOf(deg));
    }

    public float getHandRoll() {
        return ((Float)this.f_19804_.m_135370_(HAND_ROLL)).floatValue();
    }

    public void startCatch() {
        EmbeddingEffect.releaseEmbedding(this);
        this.catching = true;
        this.storedVelocity = this.m_20184_();
        this.f_19804_.m_135381_(IS_CATCHING, (Object)true);
        this.m_20242_(true);
        VRThrowingExtensions.log.debug("[VR Catch] Started catch for projectile {}", (Object)this.m_19879_());
    }

    public void cancelCatch() {
        this.catching = false;
        this.f_19804_.m_135381_(IS_CATCHING, (Object)false);
        this.m_20242_(false);
        if (this.storedVelocity.m_82553_() > 0.1) {
            this.m_20256_(this.storedVelocity.m_82490_(0.5));
        }
        VRThrowingExtensions.log.debug("[VR Catch] Canceled catch for projectile {}", (Object)this.m_19879_());
    }

    public boolean isCatching() {
        return (Boolean)this.f_19804_.m_135370_(IS_CATCHING);
    }

    public boolean isBounceActive() {
        return (Boolean)this.f_19804_.m_135370_(BOUNCE_ACTIVE);
    }

    public int getStackSize() {
        return this.stackSize;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.immunityTicks > 0) {
            --this.immunityTicks;
        }
        if (this.isEmbedded() && !this.isCatching()) {
            EmbeddingEffect.tickEmbedded(this);
            return;
        }
        if (this.bounceActive && !this.isCatching()) {
            ++this.bounceReturnTicks;
            if (BoomerangEffect.tickReturn(this)) {
                this.bounceActive = false;
                this.reachedOriginOnce = true;
                this.f_19804_.m_135381_(BOUNCE_ACTIVE, (Object)false);
                this.m_20242_(false);
                Vec3 returnVel = this.m_20184_();
                double currentSpeed = returnVel.m_82553_();
                if (currentSpeed > 1.0) {
                    returnVel = returnVel.m_82541_().m_82490_(Math.min(currentSpeed, 1.0));
                }
                this.m_20256_(returnVel);
                VRThrowingExtensions.log.debug("[VR Throw] Projectile {} completed return after {} ticks, vel {}", new Object[]{this.m_19879_(), this.bounceReturnTicks, returnVel});
            }
            if (this.bounceReturnTicks > 200) {
                VRThrowingExtensions.log.debug("[VR Throw] Projectile {} return timed out, dropping", (Object)this.m_19879_());
                this.stopBoomerang();
            }
        }
        if (this.isCatching()) {
            Vec3 vel = this.m_20184_();
            this.m_20256_(vel.m_82490_(0.95));
        }
    }

    private void stopBoomerang() {
        this.bounceActive = false;
        this.f_19804_.m_135381_(BOUNCE_ACTIVE, (Object)false);
        this.m_20242_(false);
        Vec3 currentVel = this.m_20184_();
        double horizontalSpeed = Math.sqrt(currentVel.f_82479_ * currentVel.f_82479_ + currentVel.f_82481_ * currentVel.f_82481_);
        if (horizontalSpeed > 0.5) {
            double factor = 0.3 / horizontalSpeed;
            this.m_20256_(new Vec3(currentVel.f_82479_ * factor, -0.2, currentVel.f_82481_ * factor));
        } else {
            this.m_20256_(new Vec3(currentVel.f_82479_ * 0.5, -0.2, currentVel.f_82481_ * 0.5));
        }
    }

    protected void m_6532_(HitResult hit) {
        EntityHitResult ehr;
        Entity target;
        if (this.isCatching()) {
            return;
        }
        if (this.immunityTicks > 0 && hit.m_6662_() == HitResult.Type.ENTITY && (target = (ehr = (EntityHitResult)hit).m_82443_()) == this.m_19749_()) {
            VRThrowingExtensions.log.debug("[VR Throw] Projectile {} ignoring owner collision (immunity: {} ticks)", (Object)this.m_19879_(), (Object)this.immunityTicks);
            return;
        }
        Vec3 hitPos = null;
        if (hit.m_6662_() == HitResult.Type.ENTITY) {
            EntityHitResult entityHit = (EntityHitResult)hit;
            Entity target2 = entityHit.m_82443_();
            AABB targetBox = target2.m_20191_();
            Vec3 projPos = this.m_20182_();
            double hitX = Mth.m_14008_((double)projPos.f_82479_, (double)targetBox.f_82288_, (double)targetBox.f_82291_);
            double hitY = Mth.m_14008_((double)projPos.f_82480_, (double)targetBox.f_82289_, (double)targetBox.f_82292_);
            double hitZ = Mth.m_14008_((double)projPos.f_82481_, (double)targetBox.f_82290_, (double)targetBox.f_82293_);
            hitPos = new Vec3(hitX, hitY, hitZ);
        }
        if (this.bounceActive || this.hasBounced) {
            if (hit.m_6662_() == HitResult.Type.ENTITY) {
                this.onHitEntity((EntityHitResult)hit, hitPos);
                VRThrowingExtensions.log.debug("[VR Throw] Projectile {} hit entity during return, dropping", (Object)this.m_19879_());
            } else {
                VRThrowingExtensions.log.debug("[VR Throw] Projectile {} hit block during return, dropping", (Object)this.m_19879_());
            }
            this.dropAndDiscard();
            return;
        }
        if (!this.m_9236_().f_46443_) {
            boolean hitEntity;
            boolean bl = hitEntity = hit.m_6662_() == HitResult.Type.ENTITY;
            if (hitEntity) {
                EntityHitResult entityHit = (EntityHitResult)hit;
                this.onHitEntity(entityHit, hitPos);
                float attackDamage = ThrownProjectileEntity.stackBaseDamage(this.m_7846_());
                if (attackDamage <= 1.0f) {
                    this.dropAndDiscard();
                    return;
                }
                if (ConfigHelper.ACTIVE.weaponEffect == WeaponEffectType.BOOMERANG) {
                    boolean shouldBounce;
                    boolean bl2 = shouldBounce = BoomerangEffect.canBounce(this.m_7846_().m_41720_()) && !this.hasBounced && !this.reachedOriginOnce;
                    if (shouldBounce) {
                        VRThrowingExtensions.log.debug("[VR Throw] Starting boomerang effect for {}", (Object)this.m_19879_());
                        BoomerangEffect.startBounce(this);
                        this.bounceActive = true;
                        this.f_19804_.m_135381_(BOUNCE_ACTIVE, (Object)true);
                        return;
                    }
                } else if (ConfigHelper.ACTIVE.weaponEffect == WeaponEffectType.EMBED) {
                    if (this.damageDealt) {
                        EmbeddingEffect.startEmbedding(this, entityHit, hitPos);
                        return;
                    }
                    VRThrowingExtensions.log.debug("[VR Throw] Damage blocked, not embedding projectile {}", (Object)this.m_19879_());
                }
            }
            this.dropAndDiscard();
        } else {
            this.m_9236_().m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, this.m_7846_()), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        }
    }

    protected void onHitEntity(EntityHitResult res, Vec3 hitPos) {
        Entity target = res.m_82443_();
        ServerLevel world = (ServerLevel)this.m_9236_();
        DamageSource src = world.m_269111_().m_269390_((Entity)this, (Entity)(this.m_19749_() == null ? this : this.m_19749_()));
        float base = ThrownProjectileEntity.stackBaseDamage(this.m_7846_());
        float enchBonus = ThrownProjectileEntity.getEnchantmentDamageBonus(this.m_7846_(), target);
        float total = base + enchBonus;
        VRThrowingExtensions.log.debug("[VR Throw] Damage dealt: Item={}, Base={}, Ench={}, Final={}, Target={}, State={}", new Object[]{this.m_7846_().m_41720_(), Float.valueOf(base), Float.valueOf(enchBonus), Float.valueOf(total), target.m_7755_().getString(), this.bounceActive ? "RETURNING" : "FORWARD"});
        this.damageDealt = target.m_6469_(src, total);
        VRThrowingExtensions.log.debug("[VR Throw] Damage result: dealt={}, target={}", (Object)this.damageDealt, (Object)target.m_7755_().getString());
        Vec3 velocity = this.m_20184_();
        int playersSent = 0;
        for (ServerPlayer player : world.m_7654_().m_6846_().m_11314_()) {
            if (player.m_9236_() != world || !(player.m_20238_(hitPos) < 4096.0)) continue;
            Network.INSTANCE.sendToPlayer(player, new BloodParticleData(hitPos.f_82479_, hitPos.f_82480_, hitPos.f_82481_, velocity.f_82479_, velocity.f_82480_, velocity.f_82481_));
            ++playersSent;
        }
        VRThrowingExtensions.log.debug("[Server] Sent blood particle packet to {} players at ({}, {}, {})", new Object[]{playersSent, hitPos.f_82479_, hitPos.f_82480_, hitPos.f_82481_});
        Vec3 push = this.m_20184_().m_82541_().m_82490_(0.5);
        target.m_5997_(push.f_82479_, 0.1 + push.f_82480_, push.f_82481_);
    }

    private ItemStack createDropStack() {
        ItemStack drop = this.m_7846_().m_41777_();
        if (drop.m_41763_()) {
            int totalDamage = Mth.m_14045_((int)(drop.m_41773_() + this.stackSize), (int)0, (int)drop.m_41776_());
            drop.m_41721_(totalDamage);
        }
        return drop;
    }

    public static float stackBaseDamage(ItemStack stack) {
        float baseDamage = 1.0f;
        Multimap modifiers = stack.m_41638_(EquipmentSlot.MAINHAND);
        for (Attribute attribute : modifiers.keySet()) {
            if (!attribute.equals(Attributes.f_22281_)) continue;
            for (AttributeModifier modifier : modifiers.get((Object)attribute)) {
                double amount = modifier.m_22218_();
                AttributeModifier.Operation operation = modifier.m_22217_();
                if (operation == AttributeModifier.Operation.ADDITION) {
                    baseDamage += (float)amount;
                    continue;
                }
                if (operation == AttributeModifier.Operation.MULTIPLY_BASE) {
                    baseDamage += (float)((double)baseDamage * amount);
                    continue;
                }
                if (operation != AttributeModifier.Operation.MULTIPLY_TOTAL) continue;
                baseDamage *= (float)(1.0 + amount);
            }
        }
        return Math.max(1.0f, baseDamage);
    }

    private static float getEnchantmentDamageBonus(ItemStack stack, Entity target) {
        MobType mobType = target instanceof LivingEntity ? ((LivingEntity)target).m_6336_() : MobType.f_21640_;
        return EnchantmentHelper.m_44833_((ItemStack)stack, (MobType)mobType);
    }

    public void clearSpawnImmunity() {
        this.immunityTicks = 0;
        VRThrowingExtensions.log.debug("[VR Throw] Projectile {} spawn immunity cleared", (Object)this.m_19879_());
    }

    @NotNull
    protected Item m_7881_() {
        return Items.f_42398_;
    }

    public void setOriginalThrowPos(Vec3 v) {
        this.originalThrowPos = v;
    }

    public void beginEmbedding(LivingEntity host, Vec3 worldOffset, float yawDeg, float pitchDeg, float tiltDeg, float initialXRollDeg) {
        Vec3 localOffset;
        this.embeddedTarget = host;
        this.m_20242_(true);
        this.m_20256_(Vec3.f_82478_);
        this.m_146884_(host.m_20182_().m_82549_(worldOffset));
        float hostBodyYaw = host.m_6080_();
        float hostPitch = host.m_146909_();
        this.embeddedOffset = localOffset = ThrownProjectileEntity.rotateY(worldOffset, -hostBodyYaw);
        this.embeddedLocalYaw = Mth.m_14177_((float)(yawDeg - hostBodyYaw));
        this.embeddedLocalPitch = Mth.m_14177_((float)(pitchDeg - hostPitch));
        this.f_19804_.m_135381_(IS_EMBEDDED, (Object)true);
        this.f_19804_.m_135381_(EMBED_YAW, (Object)Float.valueOf(yawDeg));
        this.f_19804_.m_135381_(EMBED_PITCH, (Object)Float.valueOf(pitchDeg));
        this.f_19804_.m_135381_(EMBED_ROLL, (Object)Float.valueOf(initialXRollDeg));
        this.f_19804_.m_135381_(EMBED_TILT, (Object)Float.valueOf(tiltDeg));
        VRThrowingExtensions.log.debug("[Embed] beginEmbedding: proj={} host={} worldOffset={} localOffset={} yaw={} pitch={} tilt={} xRollStart={}", new Object[]{this.m_19879_(), host.m_7755_().getString(), worldOffset, localOffset, String.format("%.1f", Float.valueOf(yawDeg)), String.format("%.1f", Float.valueOf(pitchDeg)), String.format("%.1f", Float.valueOf(tiltDeg)), String.format("%.1f", Float.valueOf(initialXRollDeg))});
    }

    public void clearEmbedding() {
        if (!this.m_9236_().m_5776_() && this.embeddedTarget != null) {
            EmbeddingEffect.BleedManager.unregister(this.embeddedTarget, this);
        }
        this.f_19804_.m_135381_(IS_EMBEDDED, (Object)false);
        this.embeddedTarget = null;
        this.embeddedOffset = Vec3.f_82478_;
        this.embeddedLocalYaw = 0.0f;
        this.embeddedLocalPitch = 0.0f;
        this.m_20242_(false);
    }

    public boolean isEmbedded() {
        return (Boolean)this.f_19804_.m_135370_(IS_EMBEDDED);
    }

    public float getEmbedYaw() {
        return ((Float)this.f_19804_.m_135370_(EMBED_YAW)).floatValue();
    }

    public float getEmbedPitch() {
        return ((Float)this.f_19804_.m_135370_(EMBED_PITCH)).floatValue();
    }

    public float getEmbedRoll() {
        return ((Float)this.f_19804_.m_135370_(EMBED_ROLL)).floatValue();
    }

    public void setEmbedRoll(float v) {
        this.f_19804_.m_135381_(EMBED_ROLL, (Object)Float.valueOf(v));
    }

    public float getEmbedTilt() {
        return ((Float)this.f_19804_.m_135370_(EMBED_TILT)).floatValue();
    }

    public Entity getEmbeddedTarget() {
        return this.embeddedTarget;
    }

    public Vec3 getEmbeddedOffset() {
        return this.embeddedOffset;
    }

    public float getEmbeddedLocalYaw() {
        return this.embeddedLocalYaw;
    }

    public float getEmbeddedLocalPitch() {
        return this.embeddedLocalPitch;
    }

    public void setEmbedYaw(float v) {
        this.f_19804_.m_135381_(EMBED_YAW, (Object)Float.valueOf(v));
    }

    public void setEmbedPitch(float v) {
        this.f_19804_.m_135381_(EMBED_PITCH, (Object)Float.valueOf(v));
    }

    private static Vec3 rotateY(Vec3 v, float degrees) {
        double rad = Math.toRadians(degrees);
        double cos = Math.cos(rad);
        double sin = Math.sin(rad);
        double x = v.f_82479_ * cos - v.f_82481_ * sin;
        double z = v.f_82479_ * sin + v.f_82481_ * cos;
        return new Vec3(x, v.f_82480_, z);
    }

    public void dropAndDiscard() {
        if (this.isEmbedded()) {
            this.clearEmbedding();
        }
        this.clearSpawnImmunity();
        if (this.alreadyDropped) {
            this.m_146870_();
            return;
        }
        this.alreadyDropped = true;
        if (!this.m_9236_().m_5776_()) {
            ItemStack dropStack = this.createDropStack();
            dropStack.m_41764_(this.stackSize);
            this.m_9236_().m_7967_((Entity)new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), dropStack));
        }
        this.m_146870_();
    }
}

