/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import win.demistorm.ThrownProjectileEntity;

public class ThrownItemRenderer
extends EntityRenderer<ThrownProjectileEntity> {
    private final ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
    private final float scale;

    public ThrownItemRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
        this.scale = 0.7f;
        this.f_114478_ = 0.0f;
    }

    public void render(ThrownProjectileEntity entity, float entityYaw, float tickDelta, PoseStack matrices, MultiBufferSource vcp, int light) {
        matrices.m_85836_();
        ItemStack itemStack = entity.m_7846_();
        Vec3 velocity = entity.m_20184_();
        float age = (float)entity.f_19797_ + tickDelta;
        float handRollDeg = entity.getHandRoll();
        boolean isCatching = entity.isCatching();
        boolean isBounceActive = entity.isBounceActive();
        boolean isEmbedded = entity.isEmbedded();
        if (isEmbedded) {
            matrices.m_252781_(Axis.f_252436_.m_252977_(90.0f - entity.getEmbedYaw()));
            matrices.m_252781_(Axis.f_252529_.m_252977_(-entity.getEmbedPitch()));
            matrices.m_252781_(Axis.f_252403_.m_252977_(entity.getEmbedTilt()));
            matrices.m_252781_(Axis.f_252529_.m_252977_(entity.getEmbedRoll()));
            matrices.m_85841_(this.scale, this.scale, this.scale);
            matrices.m_85841_(1.0f, 1.0f, -1.0f);
            try {
                this.itemRenderer.m_269128_(itemStack, ItemDisplayContext.FIRST_PERSON_RIGHT_HAND, light, OverlayTexture.f_118083_, matrices, vcp, (Level)Minecraft.m_91087_().f_91073_, 0);
            }
            catch (Exception e) {
                System.err.println("VR Throwing Extensions: Could not render embedded item: " + e.getMessage());
            }
            matrices.m_85849_();
            super.m_7392_((Entity)entity, entityYaw, tickDelta, matrices, vcp, light);
            return;
        }
        if (velocity.m_82553_() > 0.001) {
            float yaw = (float)(Mth.m_14136_((double)velocity.f_82481_, (double)velocity.f_82479_) * 180.0 / Math.PI);
            matrices.m_252781_(Axis.f_252436_.m_252977_(90.0f - yaw));
            float hor = Mth.m_14116_((float)((float)(velocity.f_82479_ * velocity.f_82479_ + velocity.f_82481_ * velocity.f_82481_)));
            float pitch = (float)(Mth.m_14136_((double)velocity.f_82480_, (double)hor) * 180.0 / Math.PI);
            matrices.m_252781_(Axis.f_252529_.m_252977_(-pitch));
            matrices.m_252781_(Axis.f_252403_.m_252977_(-handRollDeg));
        }
        if (isCatching) {
            float smoothSpin = age * 5.0f % 360.0f;
            matrices.m_252781_(Axis.f_252529_.m_252977_(smoothSpin));
            float bobOffset = Mth.m_14031_((float)(age * 0.5f)) * 0.05f;
            matrices.m_252880_(0.0f, bobOffset, 0.0f);
        } else if (isBounceActive) {
            float returnSpin = age * 8.0f % 360.0f;
            matrices.m_252781_(Axis.f_252529_.m_252977_(returnSpin));
            float wobble = Mth.m_14031_((float)(age * 0.35f)) * 3.0f;
            matrices.m_252781_(Axis.f_252436_.m_252977_(wobble));
            float pulseScale = 1.0f + Mth.m_14031_((float)(age * 0.4f)) * 0.05f;
            matrices.m_85841_(pulseScale, pulseScale, pulseScale);
        } else {
            float spinSpeed = 15.0f;
            float spin = age * spinSpeed % 360.0f;
            matrices.m_252781_(Axis.f_252529_.m_252977_(spin));
        }
        matrices.m_85841_(1.0f, 1.0f, -1.0f);
        matrices.m_85841_(this.scale, this.scale, this.scale);
        try {
            this.itemRenderer.m_269128_(itemStack, ItemDisplayContext.FIRST_PERSON_RIGHT_HAND, light, OverlayTexture.f_118083_, matrices, vcp, (Level)Minecraft.m_91087_().f_91073_, 0);
        }
        catch (Exception e) {
            System.err.println("VR Throwing Extensions: Could not render thrown item: " + e.getMessage());
        }
        matrices.m_85849_();
        super.m_7392_((Entity)entity, entityYaw, tickDelta, matrices, vcp, light);
    }

    @NotNull
    public ResourceLocation getTextureLocation(ThrownProjectileEntity entity) {
        return TextureAtlas.f_118259_;
    }
}

