/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.forge;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.PacketListener;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import win.demistorm.VRThrowingExtensions;
import win.demistorm.forge.ClientSetup;
import win.demistorm.network.Network;

public class BufferPacket
implements Packet<PacketListener> {
    private final FriendlyByteBuf buffer;

    public BufferPacket(FriendlyByteBuf buffer) {
        this.buffer = buffer;
    }

    public FriendlyByteBuf getBuffer() {
        return this.buffer;
    }

    public static void encode(BufferPacket packet, FriendlyByteBuf buf) {
        buf.writeBytes((ByteBuf)packet.buffer);
    }

    public static BufferPacket decode(FriendlyByteBuf buf) {
        FriendlyByteBuf newBuf = new FriendlyByteBuf(buf.copy());
        return new BufferPacket(newBuf);
    }

    public static void handle(BufferPacket packet, Supplier<NetworkEvent.Context> ctx) {
        VRThrowingExtensions.log.debug("[Forge Network] Received packet on {}", (Object)(ctx.get().getDirection().getReceptionSide().isClient() ? "client" : "server"));
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isClient()) {
                VRThrowingExtensions.log.debug("[Forge Network] Forwarding to client handler");
                ClientSetup.handleNetworkPacket(packet.buffer);
            } else {
                ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
                VRThrowingExtensions.log.debug("[Forge Network] Forwarding to server handler, sender: {}", (Object)(sender != null ? sender.m_7755_().getString() : "null"));
                Network.INSTANCE.handlePacket(sender, packet.buffer);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public void m_5797_(PacketListener listener) {
    }

    public void m_5779_(FriendlyByteBuf buf) {
        buf.writeBytes((ByteBuf)this.buffer);
    }
}

