/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.network;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import win.demistorm.Platform;
import win.demistorm.VRThrowingExtensions;

public class NetworkChannel {
    private final List<PacketRegistrationData<?>> packets = new ArrayList();

    public <T> void register(Class<T> clazz, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, ServerPlayer> handler) {
        this.packets.add(new PacketRegistrationData<T>(this.packets.size(), clazz, encoder, decoder, handler));
    }

    public <T> void sendToServer(T message) {
        Platform.sendToServer(this.encode(message, this.getClientRegistryAccess()));
    }

    public <T> void sendToPlayer(ServerPlayer player, T message) {
        Platform.sendToPlayer(player, this.encode(message, player.m_9236_().m_9598_()));
    }

    public <T> void handlePacket(ServerPlayer player, FriendlyByteBuf buffer) {
        Object message;
        int packetId = buffer.readInt();
        VRThrowingExtensions.log.debug("[NetworkChannel] Received packet ID {} from player {}", (Object)packetId, (Object)(player != null ? player.m_7755_().getString() : "null"));
        if (packetId < 0 || packetId >= this.packets.size()) {
            VRThrowingExtensions.log.warn("[NetworkChannel] Invalid packet ID {}, expected 0-{}", (Object)packetId, (Object)(this.packets.size() - 1));
            return;
        }
        PacketRegistrationData<?> data = this.packets.get(packetId);
        try {
            message = data.decoder.apply(buffer);
            VRThrowingExtensions.log.debug("[NetworkChannel] Decoded packet type {} successfully", (Object)data.clazz.getSimpleName());
        }
        catch (Exception e) {
            VRThrowingExtensions.log.error("[NetworkChannel] Failed to decode packet {}: {}", (Object)packetId, (Object)e.getMessage());
            return;
        }
        VRThrowingExtensions.log.debug("[NetworkChannel] Calling handler for packet type {}", (Object)data.clazz.getSimpleName());
        data.handler.accept(message, player);
    }

    private <T> FriendlyByteBuf encode(T message, RegistryAccess access) {
        PacketRegistrationData<T> data = this.getData(message);
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        buffer.writeInt(data.id());
        data.encoder().accept(message, buffer);
        return buffer;
    }

    private <T> PacketRegistrationData<T> getData(T message) {
        for (PacketRegistrationData<?> data : this.packets) {
            if (data.clazz != message.getClass()) continue;
            return data;
        }
        throw new IllegalArgumentException("Packet type not registered: " + message.getClass().getName());
    }

    private RegistryAccess getClientRegistryAccess() {
        return Platform.getClientRegistryAccess();
    }

    public record PacketRegistrationData<T>(int id, Class<T> clazz, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, ServerPlayer> handler) {
    }
}

