/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.network;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import win.demistorm.ConfigHelper;
import win.demistorm.ModCompat;
import win.demistorm.ThrownProjectileEntity;
import win.demistorm.VRThrowingExtensions;
import win.demistorm.client.particles.BleedingParticle;
import win.demistorm.client.particles.BloodParticle;
import win.demistorm.network.BleedingParticleData;
import win.demistorm.network.BloodParticleData;
import win.demistorm.network.CatchCompleteData;
import win.demistorm.network.CatchData;
import win.demistorm.network.CatchUpdateData;
import win.demistorm.network.ConfigSyncData;
import win.demistorm.network.ThrowData;

public final class NetworkHandlers {
    public static void handleThrow(Player player, ThrowData data) {
        VRThrowingExtensions.log.debug("[NetworkHandlers] handleThrow called for player: {}", (Object)(player != null ? player.m_7755_().getString() : "null"));
        if (player == null || !player.m_6084_()) {
            VRThrowingExtensions.log.debug("[NetworkHandlers] Returning: player null or not alive (player={}, alive={})", (Object)(player != null ? "not null" : "null"), player != null ? Boolean.valueOf(player.m_6084_()) : "N/A");
            return;
        }
        ItemStack heldStack = player.m_21205_();
        VRThrowingExtensions.log.debug("[NetworkHandlers] Player holding: {} (empty={}, disabled={})", new Object[]{heldStack, heldStack.m_41619_(), ModCompat.throwingDisabled(heldStack)});
        if (heldStack.m_41619_() || ModCompat.throwingDisabled(heldStack)) {
            VRThrowingExtensions.log.debug("[NetworkHandlers] Returning: empty stack or throwing disabled");
            return;
        }
        try {
            VRThrowingExtensions.log.debug("[NetworkHandlers] Creating ThrownProjectileEntity...");
            if (VRThrowingExtensions.THROWN_ITEM_TYPE == null) {
                throw new IllegalStateException("THROWN_ITEM_TYPE is null - entity registration has not occurred yet");
            }
            ThrownProjectileEntity proj = new ThrownProjectileEntity(player.m_9236_(), (LivingEntity)player, heldStack, data.wholeStack());
            VRThrowingExtensions.log.debug("[NetworkHandlers] Setting item on projectile...");
            proj.m_37446_(heldStack.m_255036_(1));
            VRThrowingExtensions.log.debug("[NetworkHandlers] Setting projectile position and velocity...");
            Vec3 pos = new Vec3(data.posX(), data.posY(), data.posZ());
            Vec3 vel = new Vec3(data.velX(), data.velY(), data.velZ());
            proj.m_146884_(pos);
            proj.setOriginalThrowPos(pos);
            proj.m_20256_(vel);
            proj.setHandRoll(data.rollDeg());
            VRThrowingExtensions.log.debug("[Server] Spawning thrown proj {} with item {}", (Object)proj.m_19879_(), (Object)proj.m_7846_());
            player.m_9236_().m_7967_((Entity)proj);
            float attackDamage = ThrownProjectileEntity.stackBaseDamage(heldStack);
            VRThrowingExtensions.log.debug("[Network] Thrown item attack damage = {}", (Object)Float.valueOf(attackDamage));
            if (attackDamage <= 1.0f) {
                if (!player.m_9236_().m_5776_()) {
                    player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_12553_, SoundSource.PLAYERS, 0.6f, 1.05f);
                }
            } else if (!player.m_9236_().m_5776_()) {
                player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_12520_, SoundSource.PLAYERS, 0.6f, 1.33f);
            }
            if (data.wholeStack()) {
                player.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
            } else if (heldStack.m_41613_() > 1) {
                heldStack.m_41774_(1);
            } else {
                player.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
            }
        }
        catch (Exception e) {
            VRThrowingExtensions.log.error("[NetworkHandlers] Exception while creating thrown projectile: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public static void handleCatch(Player player, CatchData data) {
        if (player == null || !player.m_6084_()) {
            return;
        }
        ServerLevel world = (ServerLevel)player.m_9236_();
        Entity entity = world.m_6815_(data.entityId());
        if (!(entity instanceof ThrownProjectileEntity)) {
            return;
        }
        ThrownProjectileEntity projectile = (ThrownProjectileEntity)entity;
        if (data.startCatch()) {
            projectile.startCatch();
        } else {
            projectile.cancelCatch();
        }
    }

    public static void handleCatchUpdate(Player player, CatchUpdateData data) {
        if (player == null || !player.m_6084_()) {
            return;
        }
        ServerLevel world = (ServerLevel)player.m_9236_();
        Entity entity = world.m_6815_(data.entityId());
        if (!(entity instanceof ThrownProjectileEntity)) {
            return;
        }
        ThrownProjectileEntity projectile = (ThrownProjectileEntity)entity;
        if (!projectile.isCatching()) {
            return;
        }
        Vec3 newVel = new Vec3(data.velX(), data.velY(), data.velZ());
        projectile.m_20256_(newVel);
        projectile.setHandRoll(data.rollDeg());
    }

    public static void handleCatchComplete(Player player, CatchCompleteData data) {
        if (player == null || !player.m_6084_()) {
            return;
        }
        ServerLevel world = (ServerLevel)player.m_9236_();
        Entity entity = world.m_6815_(data.entityId());
        if (!(entity instanceof ThrownProjectileEntity)) {
            return;
        }
        ThrownProjectileEntity projectile = (ThrownProjectileEntity)entity;
        if (!projectile.isCatching()) {
            return;
        }
        ItemStack mainHand = player.m_21205_();
        if (!mainHand.m_41619_()) {
            return;
        }
        ItemStack projectileStack = projectile.m_7846_();
        int stackSize = projectile.getStackSize();
        if (!player.m_9236_().m_5776_()) {
            player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.5f, 2.0f);
        }
        ItemStack giveStack = projectileStack.m_41777_();
        giveStack.m_41764_(stackSize);
        player.m_21008_(InteractionHand.MAIN_HAND, giveStack);
        projectile.m_146870_();
    }

    public static void handleBloodParticle(Player player, BloodParticleData data) {
        if (player != null && player.m_9236_().m_5776_()) {
            BloodParticle.spawnParticles(data);
        }
        VRThrowingExtensions.log.debug("[Network] Received blood particle packet at ({}, {}, {})", new Object[]{data.posX(), data.posY(), data.posZ()});
    }

    public static void handleBleedingParticle(Player player, BleedingParticleData data) {
        if (player != null && player.m_9236_().m_5776_()) {
            BleedingParticle.spawnBleedingParticles(data);
        }
        VRThrowingExtensions.log.debug("[Network] Received bleeding particle packet at ({}, {}, {})", new Object[]{data.posX(), data.posY(), data.posZ()});
    }

    public static void handleConfigSync(Player player, ConfigSyncData data) {
        ConfigHelper.clientReceivedRemote(data.json());
        VRThrowingExtensions.log.debug("[Network] Received config sync packet for player: {}", (Object)player.m_7755_().getString());
    }
}

