/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm;

import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import win.demistorm.ConfigHelper;
import win.demistorm.VRThrowingExtensions;
import win.demistorm.WeaponEffectType;
import win.demistorm.effects.BoomerangEffect;
import win.demistorm.effects.EmbeddingEffect;
import win.demistorm.network.BloodParticleData;
import win.demistorm.network.Network;

public class ThrownProjectileEntity
extends ThrowableItemProjectile {
    private int stackSize = 1;
    public boolean catching = false;
    private Vec3 storedVelocity = Vec3.ZERO;
    private int immunityTicks = 20;
    private int bounceReturnTicks = 0;
    private boolean reachedOriginOnce = false;
    public Vec3 originalThrowPos = Vec3.ZERO;
    public boolean hasBounced = false;
    public boolean bounceActive = false;
    public Vec3 bounceCurveOffset = Vec3.ZERO;
    public Vec3 bouncePlaneNormal = Vec3.ZERO;
    public double bounceArcMag = 0.0;
    public boolean bounceInverse = true;
    private LivingEntity embeddedTarget = null;
    private Vec3 embeddedOffset = Vec3.ZERO;
    private boolean alreadyDropped = false;
    private float embeddedLocalYaw = 0.0f;
    private float embeddedLocalPitch = 0.0f;
    private boolean damageDealt = false;
    private static final EntityDataAccessor<Float> HAND_ROLL = SynchedEntityData.defineId(ThrownProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Boolean> IS_CATCHING = SynchedEntityData.defineId(ThrownProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> BOUNCE_ACTIVE = SynchedEntityData.defineId(ThrownProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IS_EMBEDDED = SynchedEntityData.defineId(ThrownProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Float> EMBED_YAW = SynchedEntityData.defineId(ThrownProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> EMBED_PITCH = SynchedEntityData.defineId(ThrownProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> EMBED_ROLL = SynchedEntityData.defineId(ThrownProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> EMBED_TILT = SynchedEntityData.defineId(ThrownProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);

    public ThrownProjectileEntity(EntityType<? extends ThrowableItemProjectile> type, Level level) {
        super(type, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(HAND_ROLL, (Object)Float.valueOf(0.0f));
        builder.define(IS_CATCHING, (Object)false);
        builder.define(BOUNCE_ACTIVE, (Object)false);
        builder.define(IS_EMBEDDED, (Object)false);
        builder.define(EMBED_YAW, (Object)Float.valueOf(0.0f));
        builder.define(EMBED_PITCH, (Object)Float.valueOf(0.0f));
        builder.define(EMBED_ROLL, (Object)Float.valueOf(0.0f));
        builder.define(EMBED_TILT, (Object)Float.valueOf(0.0f));
    }

    public ThrownProjectileEntity(Level level, LivingEntity owner, ItemStack carried, boolean isWholeStack) {
        super(VRThrowingExtensions.THROWN_ITEM_TYPE, level);
        this.setOwner((Entity)owner);
        this.setItem(carried.copyWithCount(1));
        this.stackSize = isWholeStack ? carried.getCount() : 1;
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (this.level().isClientSide && this.tickCount < 40) {
            VRThrowingExtensions.log.debug("[Client] Data updated for {}: item now {}", (Object)this.getId(), (Object)this.getItem());
        }
    }

    public void setHandRoll(float deg) {
        this.entityData.set(HAND_ROLL, (Object)Float.valueOf(deg));
    }

    public float getHandRoll() {
        return ((Float)this.entityData.get(HAND_ROLL)).floatValue();
    }

    public void startCatch() {
        EmbeddingEffect.releaseEmbedding(this);
        this.catching = true;
        this.storedVelocity = this.getDeltaMovement();
        this.entityData.set(IS_CATCHING, (Object)true);
        this.setNoGravity(true);
        VRThrowingExtensions.log.debug("[VR Catch] Started catch for projectile {}", (Object)this.getId());
    }

    public void cancelCatch() {
        this.catching = false;
        this.entityData.set(IS_CATCHING, (Object)false);
        this.setNoGravity(false);
        if (this.storedVelocity.length() > 0.1) {
            this.setDeltaMovement(this.storedVelocity.scale(0.5));
        }
        VRThrowingExtensions.log.debug("[VR Catch] Canceled catch for projectile {}", (Object)this.getId());
    }

    public boolean isCatching() {
        return (Boolean)this.entityData.get(IS_CATCHING);
    }

    public boolean isBounceActive() {
        return (Boolean)this.entityData.get(BOUNCE_ACTIVE);
    }

    public int getStackSize() {
        return this.stackSize;
    }

    public void tick() {
        super.tick();
        if (this.immunityTicks > 0) {
            --this.immunityTicks;
        }
        if (this.isEmbedded() && !this.isCatching()) {
            EmbeddingEffect.tickEmbedded(this);
            return;
        }
        if (this.bounceActive && !this.isCatching()) {
            ++this.bounceReturnTicks;
            if (BoomerangEffect.tickReturn(this)) {
                this.bounceActive = false;
                this.reachedOriginOnce = true;
                this.entityData.set(BOUNCE_ACTIVE, (Object)false);
                this.setNoGravity(false);
                Vec3 returnVel = this.getDeltaMovement();
                double currentSpeed = returnVel.length();
                if (currentSpeed > 1.0) {
                    returnVel = returnVel.normalize().scale(Math.min(currentSpeed, 1.0));
                }
                this.setDeltaMovement(returnVel);
                VRThrowingExtensions.log.debug("[VR Throw] Projectile {} completed return after {} ticks, vel {}", new Object[]{this.getId(), this.bounceReturnTicks, returnVel});
            }
            if (this.bounceReturnTicks > 200) {
                VRThrowingExtensions.log.debug("[VR Throw] Projectile {} return timed out, dropping", (Object)this.getId());
                this.stopBoomerang();
            }
        }
        if (this.isCatching()) {
            Vec3 vel = this.getDeltaMovement();
            this.setDeltaMovement(vel.scale(0.95));
        }
    }

    private void stopBoomerang() {
        this.bounceActive = false;
        this.entityData.set(BOUNCE_ACTIVE, (Object)false);
        this.setNoGravity(false);
        Vec3 currentVel = this.getDeltaMovement();
        double horizontalSpeed = Math.sqrt(currentVel.x * currentVel.x + currentVel.z * currentVel.z);
        if (horizontalSpeed > 0.5) {
            double factor = 0.3 / horizontalSpeed;
            this.setDeltaMovement(new Vec3(currentVel.x * factor, -0.2, currentVel.z * factor));
        } else {
            this.setDeltaMovement(new Vec3(currentVel.x * 0.5, -0.2, currentVel.z * 0.5));
        }
    }

    protected void onHit(HitResult hit) {
        EntityHitResult ehr;
        Entity target;
        if (this.isCatching()) {
            return;
        }
        if (this.immunityTicks > 0 && hit.getType() == HitResult.Type.ENTITY && (target = (ehr = (EntityHitResult)hit).getEntity()) == this.getOwner()) {
            VRThrowingExtensions.log.debug("[VR Throw] Projectile {} ignoring owner collision (immunity: {} ticks)", (Object)this.getId(), (Object)this.immunityTicks);
            return;
        }
        Vec3 hitPos = null;
        if (hit.getType() == HitResult.Type.ENTITY) {
            EntityHitResult entityHit = (EntityHitResult)hit;
            Entity target2 = entityHit.getEntity();
            AABB targetBox = target2.getBoundingBox();
            Vec3 projPos = this.position();
            double hitX = Mth.clamp((double)projPos.x, (double)targetBox.minX, (double)targetBox.maxX);
            double hitY = Mth.clamp((double)projPos.y, (double)targetBox.minY, (double)targetBox.maxY);
            double hitZ = Mth.clamp((double)projPos.z, (double)targetBox.minZ, (double)targetBox.maxZ);
            hitPos = new Vec3(hitX, hitY, hitZ);
        }
        if (this.bounceActive || this.hasBounced) {
            if (hit.getType() == HitResult.Type.ENTITY) {
                this.onHitEntity((EntityHitResult)hit, hitPos);
                VRThrowingExtensions.log.debug("[VR Throw] Projectile {} hit entity during return, dropping", (Object)this.getId());
            } else {
                VRThrowingExtensions.log.debug("[VR Throw] Projectile {} hit block during return, dropping", (Object)this.getId());
            }
            this.dropAndDiscard();
            return;
        }
        if (!this.level().isClientSide) {
            boolean hitEntity;
            boolean bl = hitEntity = hit.getType() == HitResult.Type.ENTITY;
            if (hitEntity) {
                EntityHitResult entityHit = (EntityHitResult)hit;
                this.onHitEntity(entityHit, hitPos);
                float attackDamage = ThrownProjectileEntity.stackBaseDamage(this.getItem());
                if (attackDamage <= 1.0f) {
                    this.dropAndDiscard();
                    return;
                }
                if (ConfigHelper.ACTIVE.weaponEffect == WeaponEffectType.BOOMERANG) {
                    boolean shouldBounce;
                    boolean bl2 = shouldBounce = BoomerangEffect.canBounce(this.getItem().getItem()) && !this.hasBounced && !this.reachedOriginOnce;
                    if (shouldBounce) {
                        VRThrowingExtensions.log.debug("[VR Throw] Starting boomerang effect for {}", (Object)this.getId());
                        BoomerangEffect.startBounce(this);
                        this.bounceActive = true;
                        this.entityData.set(BOUNCE_ACTIVE, (Object)true);
                        return;
                    }
                } else if (ConfigHelper.ACTIVE.weaponEffect == WeaponEffectType.EMBED) {
                    if (this.damageDealt) {
                        EmbeddingEffect.startEmbedding(this, entityHit, hitPos);
                        return;
                    }
                    VRThrowingExtensions.log.debug("[VR Throw] Damage blocked, not embedding projectile {}", (Object)this.getId());
                }
            }
            this.dropAndDiscard();
        } else {
            this.level().addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, this.getItem()), this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
        }
    }

    protected void onHitEntity(EntityHitResult res, Vec3 hitPos) {
        Entity target = res.getEntity();
        ServerLevel world = (ServerLevel)this.level();
        DamageSource src = world.damageSources().thrown((Entity)this, (Entity)(this.getOwner() == null ? this : this.getOwner()));
        float base = ThrownProjectileEntity.stackBaseDamage(this.getItem());
        float total = EnchantmentHelper.modifyDamage((ServerLevel)world, (ItemStack)this.getItem(), (Entity)target, (DamageSource)src, (float)base);
        float enchBonus = total - base;
        VRThrowingExtensions.log.debug("[VR Throw] Damage dealt: Item={}, Base={}, EnchBonus={}, Final={}, Target={}, State={}", new Object[]{this.getItem().getItem(), Float.valueOf(base), Float.valueOf(enchBonus), Float.valueOf(total), target.getName().getString(), this.bounceActive ? "RETURNING" : "FORWARD"});
        this.damageDealt = target.hurt(src, total);
        VRThrowingExtensions.log.debug("[VR Throw] Damage result: dealt={}, target={}", (Object)this.damageDealt, (Object)target.getName().getString());
        Vec3 velocity = this.getDeltaMovement();
        int playersSent = 0;
        for (ServerPlayer player : world.getServer().getPlayerList().getPlayers()) {
            if (player.level() != world || !(player.distanceToSqr(hitPos) < 4096.0)) continue;
            Network.INSTANCE.sendToPlayer(player, new BloodParticleData(hitPos.x, hitPos.y, hitPos.z, velocity.x, velocity.y, velocity.z));
            ++playersSent;
        }
        VRThrowingExtensions.log.debug("[Server] Sent blood particle packet to {} players at ({}, {}, {})", new Object[]{playersSent, hitPos.x, hitPos.y, hitPos.z});
        Vec3 push = this.getDeltaMovement().normalize().scale(0.5);
        target.push(push.x, 0.1 + push.y, push.z);
    }

    private ItemStack createDropStack() {
        ItemStack drop = this.getItem().copy();
        if (drop.isDamageableItem()) {
            int totalDamage = Mth.clamp((int)(drop.getDamageValue() + this.stackSize), (int)0, (int)drop.getMaxDamage());
            drop.setDamageValue(totalDamage);
        }
        return drop;
    }

    public static float stackBaseDamage(ItemStack stack) {
        float playerBase = 1.0f;
        EquipmentSlotGroup[] groups = new EquipmentSlotGroup[]{EquipmentSlotGroup.MAINHAND, EquipmentSlotGroup.HAND};
        float[] add = new float[]{0.0f};
        float[] mulBase = new float[]{0.0f};
        float[] mulTotal = new float[]{0.0f};
        for (EquipmentSlotGroup g : groups) {
            stack.forEachModifier(g, (attr, modifier) -> {
                if (attr.is((ResourceKey)Attributes.ATTACK_DAMAGE.unwrapKey().orElseThrow())) {
                    AttributeModifier.Operation op = modifier.operation();
                    if (op == AttributeModifier.Operation.ADD_VALUE) {
                        add[0] = add[0] + (float)modifier.amount();
                    } else if (op == AttributeModifier.Operation.ADD_MULTIPLIED_BASE) {
                        mulBase[0] = mulBase[0] + (float)modifier.amount();
                    } else if (op == AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL) {
                        mulTotal[0] = mulTotal[0] + (float)modifier.amount();
                    }
                }
            });
        }
        float result = 1.0f + add[0];
        result += 1.0f * mulBase[0];
        result += result * mulTotal[0];
        return Math.max(1.0f, result);
    }

    public void clearSpawnImmunity() {
        this.immunityTicks = 0;
        VRThrowingExtensions.log.debug("[VR Throw] Projectile {} spawn immunity cleared", (Object)this.getId());
    }

    @NotNull
    protected Item getDefaultItem() {
        return Items.STICK;
    }

    public void setOriginalThrowPos(Vec3 v) {
        this.originalThrowPos = v;
    }

    public void beginEmbedding(LivingEntity host, Vec3 worldOffset, float yawDeg, float pitchDeg, float tiltDeg, float initialXRollDeg) {
        Vec3 localOffset;
        this.embeddedTarget = host;
        this.setNoGravity(true);
        this.setDeltaMovement(Vec3.ZERO);
        this.setPos(host.position().add(worldOffset));
        float hostBodyYaw = host.getYHeadRot();
        float hostPitch = host.getXRot();
        this.embeddedOffset = localOffset = ThrownProjectileEntity.rotateY(worldOffset, -hostBodyYaw);
        this.embeddedLocalYaw = Mth.wrapDegrees((float)(yawDeg - hostBodyYaw));
        this.embeddedLocalPitch = Mth.wrapDegrees((float)(pitchDeg - hostPitch));
        this.entityData.set(IS_EMBEDDED, (Object)true);
        this.entityData.set(EMBED_YAW, (Object)Float.valueOf(yawDeg));
        this.entityData.set(EMBED_PITCH, (Object)Float.valueOf(pitchDeg));
        this.entityData.set(EMBED_ROLL, (Object)Float.valueOf(initialXRollDeg));
        this.entityData.set(EMBED_TILT, (Object)Float.valueOf(tiltDeg));
        VRThrowingExtensions.log.debug("[Embed] beginEmbedding: proj={} host={} worldOffset={} localOffset={} yaw={} pitch={} tilt={} xRollStart={}", new Object[]{this.getId(), host.getName().getString(), worldOffset, localOffset, String.format("%.1f", Float.valueOf(yawDeg)), String.format("%.1f", Float.valueOf(pitchDeg)), String.format("%.1f", Float.valueOf(tiltDeg)), String.format("%.1f", Float.valueOf(initialXRollDeg))});
    }

    public void clearEmbedding() {
        if (!this.level().isClientSide() && this.embeddedTarget != null) {
            EmbeddingEffect.BleedManager.unregister(this.embeddedTarget, this);
        }
        this.entityData.set(IS_EMBEDDED, (Object)false);
        this.embeddedTarget = null;
        this.embeddedOffset = Vec3.ZERO;
        this.embeddedLocalYaw = 0.0f;
        this.embeddedLocalPitch = 0.0f;
        this.setNoGravity(false);
    }

    public boolean isEmbedded() {
        return (Boolean)this.entityData.get(IS_EMBEDDED);
    }

    public float getEmbedYaw() {
        return ((Float)this.entityData.get(EMBED_YAW)).floatValue();
    }

    public float getEmbedPitch() {
        return ((Float)this.entityData.get(EMBED_PITCH)).floatValue();
    }

    public float getEmbedRoll() {
        return ((Float)this.entityData.get(EMBED_ROLL)).floatValue();
    }

    public void setEmbedRoll(float v) {
        this.entityData.set(EMBED_ROLL, (Object)Float.valueOf(v));
    }

    public float getEmbedTilt() {
        return ((Float)this.entityData.get(EMBED_TILT)).floatValue();
    }

    public Entity getEmbeddedTarget() {
        return this.embeddedTarget;
    }

    public Vec3 getEmbeddedOffset() {
        return this.embeddedOffset;
    }

    public float getEmbeddedLocalYaw() {
        return this.embeddedLocalYaw;
    }

    public float getEmbeddedLocalPitch() {
        return this.embeddedLocalPitch;
    }

    public void setEmbedYaw(float v) {
        this.entityData.set(EMBED_YAW, (Object)Float.valueOf(v));
    }

    public void setEmbedPitch(float v) {
        this.entityData.set(EMBED_PITCH, (Object)Float.valueOf(v));
    }

    private static Vec3 rotateY(Vec3 v, float degrees) {
        double rad = Math.toRadians(degrees);
        double cos = Math.cos(rad);
        double sin = Math.sin(rad);
        double x = v.x * cos - v.z * sin;
        double z = v.x * sin + v.z * cos;
        return new Vec3(x, v.y, z);
    }

    public void dropAndDiscard() {
        if (this.isEmbedded()) {
            this.clearEmbedding();
        }
        this.clearSpawnImmunity();
        if (this.alreadyDropped) {
            this.discard();
            return;
        }
        this.alreadyDropped = true;
        if (!this.level().isClientSide()) {
            ItemStack dropStack = this.createDropStack();
            dropStack.setCount(this.stackSize);
            this.level().addFreshEntity((Entity)new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), dropStack));
        }
        this.discard();
    }
}

