/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.forge;

import io.netty.buffer.ByteBuf;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.ChannelBuilder;
import net.minecraftforge.network.EventNetworkChannel;
import net.minecraftforge.registries.RegisterEvent;
import win.demistorm.ThrownProjectileEntity;
import win.demistorm.VRThrowingExtensions;
import win.demistorm.forge.ClientSetup;
import win.demistorm.forge.ForgeConfigScreen;
import win.demistorm.network.Network;

@Mod(value="vr_throwing_extensions")
public class VRThrowingExtensionsForge {
    public static final EventNetworkChannel NETWORK = ChannelBuilder.named((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"vr_throwing_extensions", (String)"network")).acceptedVersions((status, version) -> true).optional().networkProtocolVersion(0).eventNetworkChannel();

    public VRThrowingExtensionsForge(FMLJavaModLoadingContext context) {
        VRThrowingExtensions.log.info("VR Throwing Extensions (FORGE) starting!");
        IEventBus modEventBus = context.getModEventBus();
        modEventBus.addListener(this::registerEntities);
        try {
            Class.forName("org.vivecraft.api.VRAPI");
            VRThrowingExtensions.log.info("Vivecraft detected! VR throwing enabled.");
        }
        catch (ClassNotFoundException e) {
            VRThrowingExtensions.log.error("Vivecraft not found! VR Throwing Extensions requires Vivecraft to function.");
            throw new RuntimeException("Vivecraft is required for VR Throwing Extensions");
        }
        VRThrowingExtensions.initialize();
        Network.initialize();
        NETWORK.addListener(event -> {
            FriendlyByteBuf payload = event.getPayload();
            if (payload == null) {
                return;
            }
            if (event.getSource().isServerSide()) {
                ServerPlayer sender = event.getSource().getSender();
                if (sender != null) {
                    RegistryFriendlyByteBuf registryBuf = new RegistryFriendlyByteBuf((ByteBuf)payload, sender.level().registryAccess());
                    Network.INSTANCE.handlePacket(sender, registryBuf);
                }
            } else if (FMLEnvironment.dist == Dist.CLIENT) {
                ClientSetup.handleNetworkPacket(payload);
            }
            event.getSource().setPacketHandled(true);
        });
        if (FMLEnvironment.dist == Dist.CLIENT) {
            ClientSetup.doClientSetup();
            ForgeConfigScreen.register(context);
        }
        VRThrowingExtensions.log.info("VR Throwing Extensions (FORGE) initialization complete!");
    }

    private void registerEntities(RegisterEvent event) {
        ResourceLocation entityLocation = ResourceLocation.fromNamespaceAndPath((String)"vr_throwing_extensions", (String)"generic_thrown_item");
        event.register(Registries.ENTITY_TYPE, entityLocation, () -> {
            VRThrowingExtensions.THROWN_ITEM_TYPE = EntityType.Builder.of(ThrownProjectileEntity::new, (MobCategory)MobCategory.MISC).sized(0.25f, 0.25f).clientTrackingRange(64).updateInterval(5).build("vr_throwing_extensions:generic_thrown_item");
            return VRThrowingExtensions.THROWN_ITEM_TYPE;
        });
        VRThrowingExtensions.log.info("Registered entity type: {}", (Object)entityLocation);
    }
}

