/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import win.demistorm.ThrownProjectileEntity;

public class ThrownItemRenderer
extends EntityRenderer<ThrownProjectileEntity, ThrownItemRenderState> {
    private final ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
    private final float scale;

    public ThrownItemRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
        this.scale = 0.7f;
        this.shadowRadius = 0.0f;
    }

    @NotNull
    public ThrownItemRenderState createRenderState() {
        return new ThrownItemRenderState();
    }

    public void extractRenderState(ThrownProjectileEntity entity, ThrownItemRenderState state, float tickDelta) {
        state.itemStack = entity.getItem();
        state.velocity = entity.getDeltaMovement();
        state.age = (float)entity.tickCount + tickDelta;
        state.handRollDeg = entity.getHandRoll();
        state.isCatching = entity.isCatching();
        state.isBounceActive = entity.isBounceActive();
        state.isEmbedded = entity.isEmbedded();
        if (state.isEmbedded) {
            state.embedYawDeg = entity.getEmbedYaw();
            state.embedPitchDeg = entity.getEmbedPitch();
            state.embedRollDeg = entity.getEmbedRoll();
            state.embedTiltDeg = entity.getEmbedTilt();
        }
    }

    public void render(ThrownItemRenderState state, PoseStack matrices, MultiBufferSource vcp, int light) {
        matrices.pushPose();
        if (state.isEmbedded) {
            matrices.mulPose(Axis.YP.rotationDegrees(90.0f - state.embedYawDeg));
            matrices.mulPose(Axis.XP.rotationDegrees(-state.embedPitchDeg));
            matrices.mulPose(Axis.ZP.rotationDegrees(state.embedTiltDeg));
            matrices.mulPose(Axis.XP.rotationDegrees(state.embedRollDeg));
            matrices.scale(this.scale, this.scale, this.scale);
            matrices.scale(1.0f, 1.0f, -1.0f);
            try {
                boolean glint = state.itemStack.isEnchanted();
                this.itemRenderer.renderStatic((LivingEntity)Minecraft.getInstance().player, state.itemStack, ItemDisplayContext.FIRST_PERSON_RIGHT_HAND, glint, matrices, vcp, (Level)Minecraft.getInstance().level, light, OverlayTexture.NO_OVERLAY, 0);
            }
            catch (Exception e) {
                System.err.println("VR Throwing Extensions: Could not render embedded item: " + e.getMessage());
            }
            matrices.popPose();
            super.render((EntityRenderState)state, matrices, vcp, light);
            return;
        }
        Vec3 vel = state.velocity;
        if (vel.length() > 0.001) {
            float yaw = (float)(Mth.atan2((double)vel.z, (double)vel.x) * 180.0 / Math.PI);
            matrices.mulPose(Axis.YP.rotationDegrees(90.0f - yaw));
            float hor = Mth.sqrt((float)((float)(vel.x * vel.x + vel.z * vel.z)));
            float pitch = (float)(Mth.atan2((double)vel.y, (double)hor) * 180.0 / Math.PI);
            matrices.mulPose(Axis.XP.rotationDegrees(-pitch));
            matrices.mulPose(Axis.ZP.rotationDegrees(-state.handRollDeg));
        }
        if (state.isCatching) {
            float smoothSpin = state.age * 5.0f % 360.0f;
            matrices.mulPose(Axis.XP.rotationDegrees(smoothSpin));
            float bobOffset = Mth.sin((float)(state.age * 0.5f)) * 0.05f;
            matrices.translate(0.0f, bobOffset, 0.0f);
        } else if (state.isBounceActive) {
            float returnSpin = state.age * 8.0f % 360.0f;
            matrices.mulPose(Axis.XP.rotationDegrees(returnSpin));
            float wobble = Mth.sin((float)(state.age * 0.35f)) * 3.0f;
            matrices.mulPose(Axis.YP.rotationDegrees(wobble));
            float pulseScale = 1.0f + Mth.sin((float)(state.age * 0.4f)) * 0.05f;
            matrices.scale(pulseScale, pulseScale, pulseScale);
        } else {
            float spinSpeed = 15.0f;
            float spin = state.age * spinSpeed % 360.0f;
            matrices.mulPose(Axis.XP.rotationDegrees(spin));
        }
        matrices.scale(1.0f, 1.0f, -1.0f);
        matrices.scale(this.scale, this.scale, this.scale);
        try {
            boolean glint = state.itemStack.isEnchanted();
            this.itemRenderer.renderStatic((LivingEntity)Minecraft.getInstance().player, state.itemStack, ItemDisplayContext.FIRST_PERSON_RIGHT_HAND, glint, matrices, vcp, (Level)Minecraft.getInstance().level, light, OverlayTexture.NO_OVERLAY, 0);
        }
        catch (Exception e) {
            System.err.println("VR Throwing Extensions: Could not render thrown item: " + e.getMessage());
        }
        matrices.popPose();
        super.render((EntityRenderState)state, matrices, vcp, light);
    }

    public static class ThrownItemRenderState
    extends EntityRenderState {
        public ItemStack itemStack = ItemStack.EMPTY;
        public Vec3 velocity = Vec3.ZERO;
        public float age = 0.0f;
        public float handRollDeg = 0.0f;
        public boolean isCatching = false;
        public boolean isBounceActive = false;
        public boolean isEmbedded = false;
        public float embedYawDeg = 0.0f;
        public float embedPitchDeg = 0.0f;
        public float embedRollDeg = 0.0f;
        public float embedTiltDeg = 0.0f;
    }
}

