/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.network;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import win.demistorm.ConfigHelper;
import win.demistorm.ModCompat;
import win.demistorm.ThrownProjectileEntity;
import win.demistorm.VRThrowingExtensions;
import win.demistorm.client.particles.BleedingParticle;
import win.demistorm.client.particles.BloodParticle;
import win.demistorm.network.BleedingParticleData;
import win.demistorm.network.BloodParticleData;
import win.demistorm.network.CatchCompleteData;
import win.demistorm.network.CatchData;
import win.demistorm.network.CatchUpdateData;
import win.demistorm.network.ConfigSyncData;
import win.demistorm.network.ThrowData;

public final class NetworkHandlers {
    public static void handleThrow(Player player, ThrowData data) {
        if (player == null || !player.isAlive()) {
            return;
        }
        ItemStack heldStack = player.getMainHandItem();
        if (heldStack.isEmpty() || ModCompat.throwingDisabled(heldStack)) {
            return;
        }
        ThrownProjectileEntity proj = new ThrownProjectileEntity(player.level(), (LivingEntity)player, heldStack, data.wholeStack());
        proj.setItem(heldStack.copyWithCount(1));
        Vec3 pos = new Vec3(data.posX(), data.posY(), data.posZ());
        Vec3 vel = new Vec3(data.velX(), data.velY(), data.velZ());
        proj.setPos(pos);
        proj.setOriginalThrowPos(pos);
        proj.setDeltaMovement(vel);
        proj.setHandRoll(data.rollDeg());
        VRThrowingExtensions.log.debug("[Server] Spawning thrown proj {} with item {}", (Object)proj.getId(), (Object)proj.getItem());
        player.level().addFreshEntity((Entity)proj);
        float attackDamage = ThrownProjectileEntity.stackBaseDamage(heldStack);
        VRThrowingExtensions.log.debug("[Network] Thrown item attack damage = {}", (Object)Float.valueOf(attackDamage));
        if (attackDamage <= 1.0f) {
            if (!player.level().isClientSide()) {
                player.level().playSound(null, player.blockPosition(), SoundEvents.WITCH_THROW, SoundSource.PLAYERS, 0.6f, 1.05f);
            }
        } else if (!player.level().isClientSide()) {
            player.level().playSound(null, player.blockPosition(), (SoundEvent)SoundEvents.TRIDENT_THROW.value(), SoundSource.PLAYERS, 0.6f, 1.33f);
        }
        if (data.wholeStack()) {
            player.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
        } else if (heldStack.getCount() > 1) {
            heldStack.shrink(1);
        } else {
            player.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
        }
    }

    public static void handleCatch(Player player, CatchData data) {
        if (player == null || !player.isAlive()) {
            return;
        }
        ServerLevel world = (ServerLevel)player.level();
        Entity entity = world.getEntity(data.entityId());
        if (!(entity instanceof ThrownProjectileEntity)) {
            return;
        }
        ThrownProjectileEntity projectile = (ThrownProjectileEntity)entity;
        if (data.startCatch()) {
            projectile.startCatch();
        } else {
            projectile.cancelCatch();
        }
    }

    public static void handleCatchUpdate(Player player, CatchUpdateData data) {
        if (player == null || !player.isAlive()) {
            return;
        }
        ServerLevel world = (ServerLevel)player.level();
        Entity entity = world.getEntity(data.entityId());
        if (!(entity instanceof ThrownProjectileEntity)) {
            return;
        }
        ThrownProjectileEntity projectile = (ThrownProjectileEntity)entity;
        if (!projectile.isCatching()) {
            return;
        }
        Vec3 newVel = new Vec3(data.velX(), data.velY(), data.velZ());
        projectile.setDeltaMovement(newVel);
        projectile.setHandRoll(data.rollDeg());
    }

    public static void handleCatchComplete(Player player, CatchCompleteData data) {
        if (player == null || !player.isAlive()) {
            return;
        }
        ServerLevel world = (ServerLevel)player.level();
        Entity entity = world.getEntity(data.entityId());
        if (!(entity instanceof ThrownProjectileEntity)) {
            return;
        }
        ThrownProjectileEntity projectile = (ThrownProjectileEntity)entity;
        if (!projectile.isCatching()) {
            return;
        }
        ItemStack mainHand = player.getMainHandItem();
        if (!mainHand.isEmpty()) {
            return;
        }
        ItemStack projectileStack = projectile.getItem();
        int stackSize = projectile.getStackSize();
        if (!player.level().isClientSide()) {
            player.level().playSound(null, player.blockPosition(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.5f, 2.0f);
        }
        ItemStack giveStack = projectileStack.copy();
        giveStack.setCount(stackSize);
        player.setItemInHand(InteractionHand.MAIN_HAND, giveStack);
        projectile.discard();
    }

    public static void handleBloodParticle(Player player, BloodParticleData data) {
        if (player != null && player.level().isClientSide()) {
            BloodParticle.spawnParticles(data);
        }
        VRThrowingExtensions.log.debug("[Network] Received blood particle packet at ({}, {}, {})", new Object[]{data.posX(), data.posY(), data.posZ()});
    }

    public static void handleBleedingParticle(Player player, BleedingParticleData data) {
        if (player != null && player.level().isClientSide()) {
            BleedingParticle.spawnBleedingParticles(data);
        }
        VRThrowingExtensions.log.debug("[Network] Received bleeding particle packet at ({}, {}, {})", new Object[]{data.posX(), data.posY(), data.posZ()});
    }

    public static void handleConfigSync(Player player, ConfigSyncData data) {
        ConfigHelper.clientReceivedRemote(data.json());
        VRThrowingExtensions.log.debug("[Network] Received config sync packet for player: {}", (Object)player.getName().getString());
    }
}

