/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm;

import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3857;
import net.minecraft.class_3966;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import org.jetbrains.annotations.NotNull;
import win.demistorm.ConfigHelper;
import win.demistorm.VRThrowingExtensions;
import win.demistorm.WeaponEffectType;
import win.demistorm.effects.BoomerangEffect;
import win.demistorm.effects.EmbeddingEffect;
import win.demistorm.network.BloodParticleData;
import win.demistorm.network.Network;

public class ThrownProjectileEntity
extends class_3857 {
    private int stackSize = 1;
    public boolean catching = false;
    private class_243 storedVelocity = class_243.field_1353;
    private int immunityTicks = 20;
    private int bounceReturnTicks = 0;
    private boolean reachedOriginOnce = false;
    public class_243 originalThrowPos = class_243.field_1353;
    public boolean hasBounced = false;
    public boolean bounceActive = false;
    public class_243 bounceCurveOffset = class_243.field_1353;
    public class_243 bouncePlaneNormal = class_243.field_1353;
    public double bounceArcMag = 0.0;
    public boolean bounceInverse = true;
    private class_1309 embeddedTarget = null;
    private class_243 embeddedOffset = class_243.field_1353;
    private boolean alreadyDropped = false;
    private float embeddedLocalYaw = 0.0f;
    private float embeddedLocalPitch = 0.0f;
    private boolean damageDealt = false;
    private static final class_2940<Float> HAND_ROLL = class_2945.method_12791(ThrownProjectileEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Boolean> IS_CATCHING = class_2945.method_12791(ThrownProjectileEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> BOUNCE_ACTIVE = class_2945.method_12791(ThrownProjectileEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> IS_EMBEDDED = class_2945.method_12791(ThrownProjectileEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Float> EMBED_YAW = class_2945.method_12791(ThrownProjectileEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> EMBED_PITCH = class_2945.method_12791(ThrownProjectileEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> EMBED_ROLL = class_2945.method_12791(ThrownProjectileEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> EMBED_TILT = class_2945.method_12791(ThrownProjectileEntity.class, (class_2941)class_2943.field_13320);

    public ThrownProjectileEntity(class_1299<? extends class_3857> type, class_1937 level) {
        super(type, level);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(HAND_ROLL, (Object)Float.valueOf(0.0f));
        builder.method_56912(IS_CATCHING, (Object)false);
        builder.method_56912(BOUNCE_ACTIVE, (Object)false);
        builder.method_56912(IS_EMBEDDED, (Object)false);
        builder.method_56912(EMBED_YAW, (Object)Float.valueOf(0.0f));
        builder.method_56912(EMBED_PITCH, (Object)Float.valueOf(0.0f));
        builder.method_56912(EMBED_ROLL, (Object)Float.valueOf(0.0f));
        builder.method_56912(EMBED_TILT, (Object)Float.valueOf(0.0f));
    }

    public ThrownProjectileEntity(class_1937 level, class_1309 owner, class_1799 carried, boolean isWholeStack) {
        super(VRThrowingExtensions.THROWN_ITEM_TYPE, level);
        this.method_7432((class_1297)owner);
        this.method_16940(carried.method_46651(1));
        this.stackSize = isWholeStack ? carried.method_7947() : 1;
    }

    public void method_5674(class_2940<?> key) {
        super.method_5674(key);
        if (this.method_37908().field_9236 && this.field_6012 < 40) {
            VRThrowingExtensions.log.debug("[Client] Data updated for {}: item now {}", (Object)this.method_5628(), (Object)this.method_7495());
        }
    }

    public void setHandRoll(float deg) {
        this.field_6011.method_12778(HAND_ROLL, (Object)Float.valueOf(deg));
    }

    public float getHandRoll() {
        return ((Float)this.field_6011.method_12789(HAND_ROLL)).floatValue();
    }

    public void startCatch() {
        EmbeddingEffect.releaseEmbedding(this);
        this.catching = true;
        this.storedVelocity = this.method_18798();
        this.field_6011.method_12778(IS_CATCHING, (Object)true);
        this.method_5875(true);
        VRThrowingExtensions.log.debug("[VR Catch] Started catch for projectile {}", (Object)this.method_5628());
    }

    public void cancelCatch() {
        this.catching = false;
        this.field_6011.method_12778(IS_CATCHING, (Object)false);
        this.method_5875(false);
        if (this.storedVelocity.method_1033() > 0.1) {
            this.method_18799(this.storedVelocity.method_1021(0.5));
        }
        VRThrowingExtensions.log.debug("[VR Catch] Canceled catch for projectile {}", (Object)this.method_5628());
    }

    public boolean isCatching() {
        return (Boolean)this.field_6011.method_12789(IS_CATCHING);
    }

    public boolean isBounceActive() {
        return (Boolean)this.field_6011.method_12789(BOUNCE_ACTIVE);
    }

    public int getStackSize() {
        return this.stackSize;
    }

    public void method_5773() {
        super.method_5773();
        if (this.immunityTicks > 0) {
            --this.immunityTicks;
        }
        if (this.isEmbedded() && !this.isCatching()) {
            EmbeddingEffect.tickEmbedded(this);
            return;
        }
        if (this.bounceActive && !this.isCatching()) {
            ++this.bounceReturnTicks;
            if (BoomerangEffect.tickReturn(this)) {
                this.bounceActive = false;
                this.reachedOriginOnce = true;
                this.field_6011.method_12778(BOUNCE_ACTIVE, (Object)false);
                this.method_5875(false);
                class_243 returnVel = this.method_18798();
                double currentSpeed = returnVel.method_1033();
                if (currentSpeed > 1.0) {
                    returnVel = returnVel.method_1029().method_1021(Math.min(currentSpeed, 1.0));
                }
                this.method_18799(returnVel);
                VRThrowingExtensions.log.debug("[VR Throw] Projectile {} completed return after {} ticks, vel {}", new Object[]{this.method_5628(), this.bounceReturnTicks, returnVel});
            }
            if (this.bounceReturnTicks > 200) {
                VRThrowingExtensions.log.debug("[VR Throw] Projectile {} return timed out, dropping", (Object)this.method_5628());
                this.stopBoomerang();
            }
        }
        if (this.isCatching()) {
            class_243 vel = this.method_18798();
            this.method_18799(vel.method_1021(0.95));
        }
    }

    private void stopBoomerang() {
        this.bounceActive = false;
        this.field_6011.method_12778(BOUNCE_ACTIVE, (Object)false);
        this.method_5875(false);
        class_243 currentVel = this.method_18798();
        double horizontalSpeed = Math.sqrt(currentVel.field_1352 * currentVel.field_1352 + currentVel.field_1350 * currentVel.field_1350);
        if (horizontalSpeed > 0.5) {
            double factor = 0.3 / horizontalSpeed;
            this.method_18799(new class_243(currentVel.field_1352 * factor, -0.2, currentVel.field_1350 * factor));
        } else {
            this.method_18799(new class_243(currentVel.field_1352 * 0.5, -0.2, currentVel.field_1350 * 0.5));
        }
    }

    protected void method_7488(class_239 hit) {
        class_3966 ehr;
        class_1297 target;
        if (this.isCatching()) {
            return;
        }
        if (this.immunityTicks > 0 && hit.method_17783() == class_239.class_240.field_1331 && (target = (ehr = (class_3966)hit).method_17782()) == this.method_24921()) {
            VRThrowingExtensions.log.debug("[VR Throw] Projectile {} ignoring owner collision (immunity: {} ticks)", (Object)this.method_5628(), (Object)this.immunityTicks);
            return;
        }
        class_243 hitPos = null;
        if (hit.method_17783() == class_239.class_240.field_1331) {
            class_3966 entityHit = (class_3966)hit;
            class_1297 target2 = entityHit.method_17782();
            class_238 targetBox = target2.method_5829();
            class_243 projPos = this.method_19538();
            double hitX = class_3532.method_15350((double)projPos.field_1352, (double)targetBox.field_1323, (double)targetBox.field_1320);
            double hitY = class_3532.method_15350((double)projPos.field_1351, (double)targetBox.field_1322, (double)targetBox.field_1325);
            double hitZ = class_3532.method_15350((double)projPos.field_1350, (double)targetBox.field_1321, (double)targetBox.field_1324);
            hitPos = new class_243(hitX, hitY, hitZ);
        }
        if (this.bounceActive || this.hasBounced) {
            if (hit.method_17783() == class_239.class_240.field_1331) {
                this.onHitEntity((class_3966)hit, hitPos);
                VRThrowingExtensions.log.debug("[VR Throw] Projectile {} hit entity during return, dropping", (Object)this.method_5628());
            } else {
                VRThrowingExtensions.log.debug("[VR Throw] Projectile {} hit block during return, dropping", (Object)this.method_5628());
            }
            this.dropAndDiscard();
            return;
        }
        if (!this.method_37908().field_9236) {
            boolean hitEntity;
            boolean bl = hitEntity = hit.method_17783() == class_239.class_240.field_1331;
            if (hitEntity) {
                class_3966 entityHit = (class_3966)hit;
                this.onHitEntity(entityHit, hitPos);
                float attackDamage = ThrownProjectileEntity.stackBaseDamage(this.method_7495());
                if (attackDamage <= 1.0f) {
                    this.dropAndDiscard();
                    return;
                }
                if (ConfigHelper.ACTIVE.weaponEffect == WeaponEffectType.BOOMERANG) {
                    boolean shouldBounce;
                    boolean bl2 = shouldBounce = BoomerangEffect.canBounce(this.method_7495().method_7909()) && !this.hasBounced && !this.reachedOriginOnce;
                    if (shouldBounce) {
                        VRThrowingExtensions.log.debug("[VR Throw] Starting boomerang effect for {}", (Object)this.method_5628());
                        BoomerangEffect.startBounce(this);
                        this.bounceActive = true;
                        this.field_6011.method_12778(BOUNCE_ACTIVE, (Object)true);
                        return;
                    }
                } else if (ConfigHelper.ACTIVE.weaponEffect == WeaponEffectType.EMBED) {
                    if (this.damageDealt) {
                        EmbeddingEffect.startEmbedding(this, entityHit, hitPos);
                        return;
                    }
                    VRThrowingExtensions.log.debug("[VR Throw] Damage blocked, not embedding projectile {}", (Object)this.method_5628());
                }
            }
            this.dropAndDiscard();
        } else {
            this.method_37908().method_8406((class_2394)new class_2392(class_2398.field_11218, this.method_7495()), this.method_23317(), this.method_23318(), this.method_23321(), 0.0, 0.0, 0.0);
        }
    }

    protected void onHitEntity(class_3966 res, class_243 hitPos) {
        class_1297 target = res.method_17782();
        class_3218 world = (class_3218)this.method_37908();
        class_1282 src = world.method_48963().method_48811((class_1297)this, (class_1297)(this.method_24921() == null ? this : this.method_24921()));
        float base = ThrownProjectileEntity.stackBaseDamage(this.method_7495());
        float total = class_1890.method_60120((class_3218)world, (class_1799)this.method_7495(), (class_1297)target, (class_1282)src, (float)base);
        float enchBonus = total - base;
        VRThrowingExtensions.log.debug("[VR Throw] Damage dealt: Item={}, Base={}, EnchBonus={}, Final={}, Target={}, State={}", new Object[]{this.method_7495().method_7909(), Float.valueOf(base), Float.valueOf(enchBonus), Float.valueOf(total), target.method_5477().getString(), this.bounceActive ? "RETURNING" : "FORWARD"});
        this.damageDealt = target.method_64397(world, src, total);
        VRThrowingExtensions.log.debug("[VR Throw] Damage result: dealt={}, target={}", (Object)this.damageDealt, (Object)target.method_5477().getString());
        class_243 velocity = this.method_18798();
        int playersSent = 0;
        for (class_3222 player : world.method_8503().method_3760().method_14571()) {
            if (player.method_51469() != world || !(player.method_5707(hitPos) < 4096.0)) continue;
            Network.INSTANCE.sendToPlayer(player, new BloodParticleData(hitPos.field_1352, hitPos.field_1351, hitPos.field_1350, velocity.field_1352, velocity.field_1351, velocity.field_1350));
            ++playersSent;
        }
        VRThrowingExtensions.log.debug("[Server] Sent blood particle packet to {} players at ({}, {}, {})", new Object[]{playersSent, hitPos.field_1352, hitPos.field_1351, hitPos.field_1350});
        class_243 push = this.method_18798().method_1029().method_1021(0.5);
        target.method_5762(push.field_1352, 0.1 + push.field_1351, push.field_1350);
    }

    private class_1799 createDropStack() {
        class_1799 drop = this.method_7495().method_7972();
        if (drop.method_7963()) {
            int totalDamage = class_3532.method_15340((int)(drop.method_7919() + this.stackSize), (int)0, (int)drop.method_7936());
            drop.method_7974(totalDamage);
        }
        return drop;
    }

    public static float stackBaseDamage(class_1799 stack) {
        float playerBase = 1.0f;
        class_1304[] slots = new class_1304[]{class_1304.field_6173, class_1304.field_6171};
        float[] add = new float[]{0.0f};
        float[] mulBase = new float[]{0.0f};
        float[] mulTotal = new float[]{0.0f};
        for (class_1304 slot : slots) {
            stack.method_57354(slot, (attr, modifier) -> {
                if (attr.method_40225((class_5321)class_5134.field_23721.method_40230().orElseThrow())) {
                    class_1322.class_1323 op = modifier.comp_2450();
                    switch (op) {
                        case field_6328: {
                            add[0] = add[0] + (float)modifier.comp_2449();
                            break;
                        }
                        case field_6330: {
                            mulBase[0] = mulBase[0] + (float)modifier.comp_2449();
                            break;
                        }
                        case field_6331: {
                            mulTotal[0] = mulTotal[0] + (float)modifier.comp_2449();
                        }
                    }
                }
            });
        }
        float result = 1.0f + add[0];
        result += 1.0f * mulBase[0];
        result += result * mulTotal[0];
        return Math.max(1.0f, result);
    }

    public void clearSpawnImmunity() {
        this.immunityTicks = 0;
        VRThrowingExtensions.log.debug("[VR Throw] Projectile {} spawn immunity cleared", (Object)this.method_5628());
    }

    @NotNull
    protected class_1792 method_16942() {
        return class_1802.field_8600;
    }

    public void setOriginalThrowPos(class_243 v) {
        this.originalThrowPos = v;
    }

    public void beginEmbedding(class_1309 host, class_243 worldOffset, float yawDeg, float pitchDeg, float tiltDeg, float initialXRollDeg) {
        class_243 localOffset;
        this.embeddedTarget = host;
        this.method_5875(true);
        this.method_18799(class_243.field_1353);
        this.method_33574(host.method_19538().method_1019(worldOffset));
        float hostBodyYaw = host.method_5791();
        float hostPitch = host.method_36455();
        this.embeddedOffset = localOffset = ThrownProjectileEntity.rotateY(worldOffset, -hostBodyYaw);
        this.embeddedLocalYaw = class_3532.method_15393((float)(yawDeg - hostBodyYaw));
        this.embeddedLocalPitch = class_3532.method_15393((float)(pitchDeg - hostPitch));
        this.field_6011.method_12778(IS_EMBEDDED, (Object)true);
        this.field_6011.method_12778(EMBED_YAW, (Object)Float.valueOf(yawDeg));
        this.field_6011.method_12778(EMBED_PITCH, (Object)Float.valueOf(pitchDeg));
        this.field_6011.method_12778(EMBED_ROLL, (Object)Float.valueOf(initialXRollDeg));
        this.field_6011.method_12778(EMBED_TILT, (Object)Float.valueOf(tiltDeg));
        VRThrowingExtensions.log.debug("[Embed] beginEmbedding: proj={} host={} worldOffset={} localOffset={} yaw={} pitch={} tilt={} xRollStart={}", new Object[]{this.method_5628(), host.method_5477().getString(), worldOffset, localOffset, String.format("%.1f", Float.valueOf(yawDeg)), String.format("%.1f", Float.valueOf(pitchDeg)), String.format("%.1f", Float.valueOf(tiltDeg)), String.format("%.1f", Float.valueOf(initialXRollDeg))});
    }

    public void clearEmbedding() {
        if (!this.method_37908().method_8608() && this.embeddedTarget != null) {
            EmbeddingEffect.BleedManager.unregister(this.embeddedTarget, this);
        }
        this.field_6011.method_12778(IS_EMBEDDED, (Object)false);
        this.embeddedTarget = null;
        this.embeddedOffset = class_243.field_1353;
        this.embeddedLocalYaw = 0.0f;
        this.embeddedLocalPitch = 0.0f;
        this.method_5875(false);
    }

    public boolean isEmbedded() {
        return (Boolean)this.field_6011.method_12789(IS_EMBEDDED);
    }

    public float getEmbedYaw() {
        return ((Float)this.field_6011.method_12789(EMBED_YAW)).floatValue();
    }

    public float getEmbedPitch() {
        return ((Float)this.field_6011.method_12789(EMBED_PITCH)).floatValue();
    }

    public float getEmbedRoll() {
        return ((Float)this.field_6011.method_12789(EMBED_ROLL)).floatValue();
    }

    public void setEmbedRoll(float v) {
        this.field_6011.method_12778(EMBED_ROLL, (Object)Float.valueOf(v));
    }

    public float getEmbedTilt() {
        return ((Float)this.field_6011.method_12789(EMBED_TILT)).floatValue();
    }

    public class_1297 getEmbeddedTarget() {
        return this.embeddedTarget;
    }

    public class_243 getEmbeddedOffset() {
        return this.embeddedOffset;
    }

    public float getEmbeddedLocalYaw() {
        return this.embeddedLocalYaw;
    }

    public float getEmbeddedLocalPitch() {
        return this.embeddedLocalPitch;
    }

    public void setEmbedYaw(float v) {
        this.field_6011.method_12778(EMBED_YAW, (Object)Float.valueOf(v));
    }

    public void setEmbedPitch(float v) {
        this.field_6011.method_12778(EMBED_PITCH, (Object)Float.valueOf(v));
    }

    private static class_243 rotateY(class_243 v, float degrees) {
        double rad = Math.toRadians(degrees);
        double cos = Math.cos(rad);
        double sin = Math.sin(rad);
        double x = v.field_1352 * cos - v.field_1350 * sin;
        double z = v.field_1352 * sin + v.field_1350 * cos;
        return new class_243(x, v.field_1351, z);
    }

    public void dropAndDiscard() {
        if (this.isEmbedded()) {
            this.clearEmbedding();
        }
        this.clearSpawnImmunity();
        if (this.alreadyDropped) {
            this.method_31472();
            return;
        }
        this.alreadyDropped = true;
        if (!this.method_37908().method_8608()) {
            class_1799 dropStack = this.createDropStack();
            dropStack.method_7939(this.stackSize);
            this.method_37908().method_8649((class_1297)new class_1542(this.method_37908(), this.method_23317(), this.method_23318(), this.method_23321(), dropStack));
        }
        this.method_31472();
    }
}

