/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.client;

import net.minecraft.class_243;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import win.demistorm.ThrownProjectileEntity;
import win.demistorm.VRThrowingExtensions;
import win.demistorm.network.CatchCompleteData;
import win.demistorm.network.CatchData;
import win.demistorm.network.CatchUpdateData;
import win.demistorm.network.Network;
import win.demistorm.network.ThrowData;

public final class ClientNetworkHelper {
    private ClientNetworkHelper() {
    }

    public static void sendToServer(class_243 pos, class_243 velocity, boolean wholeStack, float rollDeg) {
        VRThrowingExtensions.log.debug("ClientNetworkHelper: Sending throw. pos={} vel={} all={}", new Object[]{pos, velocity, wholeStack});
        Network.INSTANCE.sendToServer(new ThrowData(pos.field_1352, pos.field_1351, pos.field_1350, velocity.field_1352, velocity.field_1351, velocity.field_1350, wholeStack, rollDeg));
    }

    public static void sendCatchToServer(ThrownProjectileEntity entity, boolean startCatch) {
        VRThrowingExtensions.log.debug("ClientNetworkHelper: Sending catch start/cancel. entity={} start={}", (Object)entity.method_5628(), (Object)startCatch);
        Network.INSTANCE.sendToServer(new CatchData(entity.method_5628(), startCatch));
    }

    public static void sendCatchUpdateToServer(ThrownProjectileEntity entity, class_243 newVelocity, Quaternionfc handRotation) {
        Vector3f fwd = new Vector3f(0.0f, 0.0f, -1.0f).rotate(handRotation).normalize();
        Vector3f up = new Vector3f(0.0f, 1.0f, 0.0f).rotate(handRotation).normalize();
        Vector3f projCtrlUp = up.sub((Vector3fc)new Vector3f((Vector3fc)fwd).mul(up.dot((Vector3fc)fwd))).normalize();
        Vector3f projWorldUp = new Vector3f(0.0f, 1.0f, 0.0f).sub((Vector3fc)new Vector3f((Vector3fc)fwd).mul(fwd.y)).normalize();
        float rollRad = projCtrlUp.angleSigned((Vector3fc)projWorldUp, (Vector3fc)fwd);
        float rollDeg = (float)Math.toDegrees(rollRad);
        VRThrowingExtensions.log.debug("ClientNetworkHelper: Sending catch update. entity={} vel={} roll={}", new Object[]{entity.method_5628(), newVelocity, Float.valueOf(rollDeg)});
        Network.INSTANCE.sendToServer(new CatchUpdateData(entity.method_5628(), newVelocity.field_1352, newVelocity.field_1351, newVelocity.field_1350, rollDeg));
    }

    public static void sendCatchCompleteToServer(ThrownProjectileEntity entity) {
        VRThrowingExtensions.log.debug("ClientNetworkHelper: Sending catch complete. entity={}", (Object)entity.method_5628());
        Network.INSTANCE.sendToServer(new CatchCompleteData(entity.method_5628()));
    }
}

