/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.network;

import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import win.demistorm.ConfigHelper;
import win.demistorm.ModCompat;
import win.demistorm.ThrownProjectileEntity;
import win.demistorm.VRThrowingExtensions;
import win.demistorm.client.particles.BleedingParticle;
import win.demistorm.client.particles.BloodParticle;
import win.demistorm.network.BleedingParticleData;
import win.demistorm.network.BloodParticleData;
import win.demistorm.network.CatchCompleteData;
import win.demistorm.network.CatchData;
import win.demistorm.network.CatchUpdateData;
import win.demistorm.network.ConfigSyncData;
import win.demistorm.network.ThrowData;

public final class NetworkHandlers {
    public static void handleThrow(class_1657 player, ThrowData data) {
        if (player == null || !player.method_5805()) {
            return;
        }
        class_1799 heldStack = player.method_6047();
        if (heldStack.method_7960() || ModCompat.throwingDisabled(heldStack)) {
            return;
        }
        ThrownProjectileEntity proj = new ThrownProjectileEntity(player.method_37908(), (class_1309)player, heldStack, data.wholeStack());
        proj.method_16940(heldStack.method_46651(1));
        class_243 pos = new class_243(data.posX(), data.posY(), data.posZ());
        class_243 vel = new class_243(data.velX(), data.velY(), data.velZ());
        proj.method_33574(pos);
        proj.setOriginalThrowPos(pos);
        proj.method_18799(vel);
        proj.setHandRoll(data.rollDeg());
        VRThrowingExtensions.log.debug("[Server] Spawning thrown proj {} with item {}", (Object)proj.method_5628(), (Object)proj.method_7495());
        player.method_37908().method_8649((class_1297)proj);
        float attackDamage = ThrownProjectileEntity.stackBaseDamage(heldStack);
        VRThrowingExtensions.log.debug("[Network] Thrown item attack damage = {}", (Object)Float.valueOf(attackDamage));
        if (attackDamage <= 1.0f) {
            if (!player.method_37908().method_8608()) {
                player.method_37908().method_8396(null, player.method_24515(), class_3417.field_15067, class_3419.field_15248, 0.6f, 1.05f);
            }
        } else if (!player.method_37908().method_8608()) {
            player.method_37908().method_8396(null, player.method_24515(), (class_3414)class_3417.field_15001.comp_349(), class_3419.field_15248, 0.6f, 1.33f);
        }
        if (data.wholeStack()) {
            player.method_6122(class_1268.field_5808, class_1799.field_8037);
        } else if (heldStack.method_7947() > 1) {
            heldStack.method_7934(1);
        } else {
            player.method_6122(class_1268.field_5808, class_1799.field_8037);
        }
    }

    public static void handleCatch(class_1657 player, CatchData data) {
        if (player == null || !player.method_5805()) {
            return;
        }
        class_3218 world = (class_3218)player.method_37908();
        class_1297 class_12972 = world.method_8469(data.entityId());
        if (!(class_12972 instanceof ThrownProjectileEntity)) {
            return;
        }
        ThrownProjectileEntity projectile = (ThrownProjectileEntity)class_12972;
        if (data.startCatch()) {
            projectile.startCatch();
        } else {
            projectile.cancelCatch();
        }
    }

    public static void handleCatchUpdate(class_1657 player, CatchUpdateData data) {
        if (player == null || !player.method_5805()) {
            return;
        }
        class_3218 world = (class_3218)player.method_37908();
        class_1297 class_12972 = world.method_8469(data.entityId());
        if (!(class_12972 instanceof ThrownProjectileEntity)) {
            return;
        }
        ThrownProjectileEntity projectile = (ThrownProjectileEntity)class_12972;
        if (!projectile.isCatching()) {
            return;
        }
        class_243 newVel = new class_243(data.velX(), data.velY(), data.velZ());
        projectile.method_18799(newVel);
        projectile.setHandRoll(data.rollDeg());
    }

    public static void handleCatchComplete(class_1657 player, CatchCompleteData data) {
        if (player == null || !player.method_5805()) {
            return;
        }
        class_3218 world = (class_3218)player.method_37908();
        class_1297 class_12972 = world.method_8469(data.entityId());
        if (!(class_12972 instanceof ThrownProjectileEntity)) {
            return;
        }
        ThrownProjectileEntity projectile = (ThrownProjectileEntity)class_12972;
        if (!projectile.isCatching()) {
            return;
        }
        class_1799 mainHand = player.method_6047();
        if (!mainHand.method_7960()) {
            return;
        }
        class_1799 projectileStack = projectile.method_7495();
        int stackSize = projectile.getStackSize();
        if (!player.method_37908().method_8608()) {
            player.method_37908().method_8396(null, player.method_24515(), class_3417.field_15197, class_3419.field_15248, 0.5f, 2.0f);
        }
        class_1799 giveStack = projectileStack.method_7972();
        giveStack.method_7939(stackSize);
        player.method_6122(class_1268.field_5808, giveStack);
        projectile.method_31472();
    }

    public static void handleBloodParticle(class_1657 player, BloodParticleData data) {
        if (player != null && player.method_37908().method_8608()) {
            BloodParticle.spawnParticles(data);
        }
        VRThrowingExtensions.log.debug("[Network] Received blood particle packet at ({}, {}, {})", new Object[]{data.posX(), data.posY(), data.posZ()});
    }

    public static void handleBleedingParticle(class_1657 player, BleedingParticleData data) {
        if (player != null && player.method_37908().method_8608()) {
            BleedingParticle.spawnBleedingParticles(data);
        }
        VRThrowingExtensions.log.debug("[Network] Received bleeding particle packet at ({}, {}, {})", new Object[]{data.posX(), data.posY(), data.posZ()});
    }

    public static void handleConfigSync(class_1657 player, ConfigSyncData data) {
        ConfigHelper.clientReceivedRemote(data.json());
        VRThrowingExtensions.log.debug("[Network] Received config sync packet for player: {}", (Object)player.method_5477().getString());
    }
}

