/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.effects;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3966;
import win.demistorm.ThrownProjectileEntity;
import win.demistorm.VRThrowingExtensions;
import win.demistorm.network.BleedingParticleData;
import win.demistorm.network.Network;

public final class EmbeddingEffect {
    public static final float targetRollDegX = 70.0f;
    public static final float rollApproachPerTick = 20.0f;
    private static final float forwardSpinSpeedDegPerTick = 15.0f;
    private static final double embedAdjust = 0.3;
    private static final int bleedIntervalTicks = 30;
    private static final float bleedDamage = 1.0f;

    private EmbeddingEffect() {
    }

    public static void startEmbedding(ThrownProjectileEntity proj, class_3966 hit, class_243 clampedHitPos) {
        if (proj.method_37908().method_8608()) {
            return;
        }
        class_1297 target = hit.method_17782();
        if (!(target instanceof class_1309)) {
            proj.dropAndDiscard();
            return;
        }
        class_1309 living = (class_1309)target;
        class_243 dir = proj.method_18798();
        if (dir.method_1027() < 1.0E-6) {
            dir = hit.method_17784().method_1020(proj.method_19538());
        }
        if (dir.method_1027() < 1.0E-6) {
            dir = new class_243(1.0, 0.0, 0.0);
        }
        dir = dir.method_1029();
        class_243 embedPos = EmbeddingEffect.calculateEmbedPosition(target, clampedHitPos);
        float yaw = (float)(class_3532.method_15349((double)dir.field_1350, (double)dir.field_1352) * 180.0 / Math.PI);
        float pitch = (float)(class_3532.method_15349((double)dir.field_1351, (double)Math.sqrt(dir.field_1352 * dir.field_1352 + dir.field_1350 * dir.field_1350)) * 180.0 / Math.PI);
        float tiltDeg = -proj.getHandRoll();
        float initialXRollDeg = (float)proj.field_6012 * 15.0f % 360.0f;
        class_243 worldOffset = embedPos.method_1020(target.method_19538());
        proj.beginEmbedding(living, worldOffset, yaw, pitch, tiltDeg, initialXRollDeg);
        BleedManager.register(living, proj.method_37908().method_8510(), proj);
        proj.method_37908().method_8396(null, proj.method_24515(), class_3417.field_24065, class_3419.field_15248, 0.45f, 0.8f);
        double finalEmbedDepth = clampedHitPos.method_1022(embedPos);
        VRThrowingExtensions.log.debug("[Embed] Projectile {} embedded into {} at {} (+{}), yaw={}, pitch={}, tilt={}, xRollStart={}", new Object[]{proj.method_5628(), target.method_5477().getString(), clampedHitPos, String.format("%.2f", finalEmbedDepth), String.format("%.1f", Float.valueOf(yaw)), String.format("%.1f", Float.valueOf(pitch)), String.format("%.1f", Float.valueOf(tiltDeg)), String.format("%.1f", Float.valueOf(initialXRollDeg))});
    }

    private static class_243 calculateEmbedPosition(class_1297 target, class_243 hitPos) {
        class_238 boundingBox = target.method_5829();
        class_243 centerAtHitY = new class_243(boundingBox.method_1005().field_1352, hitPos.field_1351, boundingBox.method_1005().field_1350);
        class_243 toCenter = centerAtHitY.method_1020(hitPos);
        class_243 adjustment = toCenter.method_1021(0.3);
        return hitPos.method_1019(adjustment);
    }

    public static void tickEmbedded(ThrownProjectileEntity proj) {
        class_1309 living;
        if (!proj.isEmbedded()) {
            return;
        }
        if (proj.method_37908().method_8608()) {
            return;
        }
        class_1297 target = proj.getEmbeddedTarget();
        if (!(target instanceof class_1309) || !(living = (class_1309)target).method_5805() || target.method_31481()) {
            VRThrowingExtensions.log.debug("[Embed] Host entity lost; dropping projectile {}", (Object)proj.method_5628());
            proj.clearEmbedding();
            proj.dropAndDiscard();
            return;
        }
        float hostBodyYaw = living.method_5791();
        float hostPitch = living.method_36455();
        class_243 base = target.method_19538();
        class_243 offsetWorld = EmbeddingEffect.rotateY(proj.getEmbeddedOffset(), hostBodyYaw);
        class_243 newPos = base.method_1019(offsetWorld);
        proj.method_33574(newPos);
        proj.method_18799(class_243.field_1353);
        proj.method_5875(true);
        float worldYaw = class_3532.method_15393((float)(hostBodyYaw + proj.getEmbeddedLocalYaw()));
        float worldPitch = class_3532.method_15393((float)(hostPitch + proj.getEmbeddedLocalPitch()));
        proj.setEmbedYaw(worldYaw);
        proj.setEmbedPitch(worldPitch);
        float current = proj.getEmbedRoll();
        float baseAngle = 70.0f;
        float nearestTarget = baseAngle + 360.0f * (float)Math.round((current - baseAngle) / 360.0f);
        float diff = nearestTarget - current;
        if (Math.abs(diff) > 0.01f) {
            float step = Math.copySign(20.0f, diff);
            float next = Math.abs(diff) <= 20.0f ? nearestTarget : current + step;
            proj.setEmbedRoll(next);
        }
        BleedManager.tryApplyBleed(living, proj.method_37908().method_8510());
        if (proj.field_6012 % 20 == 0) {
            VRThrowingExtensions.log.debug("[Embed] Following host. proj={} bodyYaw={} worldYaw={} pos={}", new Object[]{proj.method_5628(), String.format("%.1f", Float.valueOf(hostBodyYaw)), String.format("%.1f", Float.valueOf(worldYaw)), proj.method_19538()});
        }
    }

    public static void releaseEmbedding(ThrownProjectileEntity proj) {
        if (!proj.isEmbedded()) {
            return;
        }
        proj.clearEmbedding();
        proj.method_5875(true);
        proj.method_18799(class_243.field_1353);
        VRThrowingExtensions.log.debug("[Embed] Released projectile {} from embed state for catching", (Object)proj.method_5628());
    }

    private static class_243 rotateY(class_243 v, float degrees) {
        double rad = Math.toRadians(degrees);
        double cos = Math.cos(rad);
        double sin = Math.sin(rad);
        double x = v.field_1352 * cos - v.field_1350 * sin;
        double z = v.field_1352 * sin + v.field_1350 * cos;
        return new class_243(x, v.field_1351, z);
    }

    public static final class BleedManager {
        private static final Map<class_1309, BleedState> STATES = new WeakHashMap<class_1309, BleedState>();

        static void register(class_1309 host, long worldTime, ThrownProjectileEntity proj) {
            BleedState st = STATES.get(host);
            if (st == null) {
                st = new BleedState(worldTime);
                STATES.put(host, st);
                VRThrowingExtensions.log.debug("[Bleed] Anchor set for {} at worldTick={}", (Object)host.method_5477().getString(), (Object)worldTime);
            }
            st.projs.add(proj);
            VRThrowingExtensions.log.debug("[Bleed] Added embed for {}. count={}", (Object)host.method_5477().getString(), (Object)st.projs.size());
        }

        public static void unregister(class_1309 host, ThrownProjectileEntity proj) {
            BleedState st = STATES.get(host);
            if (st == null) {
                return;
            }
            st.projs.remove((Object)proj);
            if (st.projs.isEmpty()) {
                STATES.remove(host);
                VRThrowingExtensions.log.debug("[Bleed] Cleared bleed state for {} (no more embeds)", (Object)host.method_5477().getString());
            } else {
                VRThrowingExtensions.log.debug("[Bleed] Removed embed for {}. Remaining count={}", (Object)host.method_5477().getString(), (Object)st.projs.size());
            }
        }

        static void tryApplyBleed(class_1309 host, long worldTime) {
            BleedState st = STATES.get(host);
            if (st == null) {
                return;
            }
            if (!host.method_5805()) {
                STATES.remove(host);
                VRThrowingExtensions.log.debug("[Bleed] Host {} died. Removing bleed state.", (Object)host.method_5477().getString());
                return;
            }
            long delta = worldTime - st.anchorTick;
            if (delta < 30L) {
                return;
            }
            if (delta % 30L != 0L) {
                return;
            }
            if (st.lastAppliedTick == worldTime) {
                return;
            }
            st.lastAppliedTick = worldTime;
            int activeCount = 0;
            for (ThrownProjectileEntity p : st.projs) {
                if (p == null || p.method_31481() || !p.isEmbedded()) continue;
                ++activeCount;
            }
            if (activeCount <= 0) {
                STATES.remove(host);
                return;
            }
            float total = 1.0f * (float)activeCount;
            class_3218 sw = (class_3218)host.method_37908();
            host.method_64397(sw, sw.method_48963().method_48830(), total);
            for (ThrownProjectileEntity p : st.projs) {
                if (p == null || p.method_31481() || !p.isEmbedded()) continue;
                class_243 pos = p.method_19538();
                for (class_3222 player : sw.method_8503().method_3760().method_14571()) {
                    if (player.method_37908() != sw || !(player.method_5707(pos) < 4096.0)) continue;
                    Network.INSTANCE.sendToPlayer(player, new BleedingParticleData(pos.field_1352, pos.field_1351, pos.field_1350));
                }
            }
            VRThrowingExtensions.log.debug("[Bleed] Applied {} bleed to {} at tick {} (embeds={}, anchor={})", new Object[]{Float.valueOf(total), host.method_5477().getString(), worldTime, activeCount, st.anchorTick});
        }

        private static final class BleedState {
            final long anchorTick;
            long lastAppliedTick = Long.MIN_VALUE;
            final Set<ThrownProjectileEntity> projs = Collections.newSetFromMap(new IdentityHashMap());

            BleedState(long anchorTick) {
                this.anchorTick = anchorTick;
            }
        }
    }
}

