/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.network;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.class_3222;
import net.minecraft.class_5455;
import net.minecraft.class_9129;
import win.demistorm.Platform;

public class NetworkChannel {
    private final List<PacketRegistrationData<?>> packets = new ArrayList();

    public <T> void register(Class<T> clazz, BiConsumer<T, class_9129> encoder, Function<class_9129, T> decoder, BiConsumer<T, class_3222> handler) {
        this.packets.add(new PacketRegistrationData<T>(this.packets.size(), clazz, encoder, decoder, handler));
    }

    public <T> void sendToServer(T message) {
        Platform.sendToServer(this.encode(message, this.getClientRegistryAccess()));
    }

    public <T> void sendToPlayer(class_3222 player, T message) {
        Platform.sendToPlayer(player, this.encode(message, player.method_56673()));
    }

    public <T> void handlePacket(class_3222 player, class_9129 buffer) {
        Object message;
        int packetId = buffer.readInt();
        if (packetId < 0 || packetId >= this.packets.size()) {
            return;
        }
        PacketRegistrationData<?> data = this.packets.get(packetId);
        try {
            message = data.decoder.apply(buffer);
        }
        catch (Exception e) {
            return;
        }
        data.handler.accept(message, player);
    }

    private <T> class_9129 encode(T message, class_5455 access) {
        PacketRegistrationData<T> data = this.getData(message);
        class_9129 buffer = new class_9129(Unpooled.buffer(), access);
        buffer.method_53002(data.id());
        data.encoder().accept(message, buffer);
        return buffer;
    }

    private <T> PacketRegistrationData<T> getData(T message) {
        for (PacketRegistrationData<?> data : this.packets) {
            if (data.clazz != message.getClass()) continue;
            return data;
        }
        throw new IllegalArgumentException("Packet type not registered: " + message.getClass().getName());
    }

    private class_5455 getClientRegistryAccess() {
        return Platform.getClientRegistryAccess();
    }

    public record PacketRegistrationData<T>(int id, Class<T> clazz, BiConsumer<T, class_9129> encoder, Function<class_9129, T> decoder, BiConsumer<T, class_3222> handler) {
    }
}

