/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.effects;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.phys.Vec3;
import win.demistorm.ThrownProjectileEntity;
import win.demistorm.VRThrowingExtensions;

public final class BoomerangEffect {
    public static final double baseReturnSpeed = 1.0;
    public static final double closeDistance = 3.0;
    public static final double farDistance = 25.0;
    public static final double closeSpeedMultiplier = 0.3;
    public static final double farSpeedMultiplier = 2.0;
    public static final double scalingCurve = 1.2;
    public static final double arcGain = 0.6;
    public static final double arcMin = 0.8;
    public static final double arcMax = 6.0;
    public static final double arcDecayPerStep = 0.8;
    public static final double maxTurnRateNear = Math.toRadians(30.0);
    public static final double maxTurnRateFar = Math.toRadians(55.0);
    public static final double lateralStartBoost = 0.35;
    public static final double dampFactor = 0.95;
    public static final double maxOverTarget = 1.6;
    public static final double minUnderTarget = 0.45;
    public static final Set<Item> bounceTools = new HashSet<Item>();

    public static boolean canBounce(Item i) {
        return bounceTools.contains(i);
    }

    public static void startBounce(ThrownProjectileEntity proj) {
        proj.hasBounced = true;
        proj.bounceActive = true;
        proj.clearSpawnImmunity();
        Vec3 currentPos = proj.position();
        Vec3 toOrigin = proj.originalThrowPos.subtract(currentPos);
        double distanceToOrigin = toOrigin.length();
        if (distanceToOrigin < 0.1) {
            VRThrowingExtensions.log.debug("[Boomerang] Too close to origin, dropping normally");
            proj.bounceActive = false;
            return;
        }
        Vec3 dir = toOrigin.normalize();
        double rollRad = Math.toRadians(proj.getHandRoll());
        Vec3 worldUp = new Vec3(0.0, 1.0, 0.0);
        Vec3 upRolled = BoomerangEffect.rotateAroundAxis(worldUp, dir, rollRad);
        Vec3 upProj = BoomerangEffect.projectPerp(upRolled, dir);
        Vec3 right = dir.cross(upRolled).normalize();
        double cosR = Math.cos(rollRad);
        double sinR = Math.sin(rollRad);
        Vec3 curveDir = upProj.scale(cosR).add(right.scale(sinR)).normalize();
        proj.bounceInverse = proj.getHandRoll() < 0.0f;
        Vec3 planeNormal = dir.cross(curveDir).normalize();
        if (proj.bounceInverse) {
            planeNormal = planeNormal.scale(-1.0);
        }
        double arcMag = Mth.clamp((double)(distanceToOrigin * 0.6), (double)0.8, (double)6.0);
        proj.bouncePlaneNormal = planeNormal;
        proj.bounceArcMag = arcMag;
        double speedMultiplier = BoomerangEffect.calculateSpeedMultiplier(distanceToOrigin);
        double bounceSpeed = 1.0 * speedMultiplier;
        Vec3 baseVel = dir.scale(bounceSpeed);
        Vec3 lateralVel = curveDir.scale(bounceSpeed * 0.35);
        Vec3 finalVel = baseVel.add(lateralVel).add(0.0, 0.02, 0.0);
        proj.setDeltaMovement(finalVel);
        proj.setNoGravity(true);
        if (!proj.level().isClientSide()) {
            proj.level().playSound(null, proj.blockPosition(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.6f, 1.5f);
        }
        VRThrowingExtensions.log.debug("[Boomerang] Projectile {} started return. Dist={}. Roll={}\u00b0, Speed={} (mult={}), ArcMag={}", new Object[]{proj.getId(), String.format("%.2f", distanceToOrigin), String.format("%.1f", Float.valueOf(proj.getHandRoll())), String.format("%.3f", bounceSpeed), String.format("%.2f", speedMultiplier), String.format("%.2f", arcMag)});
    }

    public static boolean tickReturn(ThrownProjectileEntity proj) {
        Vec3 currentPos = proj.position();
        Vec3 toOrigin = proj.originalThrowPos.subtract(currentPos);
        double distSq = toOrigin.lengthSqr();
        boolean reachedOrigin = false;
        if (distSq < 0.36) {
            reachedOrigin = true;
            VRThrowingExtensions.log.debug("[Boomerang] Projectile {} reached origin (dist={})", (Object)proj.getId(), (Object)String.format("%.3f", Math.sqrt(distSq)));
        } else {
            double dot;
            Vec3 currentVel = proj.getDeltaMovement();
            if (currentVel.length() > 0.01 && (dot = currentVel.normalize().dot(toOrigin.normalize())) < -0.8 && distSq < 4.0) {
                reachedOrigin = true;
                VRThrowingExtensions.log.debug("[Boomerang] Projectile {} overshot origin (dist={}, dot={})", new Object[]{proj.getId(), String.format("%.3f", Math.sqrt(distSq)), String.format("%.3f", dot)});
            }
        }
        if (reachedOrigin) {
            return true;
        }
        Vec3 target = proj.originalThrowPos.add(proj.bounceCurveOffset);
        Vec3 toTarget = target.subtract(currentPos);
        double distance = toTarget.length();
        if (distance < 1.0E-4) {
            return false;
        }
        Vec3 wantDir = toTarget.normalize();
        Vec3 currentVel = proj.getDeltaMovement();
        double speedMultiplier = BoomerangEffect.calculateSpeedMultiplier(Math.sqrt(distSq));
        double targetSpeed = 1.0 * speedMultiplier;
        double turnRate = Mth.lerp((double)Mth.clamp((float)((float)(distance / 25.0)), (float)0.0f, (float)1.0f), (double)maxTurnRateNear, (double)maxTurnRateFar);
        Vec3 turned = BoomerangEffect.turnTowards(currentVel, wantDir, turnRate);
        Vec3 newVel = turned.scale(0.95);
        double newSpeed = newVel.length();
        double maxSpeed = targetSpeed * 1.6;
        double minSpeed = targetSpeed * 0.45;
        if (newSpeed > maxSpeed) {
            newVel = newVel.normalize().scale(maxSpeed);
        } else if (newSpeed < minSpeed && newSpeed > 1.0E-4) {
            newVel = newVel.normalize().scale(minSpeed);
        }
        proj.setDeltaMovement(newVel);
        double nearFactor = Mth.clamp((double)(1.0 - distance / 25.0), (double)0.0, (double)0.8);
        double decay = Mth.lerp((double)nearFactor, (double)0.8, (double)0.6000000000000001);
        proj.bounceCurveOffset = proj.bounceCurveOffset.scale(decay);
        if (proj.tickCount % 20 == 0) {
            VRThrowingExtensions.log.debug("[Boomerang] Return: dist={}, speed={}, target={}, arcLen={}", new Object[]{String.format("%.2f", Math.sqrt(distSq)), String.format("%.3f", newVel.length()), String.format("%.3f", targetSpeed), String.format("%.2f", proj.bounceCurveOffset.lengthSqr() > 0.0 ? Math.sqrt(proj.bounceCurveOffset.lengthSqr()) : 0.0)});
        }
        return false;
    }

    private static double calculateSpeedMultiplier(double distance) {
        if (distance <= 3.0) {
            return 0.3;
        }
        if (distance >= 25.0) {
            return 2.0;
        }
        double t = (distance - 3.0) / 22.0;
        t = Math.pow(t, 1.2);
        return Mth.lerp((float)((float)t), (float)0.3f, (float)2.0f);
    }

    private static Vec3 rotateAroundAxis(Vec3 v, Vec3 axis, double angle) {
        Vec3 k = axis.normalize();
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        double dot = v.dot(k);
        Vec3 term1 = v.scale(cos);
        Vec3 term2 = k.cross(v).scale(sin);
        Vec3 term3 = k.scale(dot * (1.0 - cos));
        return term1.add(term2).add(term3);
    }

    private static Vec3 projectPerp(Vec3 v, Vec3 normal) {
        double d = v.dot(normal);
        return v.subtract(normal.scale(d)).normalize();
    }

    private static Vec3 turnTowards(Vec3 currentVel, Vec3 wantDir, double maxAngle) {
        double speed = currentVel.length();
        if (speed < 1.0E-6) {
            return wantDir.scale(speed);
        }
        Vec3 curDir = currentVel.normalize();
        double dot = Mth.clamp((double)curDir.dot(wantDir), (double)-1.0, (double)1.0);
        double angle = Math.acos(dot);
        if (angle <= maxAngle) {
            return wantDir.scale(speed);
        }
        Vec3 axis = curDir.cross(wantDir);
        if (axis.lengthSqr() < 1.0E-9) {
            Vec3 turnDir = curDir.scale(0.999).add(wantDir.scale(0.001)).normalize();
            return turnDir.scale(speed);
        }
        Vec3 rotated = BoomerangEffect.rotateAroundAxis(curDir, axis, maxAngle);
        return rotated.normalize().scale(speed);
    }

    private BoomerangEffect() {
    }

    static {
        BuiltInRegistries.ITEM.stream().filter(i -> !BuiltInRegistries.ITEM.getKey(i).equals((Object)ResourceLocation.withDefaultNamespace((String)"air"))).forEach(bounceTools::add);
    }
}

