/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.heartymeals.common.component.entity;

import java.util.Optional;
import moriyashiine.heartymeals.common.HeartyMeals;
import moriyashiine.heartymeals.common.ModConfig;
import moriyashiine.heartymeals.common.event.UniqueIngredientsEvent;
import moriyashiine.heartymeals.common.init.ModEntityComponents;
import moriyashiine.heartymeals.common.init.ModStatusEffects;
import moriyashiine.heartymeals.common.tag.ModBlockTags;
import moriyashiine.heartymeals.common.tag.ModItemTags;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3922;
import net.minecraft.class_7923;
import net.minecraft.class_9334;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;
import org.ladysnake.cca.api.v3.component.tick.CommonTickingComponent;
import vectorwing.farmersdelight.common.registry.ModEffects;

public class FoodHealingComponent
implements AutoSyncedComponent,
CommonTickingComponent {
    public static float modifiedSaturation = -1.0f;
    private final class_1657 obj;
    private boolean fromSaturation = false;
    private int healAmount = 0;
    private int ticksPerHeal = 0;
    private int healTicks = 0;
    private int amountHealed = 0;

    public FoodHealingComponent(class_1657 obj) {
        this.obj = obj;
    }

    public void readData(class_11368 readView) {
        this.fromSaturation = readView.method_71433("FromSaturation", false);
        this.healAmount = readView.method_71424("HealAmount", 0);
        this.ticksPerHeal = readView.method_71424("TicksPerHeal", 0);
        this.healTicks = readView.method_71424("HealTicks", 0);
        this.amountHealed = readView.method_71424("AmountHealed", 0);
    }

    public void writeData(class_11372 writeView) {
        writeView.method_71472("FromSaturation", this.fromSaturation);
        writeView.method_71465("HealAmount", this.healAmount);
        writeView.method_71465("TicksPerHeal", this.ticksPerHeal);
        writeView.method_71465("HealTicks", this.healTicks);
        writeView.method_71465("AmountHealed", this.amountHealed);
    }

    public void tick() {
        this.tickFoodHealing();
        this.tickCampfire();
        this.tickNourishment();
    }

    public void sync() {
        ModEntityComponents.FOOD_HEALING.sync((Object)this.obj);
    }

    public void setFromSaturation(boolean fromSaturation) {
        this.fromSaturation = fromSaturation;
    }

    public int getHealAmount() {
        return this.healAmount;
    }

    public int getAmountHealed() {
        return this.amountHealed;
    }

    public int getMaximumHealTicks() {
        return this.healAmount * this.ticksPerHeal;
    }

    public boolean canEat() {
        return this.healAmount == 0;
    }

    public void startHealing(int food, float saturation) {
        if (this.fromSaturation) {
            this.fromSaturation = false;
            int duration = this.obj.method_6112(class_1294.field_5922).method_5584();
            if (duration == -1) {
                duration = this.obj.field_6012;
            }
            if (duration % 2 == 0) {
                this.obj.method_6025((float)food);
            }
        } else if (food > 0) {
            this.healAmount = food;
            this.ticksPerHeal = FoodHealingComponent.getTicksPerHeal(saturation);
            for (class_1792 item : class_7923.field_41178) {
                if (!item.method_57347().method_57832(class_9334.field_50075)) continue;
                this.obj.method_7357().method_62835(item.method_7854(), this.getMaximumHealTicks());
            }
            for (int i = 0; i < this.obj.method_31548().method_5439(); ++i) {
                class_1799 stack = this.obj.method_31548().method_5438(i);
                if (!stack.method_57826(class_9334.field_50075)) continue;
                this.obj.method_7357().method_62835(stack, this.getMaximumHealTicks());
            }
        }
    }

    public static float getModifiedSaturation(class_1799 stack, float saturation) {
        if (stack.method_31573(ModItemTags.INCREASED_SATURATION)) {
            saturation *= 2.6f;
        }
        return saturation + (float)UniqueIngredientsEvent.getUniqueIngredients(stack.method_7909()) / 2.0f;
    }

    public static int getTicksPerHeal(float saturation) {
        return class_3532.method_15375((float)((float)((int)Math.max(5.0f, class_3532.method_16439((float)(saturation / 20.0f), (float)60.0f, (float)0.0f))) * ModConfig.regenerationTimeMultiplier));
    }

    private void tickFoodHealing() {
        if (this.healAmount > 0) {
            ++this.healTicks;
            if (this.healTicks % this.ticksPerHeal == 0) {
                class_1937 class_19372 = this.obj.method_73183();
                if (class_19372 instanceof class_3218) {
                    class_3218 world = (class_3218)class_19372;
                    if (!this.obj.method_6059(class_1294.field_5903) && world.method_64395().method_8355(class_1928.field_19395)) {
                        this.obj.method_6025(1.0f);
                    }
                }
                ++this.amountHealed;
            }
            if (this.healTicks == this.getMaximumHealTicks()) {
                this.amountHealed = 0;
                this.healTicks = 0;
                this.ticksPerHeal = 0;
                this.healAmount = 0;
            }
        }
    }

    private void tickCampfire() {
        if (this.obj.field_6012 % 20 == 0) {
            if (ModConfig.campfireHealing) {
                Optional closestCampfire = class_2338.method_25997((class_2338)this.obj.method_24515(), (int)5, (int)5, foundPos -> FoodHealingComponent.isCozySource(this.obj.method_73183(), foundPos));
                if (closestCampfire.isEmpty()) {
                    closestCampfire = class_2338.method_25997((class_2338)this.obj.method_24515(), (int)15, (int)15, foundPos -> FoodHealingComponent.isCozySource(this.obj.method_73183(), foundPos) && ((class_3922)class_2246.field_17350).method_17456(this.obj.method_73183().method_8320(foundPos.method_10074())));
                }
                if (closestCampfire.isPresent()) {
                    this.obj.method_6092(new class_1293(ModStatusEffects.COZY, -1, 0, true, false, true));
                } else {
                    this.obj.method_6016(ModStatusEffects.COZY);
                }
            } else {
                this.obj.method_6016(ModStatusEffects.COZY);
            }
        }
    }

    private void tickNourishment() {
        if (HeartyMeals.farmersDelightLoaded && this.obj.method_6059(ModEffects.NOURISHMENT)) {
            class_1293 instance = this.obj.method_6112(ModEffects.NOURISHMENT);
            int duration = instance.method_5584();
            if (duration == -1) {
                duration = this.obj.field_6012;
            }
            if (duration % 200 == 0) {
                this.obj.method_6025((float)(instance.method_5578() + 1));
            }
        }
    }

    private static boolean isCozySource(class_1937 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        if (state.method_26164(ModBlockTags.COZY_SOURCES)) {
            return !state.method_28498((class_2769)class_2741.field_12548) || (Boolean)state.method_11654((class_2769)class_2741.field_12548) != false;
        }
        return false;
    }
}

