/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.heartymeals.common.event;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.HashSet;
import moriyashiine.heartymeals.client.payload.SyncUniqueIngredientsPayload;
import moriyashiine.heartymeals.common.HeartyMeals;
import moriyashiine.heartymeals.common.tag.ModItemTags;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1792;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_3244;
import net.minecraft.class_3532;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_6860;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_8786;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import vectorwing.farmersdelight.common.crafting.CookingPotRecipe;
import vectorwing.farmersdelight.common.registry.ModRecipeTypes;

public class UniqueIngredientsEvent {
    public static final Object2IntMap<class_1792> UNIQUE_INGREDIENTS = new Object2IntOpenHashMap();

    public static int getUniqueIngredients(class_1792 item) {
        return UNIQUE_INGREDIENTS.getOrDefault((Object)item, 0);
    }

    private static int getUniqueIngredients(class_1792 item, MinecraftServer server) {
        int recipes = 0;
        int uniqueIngredients = 0;
        for (class_8786 recipeEntry : server.method_3772().getAllOfType(class_3956.field_17545)) {
            try {
                if (!((class_3955)recipeEntry.comp_1933()).method_8116(null, (class_7225.class_7874)server.method_30611()).method_31574(item)) continue;
                ++recipes;
                uniqueIngredients += UniqueIngredientsEvent.getUniqueIngredients(recipeEntry.comp_1933());
            }
            catch (Exception exception) {}
        }
        if (HeartyMeals.farmersDelightLoaded) {
            for (class_8786 recipeEntry : server.method_3772().getAllOfType((class_3956)ModRecipeTypes.COOKING.get())) {
                try {
                    if (!((CookingPotRecipe)recipeEntry.comp_1933()).method_8116(null, (class_7225.class_7874)server.method_30611()).method_31574(item)) continue;
                    ++recipes;
                    uniqueIngredients += UniqueIngredientsEvent.getUniqueIngredients(recipeEntry.comp_1933());
                }
                catch (Exception exception) {}
            }
        }
        return class_3532.method_15375((float)((float)uniqueIngredients / (float)recipes));
    }

    private static int getUniqueIngredients(class_1860<?> recipe) {
        HashSet<class_1856> unique = new HashSet<class_1856>();
        for (class_1856 ingredient : recipe.method_61671().method_64675()) {
            if (!ingredient.method_8105().anyMatch(itemEntry -> itemEntry.method_40220(ModItemTags.FOOD_INGREDIENTS))) continue;
            unique.add(ingredient);
        }
        return unique.size();
    }

    private static void populate(MinecraftServer server) {
        UNIQUE_INGREDIENTS.clear();
        for (class_1792 item : class_7923.field_41178) {
            int uniqueIngredients;
            if (!item.method_57347().method_57832(class_9334.field_50075) || item.method_7854().method_31573(ModItemTags.IGNORES_INGREDIENT_BONUS) || (uniqueIngredients = UniqueIngredientsEvent.getUniqueIngredients(item, server)) <= 0) continue;
            UNIQUE_INGREDIENTS.put((Object)item, uniqueIngredients);
        }
    }

    public static class Join
    implements ServerPlayConnectionEvents.Join {
        public void onPlayReady(class_3244 handler, PacketSender sender, MinecraftServer server) {
            SyncUniqueIngredientsPayload.send(handler.method_32311());
        }
    }

    public static class Reload
    implements ServerLifecycleEvents.EndDataPackReload {
        public void endDataPackReload(MinecraftServer server, class_6860 resourceManager, boolean success) {
            UniqueIngredientsEvent.populate(server);
            PlayerLookup.all((MinecraftServer)server).forEach(SyncUniqueIngredientsPayload::send);
        }
    }

    public static class Start
    implements ServerLifecycleEvents.ServerStarted {
        public void onServerStarted(MinecraftServer server) {
            UniqueIngredientsEvent.populate(server);
        }
    }
}

