/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.api.cosmereEffect;

import com.google.common.collect.Maps;
import java.util.Map;
import leaf.cosmere.api.cosmereEffect.AttributeModifierInfo;
import leaf.cosmere.api.providers.ICosmereEffectProvider;
import leaf.cosmere.api.spiritweb.ISpiritweb;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public abstract class CosmereEffect
implements ICosmereEffectProvider {
    private final Map<Attribute, AttributeModifierInfo> attributeModifiers = Maps.newHashMap();

    protected CosmereEffect() {
    }

    public Map<Attribute, AttributeModifierInfo> getAttributeModifiers() {
        return this.attributeModifiers;
    }

    public CosmereEffect addAttributeModifier(Attribute attribute, double amount, AttributeModifier.Operation operation) {
        AttributeModifierInfo attributeModifier = new AttributeModifierInfo(attribute, amount, operation);
        this.attributeModifiers.put(attribute, attributeModifier);
        return this;
    }

    protected int getTickToCheck(ISpiritweb data) {
        return data.getLiving().f_19797_ + this.getTickOffset();
    }

    protected int getTickOffset() {
        return 0;
    }

    protected int getActiveTick() {
        return 20;
    }

    protected boolean isActiveTick(ISpiritweb data) {
        return this.getTickToCheck(data) % this.getActiveTick() == 0;
    }

    public void applyEffectTick(ISpiritweb data, double strength) {
    }

    @Override
    public CosmereEffect getEffect() {
        return this;
    }

    @Override
    public String getTranslationKey() {
        ResourceLocation regName = this.getRegistryName();
        return "effect." + regName.m_135827_() + "." + regName.m_135815_();
    }
}

