/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.api.helpers;

import com.mojang.authlib.GameProfile;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class PlayerHelper {
    public static String getPlayerName(UUID id, MinecraftServer server) {
        Optional gameProfile;
        if (server != null && (gameProfile = server.m_129927_().m_11002_(id)).isPresent()) {
            return ((GameProfile)gameProfile.get()).getName();
        }
        return "OFFLINE Player";
    }

    public static HitResult pickWithRange(LivingEntity player, int range) {
        Vec3 entityHitResultLocation;
        double distToEntity;
        Minecraft minecraft = Minecraft.m_91087_();
        minecraft.m_91307_().m_6180_("cosmere-pick");
        float partialTicks = minecraft.m_91296_();
        HitResult hitResult = player.m_19907_((double)range, partialTicks, false);
        Vec3 eyePosition = player.m_20299_(partialTicks);
        double distToBlock = hitResult.m_82450_().m_82557_(eyePosition);
        Vec3 viewVector = player.m_20252_(1.0f);
        Vec3 viewVectorFromEyes = eyePosition.m_82520_(viewVector.f_82479_ * (double)range, viewVector.f_82480_ * (double)range, viewVector.f_82481_ * (double)range);
        AABB aabb = player.m_20191_().m_82369_(viewVector.m_82490_((double)range)).m_82377_(1.0, 1.0, 1.0);
        EntityHitResult entityHitResult = ProjectileUtil.m_37287_((Entity)player, (Vec3)eyePosition, (Vec3)viewVectorFromEyes, (AABB)aabb, potentialEntityHit -> !potentialEntityHit.m_5833_(), (double)distToBlock);
        if (entityHitResult != null && (distToEntity = eyePosition.m_82557_(entityHitResultLocation = entityHitResult.m_82450_())) < distToBlock) {
            hitResult = entityHitResult;
        }
        minecraft.m_91307_().m_7238_();
        return hitResult;
    }

    public static void addItem(Player player, ItemStack stack) {
        if (!player.m_36356_(stack) && !player.m_9236_().f_46443_) {
            ItemEntity entity = new ItemEntity(player.m_20193_(), player.m_20182_().m_7096_(), player.m_20182_().m_7098_(), player.m_20182_().m_7094_(), stack);
            player.m_20193_().m_7967_((Entity)entity);
        }
    }
}

