/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.api.math;

import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class VectorHelper {
    public static final float kEpsilon = 1.0E-5f;

    public static Vec3 Normalize(Vec3 vec) {
        float mag = VectorHelper.Magnitude(vec);
        vec = mag > 1.0E-5f ? VectorHelper.divide(vec, mag) : Vec3.f_82478_;
        return vec;
    }

    public static float Magnitude(Vec3 vector) {
        return Mth.m_14116_((float)((float)(vector.m_7096_() * vector.m_7096_() + vector.m_7098_() * vector.m_7098_() + vector.m_7094_() * vector.m_7094_())));
    }

    public static Vec3 divide(Vec3 a, float d) {
        return new Vec3(a.m_7096_() / (double)d, a.m_7098_() / (double)d, a.m_7096_() / (double)d);
    }

    public static Vec3 moveTowards(Vec3 current, Vec3i target, float maxDistanceDelta) {
        double toVector_z;
        double toVector_y;
        double toVector_x = (double)target.m_123341_() - current.f_82479_;
        double sqdist = toVector_x * toVector_x + (toVector_y = (double)target.m_123342_() - current.f_82480_) * toVector_y + (toVector_z = (double)target.m_123343_() - current.f_82481_) * toVector_z;
        if (sqdist == 0.0 || maxDistanceDelta >= 0.0f && sqdist <= (double)(maxDistanceDelta * maxDistanceDelta)) {
            return new Vec3((double)target.m_123341_(), (double)target.m_123342_(), (double)target.m_123343_());
        }
        float dist = (float)Math.sqrt(sqdist);
        return new Vec3(current.f_82479_ + toVector_x / (double)dist * (double)maxDistanceDelta, current.f_82480_ + toVector_y / (double)dist * (double)maxDistanceDelta, current.f_82481_ + toVector_z / (double)dist * (double)maxDistanceDelta);
    }

    public static Vec3 getDirection(Vec3 target, Vec3 current, float multiplicationFactor) {
        double toVector_x = target.m_7096_() - current.f_82479_;
        double toVector_y = target.m_7098_() - current.f_82480_;
        double toVector_z = target.m_7094_() - current.f_82481_;
        return new Vec3(toVector_x * (double)multiplicationFactor, toVector_y * (double)multiplicationFactor, toVector_z * (double)multiplicationFactor);
    }

    public static Vec3 ClampMagnitude(Vec3 vector, float maxLength) {
        double sqrMag = VectorHelper.SqrMagnitude(vector);
        if (sqrMag > (double)(maxLength * maxLength)) {
            float mag = (float)Math.sqrt(sqrMag);
            double normalized_x = vector.f_82479_ / (double)mag;
            double normalized_y = vector.f_82480_ / (double)mag;
            double normalized_z = vector.f_82481_ / (double)mag;
            return new Vec3(normalized_x * (double)maxLength, normalized_y * (double)maxLength, normalized_z * (double)maxLength);
        }
        return vector;
    }

    public static double SqrMagnitude(Vec3 vector) {
        return vector.f_82479_ * vector.f_82479_ + vector.f_82480_ * vector.f_82480_ + vector.f_82481_ * vector.f_82481_;
    }
}

