/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.api;

import net.minecraft.util.Mth;

public class InterpolatedValue {
    public float defaultValue;
    private float interpolationSpeed;
    private float previousValue;
    private float currentValue;

    public InterpolatedValue(float defaultValue, float interpolationSpeed) {
        this.defaultValue = defaultValue;
        this.currentValue = defaultValue;
        this.interpolationSpeed = interpolationSpeed;
    }

    public InterpolatedValue(float defaultValue) {
        this(defaultValue, 0.05f);
    }

    public void set(float value) {
        this.previousValue = this.currentValue;
        this.currentValue = value;
    }

    public void set(double value) {
        this.previousValue = this.currentValue;
        this.currentValue = (float)value;
    }

    public void setDefaultValue(float value) {
        this.defaultValue = value;
    }

    public void setDefaultValue(double value) {
        this.defaultValue = (float)value;
    }

    public void setInterpolationSpeed(double value) {
        this.interpolationSpeed = (float)value;
    }

    public void interpolate(float value, float interpolationSpeed) {
        this.set(Float.isNaN(value) ? Mth.m_14179_((float)interpolationSpeed, (float)this.currentValue, (float)this.defaultValue) : Mth.m_14179_((float)interpolationSpeed, (float)this.currentValue, (float)value));
    }

    public void interpolate(double value, float interpolationSpeed) {
        this.set(Double.isNaN(value) ? (double)Mth.m_14179_((float)interpolationSpeed, (float)this.currentValue, (float)this.defaultValue) : Mth.m_14139_((double)interpolationSpeed, (double)this.currentValue, (double)value));
    }

    public void interpolate(float value) {
        this.interpolate(value, this.interpolationSpeed);
    }

    public void interpolate(double value) {
        this.interpolate(value, this.interpolationSpeed);
    }

    public void interpolate() {
        this.set(Mth.m_14179_((float)this.interpolationSpeed, (float)this.currentValue, (float)this.defaultValue));
    }

    public float get(float partialTick) {
        float lerp = Mth.m_14179_((float)partialTick, (float)this.previousValue, (float)this.currentValue);
        return lerp < 1.0E-4f ? 0.0f : lerp;
    }
}

