/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.api.helpers;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public final class CompoundNBTHelper {
    private static final int[] EMPTY_INT_ARRAY = new int[0];

    public static void set(CompoundTag compoundTag, String tag, Tag nbt) {
        compoundTag.m_128365_(tag, nbt);
    }

    public static void setBoolean(CompoundTag compoundTag, String tag, boolean b) {
        compoundTag.m_128379_(tag, b);
    }

    public static void setByte(CompoundTag compoundTag, String tag, byte b) {
        compoundTag.m_128344_(tag, b);
    }

    public static void setShort(CompoundTag compoundTag, String tag, short s) {
        compoundTag.m_128376_(tag, s);
    }

    public static void setInt(CompoundTag compoundTag, String tag, int i) {
        compoundTag.m_128405_(tag, i);
    }

    public static void setIntArray(CompoundTag compoundTag, String tag, int[] val) {
        compoundTag.m_128385_(tag, val);
    }

    public static void setIntArray(CompoundTag compoundTag, String tag, List<Integer> val) {
        compoundTag.m_128408_(tag, val);
    }

    public static void setLong(CompoundTag compoundTag, String tag, long l) {
        compoundTag.m_128356_(tag, l);
    }

    public static void setFloat(CompoundTag compoundTag, String tag, float f) {
        compoundTag.m_128350_(tag, f);
    }

    public static void setDouble(CompoundTag compoundTag, String tag, double d) {
        compoundTag.m_128347_(tag, d);
    }

    public static void setCompound(CompoundTag compoundTag, String tag, CompoundTag cmp) {
        if (!tag.equalsIgnoreCase("ench")) {
            compoundTag.m_128365_(tag, (Tag)cmp);
        }
    }

    public static void setString(CompoundTag compoundTag, String tag, String s) {
        compoundTag.m_128359_(tag, s);
    }

    public static void setUuid(CompoundTag compoundTag, String tag, UUID value) {
        compoundTag.m_128362_(tag, value);
    }

    public static void setList(CompoundTag compoundTag, String tag, ListTag list) {
        compoundTag.m_128365_(tag, (Tag)list);
    }

    public static void removeEntry(CompoundTag compoundTag, String tag) {
        compoundTag.m_128473_(tag);
    }

    public static boolean verifyExistance(CompoundTag compoundTag, String tag) {
        return compoundTag != null && compoundTag.m_128441_(tag);
    }

    @Nullable
    public static Tag get(CompoundTag compoundTag, String tag) {
        return CompoundNBTHelper.verifyExistance(compoundTag, tag) ? compoundTag.m_128423_(tag) : null;
    }

    public static boolean getBoolean(CompoundTag compoundTag, String tag, boolean defaultExpected) {
        return CompoundNBTHelper.verifyExistance(compoundTag, tag) ? compoundTag.m_128471_(tag) : defaultExpected;
    }

    public static byte getByte(CompoundTag compoundTag, String tag, byte defaultExpected) {
        return CompoundNBTHelper.verifyExistance(compoundTag, tag) ? compoundTag.m_128445_(tag) : defaultExpected;
    }

    public static short getShort(CompoundTag compoundTag, String tag, short defaultExpected) {
        return CompoundNBTHelper.verifyExistance(compoundTag, tag) ? compoundTag.m_128448_(tag) : defaultExpected;
    }

    public static int getInt(CompoundTag compoundTag, String tag, int defaultExpected) {
        return CompoundNBTHelper.verifyExistance(compoundTag, tag) ? compoundTag.m_128451_(tag) : defaultExpected;
    }

    public static int[] getIntArray(CompoundTag compoundTag, String tag) {
        return CompoundNBTHelper.verifyExistance(compoundTag, tag) ? compoundTag.m_128465_(tag) : EMPTY_INT_ARRAY;
    }

    public static long getLong(CompoundTag compoundTag, String tag, long defaultExpected) {
        return CompoundNBTHelper.verifyExistance(compoundTag, tag) ? compoundTag.m_128454_(tag) : defaultExpected;
    }

    public static float getFloat(CompoundTag compoundTag, String tag, float defaultExpected) {
        return CompoundNBTHelper.verifyExistance(compoundTag, tag) ? compoundTag.m_128457_(tag) : defaultExpected;
    }

    public static double getDouble(CompoundTag compoundTag, String tag, double defaultExpected) {
        return CompoundNBTHelper.verifyExistance(compoundTag, tag) ? compoundTag.m_128459_(tag) : defaultExpected;
    }

    public static CompoundTag getCompound(CompoundTag compoundTag, String tag, boolean nullifyOnFail) {
        return CompoundNBTHelper.verifyExistance(compoundTag, tag) ? compoundTag.m_128469_(tag) : (nullifyOnFail ? null : new CompoundTag());
    }

    public static String getString(CompoundTag compoundTag, String tag, String defaultExpected) {
        return CompoundNBTHelper.verifyExistance(compoundTag, tag) ? compoundTag.m_128461_(tag) : defaultExpected;
    }

    @Nullable
    public static UUID getUuid(CompoundTag compoundTag, String tag) {
        return CompoundNBTHelper.verifyExistance(compoundTag, tag + "Most") && CompoundNBTHelper.verifyExistance(compoundTag, tag + "Least") ? compoundTag.m_128342_(tag) : null;
    }

    public static ListTag getList(CompoundTag compoundTag, String tag, int objtype, boolean nullifyOnFail) {
        return CompoundNBTHelper.verifyExistance(compoundTag, tag) ? compoundTag.m_128437_(tag, objtype) : (nullifyOnFail ? null : new ListTag());
    }

    public static boolean matchTag(@Nullable Tag template, @Nullable Tag target) {
        if (template instanceof CompoundTag && target instanceof CompoundTag) {
            return CompoundNBTHelper.matchTagCompound((CompoundTag)template, (CompoundTag)target);
        }
        if (template instanceof ListTag && target instanceof ListTag) {
            return CompoundNBTHelper.matchTagList((ListTag)template, (ListTag)target);
        }
        return template == null || target != null && target.equals(template);
    }

    private static boolean matchTagCompound(CompoundTag template, CompoundTag target) {
        if (template.m_128440_() > target.m_128440_()) {
            return false;
        }
        for (String key : template.m_128431_()) {
            if (CompoundNBTHelper.matchTag(template.m_128423_(key), target.m_128423_(key))) continue;
            return false;
        }
        return true;
    }

    private static boolean matchTagList(ListTag template, ListTag target) {
        if (template.size() > target.size()) {
            return false;
        }
        for (int i = 0; i < template.size(); ++i) {
            if (CompoundNBTHelper.matchTag(template.get(i), target.get(i))) continue;
            return false;
        }
        return true;
    }

    public static void renameTag(CompoundTag nbt, String oldName, String newName) {
        Tag tag = nbt.m_128423_(oldName);
        if (tag != null) {
            nbt.m_128473_(oldName);
            nbt.m_128365_(newName, tag);
        }
    }

    public static CompoundTag getOrCreate(CompoundTag nbt, String key) {
        if (CompoundNBTHelper.verifyExistance(nbt, key)) {
            return nbt.m_128469_(key);
        }
        CompoundTag pValue = new CompoundTag();
        nbt.m_128365_(key, (Tag)pValue);
        return pValue;
    }
}

