/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.common.cap.entity;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import leaf.cosmere.api.CosmereAPI;
import leaf.cosmere.api.IHasMetalType;
import leaf.cosmere.api.ISpiritwebSubmodule;
import leaf.cosmere.api.Manifestations;
import leaf.cosmere.api.cosmereEffect.CosmereEffect;
import leaf.cosmere.api.cosmereEffect.CosmereEffectInstance;
import leaf.cosmere.api.manifestation.Manifestation;
import leaf.cosmere.api.spiritweb.ISpiritweb;
import leaf.cosmere.client.PowerSaveState;
import leaf.cosmere.common.Cosmere;
import leaf.cosmere.common.config.CosmereConfigs;
import leaf.cosmere.common.network.packets.SyncPlayerSpiritwebMessage;
import leaf.cosmere.common.registry.AttributesRegistry;
import leaf.cosmere.common.registry.GameEventRegistry;
import leaf.cosmere.common.registry.ManifestationRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class SpiritwebCapability
implements ISpiritweb {
    public static final Capability<ISpiritweb> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<ISpiritweb>(){});
    private boolean didSetup = false;
    private boolean hasBeenInitialized = false;
    private final LivingEntity livingEntity;
    public final Map<Manifestation, Integer> MANIFESTATIONS_MODE = new HashMap<Manifestation, Integer>();
    private Manifestation selectedManifestation = (Manifestation)ManifestationRegistry.NONE.get();
    public List<BlockPos> pushBlocks = new ArrayList<BlockPos>(4);
    public List<Integer> pushEntities = new ArrayList<Integer>(4);
    public List<BlockPos> pullBlocks = new ArrayList<BlockPos>(4);
    public List<Integer> pullEntities = new ArrayList<Integer>(4);
    public int pushPullWeight = 1;
    private CompoundTag nbt;
    private final Map<UUID, CosmereEffectInstance> activeEffects = Maps.newHashMap();
    private final Map<Manifestations.ManifestationTypes, ISpiritwebSubmodule> spiritwebSubmodules;
    private Map<Integer, Map<Manifestation, Integer>> powerSaveStorage;

    public SpiritwebCapability(LivingEntity ent) {
        this.livingEntity = ent;
        this.spiritwebSubmodules = Cosmere.makeSpiritwebSubmodules();
    }

    @Nonnull
    public static LazyOptional<ISpiritweb> get(LivingEntity entity) {
        return entity != null ? entity.getCapability(CAPABILITY, null) : LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        if (this.nbt == null) {
            this.nbt = new CompoundTag();
        }
        this.nbt.m_128379_("assigned_powers", this.hasBeenInitialized);
        this.nbt.m_128359_("selected_power", this.selectedManifestation.getRegistryName().toString());
        CompoundTag modeNBT = new CompoundTag();
        for (Object manifestation : CosmereAPI.manifestationRegistry()) {
            if (!this.MANIFESTATIONS_MODE.containsKey(manifestation)) continue;
            modeNBT.m_128405_(((Manifestation)manifestation).getRegistryName().toString(), this.MANIFESTATIONS_MODE.get(manifestation).intValue());
        }
        this.nbt.m_128365_("manifestation_modes", (Tag)modeNBT);
        if (this.activeEffects.isEmpty()) {
            this.nbt.m_128473_("ActiveEffects");
        } else {
            ListTag listtag = new ListTag();
            for (CosmereEffectInstance cosmereEffectInstance : this.activeEffects.values()) {
                listtag.add((Object)cosmereEffectInstance.save(new CompoundTag()));
            }
            this.nbt.m_128365_("ActiveEffects", (Tag)listtag);
        }
        for (ISpiritwebSubmodule spiritwebSubmodule : this.spiritwebSubmodules.values()) {
            spiritwebSubmodule.serialize(this);
        }
        this.nbt.m_128365_("PowerSaveStates", (Tag)PowerSaveState.serialize());
        return this.nbt;
    }

    public void deserializeNBT(CompoundTag compoundTag) {
        this.nbt = compoundTag;
        this.hasBeenInitialized = compoundTag.m_128471_("assigned_powers");
        CompoundTag modeNBT = compoundTag.m_128469_("manifestation_modes");
        for (Manifestation manifestation : CosmereAPI.manifestationRegistry()) {
            String manifestationLoc = manifestation.getRegistryName().toString();
            int oldManifestationMode = this.MANIFESTATIONS_MODE.getOrDefault(manifestation, 0);
            int newManifestationMode = 0;
            if (modeNBT.m_128441_(manifestationLoc)) {
                newManifestationMode = modeNBT.m_128451_(manifestationLoc);
                this.MANIFESTATIONS_MODE.put(manifestation, newManifestationMode);
            } else {
                this.MANIFESTATIONS_MODE.remove(manifestation);
            }
            if (!this.getLiving().m_9236_().f_46443_ || oldManifestationMode == newManifestationMode) continue;
            manifestation.onModeChange(this, oldManifestationMode);
        }
        this.selectedManifestation = ManifestationRegistry.fromID(compoundTag.m_128461_("selected_power"));
        if (compoundTag.m_128441_("ActiveEffects")) {
            ListTag listtag = (ListTag)compoundTag.m_128423_("ActiveEffects");
            for (int i = 0; i < listtag.size(); ++i) {
                CompoundTag compoundtag = listtag.m_128728_(i);
                CosmereEffectInstance cosmereEffectInstance = CosmereEffectInstance.load(compoundtag);
                if (cosmereEffectInstance == null) continue;
                this.activeEffects.put(cosmereEffectInstance.getUUID(), cosmereEffectInstance);
                this.onEffectUpdated(cosmereEffectInstance, true, null);
            }
        }
        for (ISpiritwebSubmodule spiritwebSubmodule : this.spiritwebSubmodules.values()) {
            spiritwebSubmodule.deserialize(this);
        }
        if (this.nbt.m_128441_("PowerSaveStates")) {
            PowerSaveState.deserialize((CompoundTag)this.nbt.m_128423_("PowerSaveStates"));
        }
    }

    @Override
    public CompoundTag getCompoundTag() {
        return this.nbt;
    }

    @Override
    public ISpiritwebSubmodule getSubmodule(Manifestations.ManifestationTypes manifestationType) {
        return this.spiritwebSubmodules.get((Object)manifestationType);
    }

    @Override
    public Map<Manifestations.ManifestationTypes, ISpiritwebSubmodule> getSubmodules() {
        return this.spiritwebSubmodules;
    }

    @Override
    public void tickEffects() {
        Iterator<UUID> iterator = this.activeEffects.keySet().iterator();
        try {
            while (iterator.hasNext()) {
                UUID uuidOfEffedInstance = iterator.next();
                CosmereEffectInstance cosmereEffectInstance = this.activeEffects.get(uuidOfEffedInstance);
                if (!cosmereEffectInstance.tick(this)) {
                    if (this.getLiving().m_9236_().f_46443_) continue;
                    iterator.remove();
                    this.onEffectRemoved(cosmereEffectInstance);
                    continue;
                }
                if (cosmereEffectInstance.getDuration() % 600 != 0) continue;
                this.onEffectUpdated(cosmereEffectInstance, false, null);
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    @Override
    public void addEffect(CosmereEffectInstance newEffect) {
        this.addEffect(newEffect, null);
    }

    @Override
    public void addEffect(CosmereEffectInstance newEffect, @Nullable Entity sourceEntity) {
        CosmereEffectInstance cosmereEffectInstance = this.activeEffects.get(newEffect.getUUID());
        if (cosmereEffectInstance != null) {
            this.removeEffect(cosmereEffectInstance.getUUID());
        }
        this.activeEffects.put(newEffect.getUUID(), newEffect);
        this.onEffectAdded(newEffect, sourceEntity);
    }

    @Override
    public void onEffectAdded(CosmereEffectInstance effectInstance, Entity sourceEntity) {
        if (!this.getLiving().m_9236_().f_46443_) {
            effectInstance.applyAttributeModifiers(this.getLiving(), this.getLiving().m_21204_());
        }
    }

    @Override
    public void onEffectUpdated(CosmereEffectInstance cosmereEffectInstance, boolean forced, Entity entity) {
        LivingEntity livingEntity = this.getLiving();
        if (forced && !livingEntity.m_9236_().f_46443_) {
            cosmereEffectInstance.removeAttributeModifiers(livingEntity.m_21204_());
            cosmereEffectInstance.applyAttributeModifiers(livingEntity, livingEntity.m_21204_());
        }
    }

    @Override
    public void removeEffect(UUID uuid) {
        if (!this.getLiving().m_9236_().f_46443_) {
            CosmereEffectInstance effectInstance = this.activeEffects.remove(uuid);
            this.onEffectRemoved(effectInstance);
        }
    }

    @Override
    public void onEffectRemoved(CosmereEffectInstance cosmereEffectInstance) {
        if (!this.getLiving().m_9236_().f_46443_ && cosmereEffectInstance != null) {
            cosmereEffectInstance.removeAttributeModifiers(this.getLiving().m_21204_());
        }
    }

    @Override
    public CosmereEffectInstance getEffect(UUID uuid) {
        return this.activeEffects.get(uuid);
    }

    @Override
    public boolean hasEffect(CosmereEffect effect) {
        List<CosmereEffectInstance> effectList = this.activeEffects.values().stream().filter(effectInstance -> effectInstance.getEffect().equals(effect)).toList();
        return !effectList.isEmpty();
    }

    @Override
    public Set<Map.Entry<UUID, CosmereEffectInstance>> getEffects() {
        return this.activeEffects.entrySet();
    }

    @Override
    public int totalStrengthOfEffect(CosmereEffect cosmereEffect) {
        return this.activeEffects.values().stream().filter(effectInstance -> effectInstance.getEffect() == cosmereEffect).mapToInt(o -> (int)o.getStrength()).sum();
    }

    @Override
    public void tick() {
        if (!this.livingEntity.m_9236_().f_46443_) {
            if (!this.didSetup) {
                this.syncToClients(null);
                this.didSetup = true;
            }
            LivingEntity spiritWebEntity = this.getLiving();
            if (this.selectedManifestation != ManifestationRegistry.NONE.get() && !this.hasManifestation(this.selectedManifestation)) {
                this.selectedManifestation = (Manifestation)ManifestationRegistry.NONE.get();
                if (spiritWebEntity instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)spiritWebEntity;
                    this.syncToClients(serverPlayer);
                }
            }
            boolean shouldTriggerSculkEvent = false;
            for (Manifestation manifestation : CosmereAPI.manifestationRegistry()) {
                if (!manifestation.isActive(this)) continue;
                shouldTriggerSculkEvent = manifestation.tick(this) || shouldTriggerSculkEvent;
            }
            if (shouldTriggerSculkEvent && spiritWebEntity.f_19797_ % 40 == 0 && ((Boolean)CosmereConfigs.SERVER_CONFIG.SCULK_CAN_HEAR_KINETIC_INVESTITURE.get()).booleanValue()) {
                AttributeMap targetAttributes = spiritWebEntity.m_21204_();
                double concealmentStrength = 0.0;
                Attribute cognitiveConcealmentAttr = (Attribute)AttributesRegistry.COGNITIVE_CONCEALMENT.get();
                if (targetAttributes.m_22171_(cognitiveConcealmentAttr)) {
                    concealmentStrength = targetAttributes.m_22181_(cognitiveConcealmentAttr);
                }
                if (concealmentStrength < 2.0) {
                    spiritWebEntity.m_146850_((GameEvent)GameEventRegistry.KINETIC_INVESTITURE.get());
                }
            }
            for (ISpiritwebSubmodule spiritwebSubmodule : this.spiritwebSubmodules.values()) {
                spiritwebSubmodule.tickServer(this);
            }
            this.tickEffects();
        } else {
            for (ISpiritwebSubmodule spiritwebSubmodule : this.spiritwebSubmodules.values()) {
                spiritwebSubmodule.tickClient(this);
            }
        }
    }

    @Override
    public LivingEntity getLiving() {
        return this.livingEntity;
    }

    @Override
    public void onPlayerClone(PlayerEvent.Clone event, ISpiritweb oldSpiritWeb) {
        SpiritwebCapability oldWeb = (SpiritwebCapability)oldSpiritWeb;
        AttributeMap oldAttMap = oldWeb.getLiving().m_21204_();
        AttributeMap newAttMap = this.getLiving().m_21204_();
        for (Manifestation manifestation : CosmereAPI.manifestationRegistry()) {
            Attribute attribute = manifestation.getAttribute();
            if (attribute == null) continue;
            AttributeInstance oldAttr = oldAttMap.m_22146_(attribute);
            AttributeInstance newAttr = newAttMap.m_22146_(attribute);
            if (newAttr == null || oldAttr == null) continue;
            newAttr.m_22113_(oldAttr.m_22136_());
        }
        this.deserializeNBT(oldWeb.serializeNBT().m_6426_());
        if (event.isWasDeath()) {
            for (ISpiritwebSubmodule spiritwebSubmodule : this.spiritwebSubmodules.values()) {
                spiritwebSubmodule.resetOnDeath(this);
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderWorldEffects(RenderLevelStageEvent event) {
        ProfilerFiller profiler = Minecraft.m_91087_().m_91307_();
        for (Map.Entry<Manifestations.ManifestationTypes, ISpiritwebSubmodule> set : this.spiritwebSubmodules.entrySet()) {
            boolean isDebugModule;
            ISpiritwebSubmodule spiritwebSubmodule = set.getValue();
            boolean bl = isDebugModule = set.getKey() == null;
            if (!isDebugModule) {
                profiler.m_6180_(set.getKey().getName());
            }
            spiritwebSubmodule.renderWorldEffects(this, event);
            if (isDebugModule) continue;
            profiler.m_7238_();
        }
    }

    public void renderSelectedHUD(GuiGraphics gg) {
        if (((Boolean)CosmereConfigs.CLIENT_CONFIG.disableSelectedManifestationHud.get()).booleanValue() || this.selectedManifestation.getManifestationType() == Manifestations.ManifestationTypes.NONE) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        int startX = (Integer)CosmereConfigs.CLIENT_CONFIG.hudXCoordinate.get();
        int startY = (Integer)CosmereConfigs.CLIENT_CONFIG.hudYCoordinate.get();
        int size = (Integer)CosmereConfigs.CLIENT_CONFIG.hudSize.get();
        String stringToDraw = I18n.m_118938_((String)this.selectedManifestation.getTextComponent().getString(), (Object[])new Object[0]);
        int xOffset = -5;
        float textScale = (float)size / (float)(mc.f_91062_.m_92895_(stringToDraw) - 20);
        gg.m_280168_().m_85836_();
        gg.m_280168_().m_85841_(textScale, textScale, 1.0f);
        gg.m_280488_(mc.f_91062_, stringToDraw, (int)((float)(startX + xOffset) / textScale), (int)((float)(startY + size + 5) / textScale), 0xFFFFFF);
        gg.m_280168_().m_85849_();
        int mode = this.getMode(this.selectedManifestation);
        Object stringToDraw2 = "";
        gg.m_280168_().m_85836_();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        try {
            ResourceLocation textureLocation = new ResourceLocation(this.selectedManifestation.getRegistryName().m_135827_(), "textures/gui/hud_background.png");
            mc.m_91098_().m_215593_(textureLocation);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)textureLocation);
            gg.m_280411_(textureLocation, startX, startY, size, size, 0.0f, 0.0f, 18, 18, 18, 18);
        }
        catch (FileNotFoundException ex) {
            RenderSystem.setShader(GameRenderer::m_172811_);
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            int color = -872415232;
            buffer.m_5483_((double)startX, (double)startY, 0.0).m_193479_(color).m_5752_();
            buffer.m_5483_((double)startX, (double)(startY + size), 0.0).m_193479_(color).m_5752_();
            buffer.m_5483_((double)(startX + size), (double)(startY + size), 0.0).m_193479_(color).m_5752_();
            buffer.m_5483_((double)(startX + size), (double)startY, 0.0).m_193479_(color).m_5752_();
            tesselator.m_85914_();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.setLength(0);
        String manifestationTypeName = this.selectedManifestation.getManifestationType().getName();
        stringBuilder.append("textures/icon/").append(manifestationTypeName).append("/");
        switch (this.selectedManifestation.getManifestationType()) {
            case ALLOMANCY: 
            case FERUCHEMY: {
                Manifestation manifestation = this.selectedManifestation;
                if (!(manifestation instanceof IHasMetalType)) break;
                IHasMetalType metalType = (IHasMetalType)((Object)manifestation);
                stringBuilder.append(metalType.getMetalType().m_6082_());
                break;
            }
            case SURGEBINDING: {
                stringBuilder.append(this.selectedManifestation.getName());
                break;
            }
            case AON_DOR: {
                break;
            }
        }
        stringBuilder.append(".png");
        ResourceLocation textureLocation = new ResourceLocation(this.selectedManifestation.getRegistryName().m_135827_(), stringBuilder.toString());
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)textureLocation);
        int posX = startX + 4;
        int posY = startY + 2;
        if (this.selectedManifestation.getManifestationType() != Manifestations.ManifestationTypes.ALLOMANCY && this.selectedManifestation.getManifestationType() != Manifestations.ManifestationTypes.FERUCHEMY) {
            posX = startX + 2;
        }
        gg.m_280411_(textureLocation, posX, posY, size - 4, size - 4, 0.0f, 0.0f, 18, 18, 18, 18);
        gg.m_280168_().m_85849_();
        RenderSystem.disableBlend();
        if (this.selectedManifestation.getManifestationType() == Manifestations.ManifestationTypes.FERUCHEMY) {
            if (mode < 0) {
                stringToDraw2 = "T" + mode;
            } else if (mode > 0) {
                stringToDraw2 = "S" + mode;
            }
        } else if (this.selectedManifestation.getManifestationType() == Manifestations.ManifestationTypes.ALLOMANCY) {
            stringToDraw2 = switch (mode) {
                case -2 -> "CF";
                case -1 -> "C";
                default -> "";
                case 1 -> "B";
                case 2, 3 -> "F";
            };
        }
        if (!((String)stringToDraw2).isEmpty()) {
            int n = size / 2;
            int n2 = ((String)stringToDraw2).length();
            Objects.requireNonNull(mc.f_91062_);
            int yOffset = n - n2 * 9 / 2;
            for (char c : ((String)stringToDraw2).toCharArray()) {
                if (c == '-') {
                    c = '|';
                }
                xOffset = mc.f_91062_.m_92895_(String.valueOf(c)) / 2 - 4;
                gg.m_280488_(mc.f_91062_, String.valueOf(c), startX - xOffset, startY + yOffset, 0xFFFFFF);
                Objects.requireNonNull(mc.f_91062_);
                yOffset += 9;
            }
        }
    }

    static float[][] calculatePentagonVertices(float centerX, float centerY, float radius, float scaleY) {
        float[][] vertices = new float[5][2];
        for (int i = 0; i < 5; ++i) {
            double angle = Math.PI * 2 * ((double)i / 5.0);
            vertices[i][0] = centerX + (float)((double)radius * Math.cos(angle));
            vertices[i][1] = centerY + (float)((double)radius * Math.sin(angle));
        }
        return vertices;
    }

    @Override
    public void setSelectedManifestation(Manifestation manifestation) {
        this.selectedManifestation = manifestation;
    }

    @Override
    public Manifestation getSelectedManifestation() {
        return this.selectedManifestation;
    }

    public boolean hasBeenInitialized() {
        return this.hasBeenInitialized;
    }

    public void setHasBeenInitialized() {
        this.hasBeenInitialized = true;
    }

    public void setHasNotBeenInitialized() {
        this.hasBeenInitialized = false;
    }

    public boolean hasAnyPowers() {
        for (Manifestation manifestation : CosmereAPI.manifestationRegistry()) {
            AttributeInstance manifestationAttribute;
            Attribute attribute = manifestation.getAttribute();
            if (attribute == null || (manifestationAttribute = this.livingEntity.m_21051_(attribute)) == null || !(manifestationAttribute.m_22135_() > 5.0)) continue;
            this.setHasBeenInitialized();
            return true;
        }
        return false;
    }

    @Override
    public boolean hasManifestation(Manifestation manifestation) {
        return this.hasManifestation(manifestation, false);
    }

    @Override
    public boolean hasManifestation(Manifestation manifestation, boolean ignoreTemporaryPower) {
        Attribute attribute = manifestation.getAttribute();
        if (attribute == null) {
            return false;
        }
        AttributeMap attributeManager = this.livingEntity.m_21204_();
        if (attributeManager.m_22171_(attribute)) {
            double manifestationStrength = ignoreTemporaryPower ? attributeManager.m_22185_(attribute) : attributeManager.m_22181_(attribute);
            return manifestationStrength >= 1.0;
        }
        return false;
    }

    @Override
    public void giveManifestation(Manifestation manifestation, int baseValue) {
        Attribute attribute = manifestation.getAttribute();
        if (attribute == null) {
            return;
        }
        AttributeInstance manifestationAttribute = this.livingEntity.m_21051_(attribute);
        if (manifestationAttribute != null) {
            manifestationAttribute.m_22100_((double)baseValue);
        }
        this.hasBeenInitialized = true;
    }

    @Override
    public void removeManifestation(Manifestation manifestation) {
        Attribute attribute = manifestation.getAttribute();
        if (attribute == null) {
            return;
        }
        AttributeInstance manifestationAttribute = this.livingEntity.m_21051_(attribute);
        if (manifestationAttribute != null) {
            manifestationAttribute.m_22100_(0.0);
        }
    }

    @Override
    public boolean canTickManifestation(Manifestation manifestation) {
        if (!this.hasManifestation(manifestation)) {
            return false;
        }
        if (this.MANIFESTATIONS_MODE.containsKey(manifestation)) {
            return this.MANIFESTATIONS_MODE.get(manifestation) != 0;
        }
        return false;
    }

    @Override
    public void deactivateCurrentManifestation() {
        this.MANIFESTATIONS_MODE.remove(this.selectedManifestation);
    }

    @Override
    public void deactivateManifestations() {
        this.MANIFESTATIONS_MODE.clear();
    }

    @Override
    public void clearManifestations() {
        this.deactivateManifestations();
        for (Manifestation manifestation : CosmereAPI.manifestationRegistry()) {
            this.removeManifestation(manifestation);
        }
    }

    @Override
    public List<Manifestation> getAvailableManifestations() {
        return this.getAvailableManifestations(false);
    }

    @Override
    public List<Manifestation> getAvailableManifestations(boolean ignoreTemporaryPower) {
        ArrayList<Manifestation> list = new ArrayList<Manifestation>();
        for (Manifestation manifestation : CosmereAPI.manifestationRegistry()) {
            if (manifestation == ManifestationRegistry.NONE.getManifestation() || !this.hasManifestation(manifestation, ignoreTemporaryPower)) continue;
            list.add(manifestation);
        }
        return list;
    }

    @Override
    public HashMap<Manifestation, Integer> getManifestations() {
        return this.getManifestations(false, false);
    }

    @Override
    public HashMap<Manifestation, Integer> getManifestations(boolean ignoreTemporaryPower, boolean ignoreInactivePower) {
        HashMap<Manifestation, Integer> list = new HashMap<Manifestation, Integer>();
        for (Manifestation manifestation : CosmereAPI.manifestationRegistry()) {
            if (manifestation == ManifestationRegistry.NONE.getManifestation() || !this.hasManifestation(manifestation, ignoreTemporaryPower)) continue;
            if (!ignoreInactivePower) {
                list.put(manifestation, this.MANIFESTATIONS_MODE.get(manifestation));
                continue;
            }
            if (this.MANIFESTATIONS_MODE.get(manifestation) == null || this.MANIFESTATIONS_MODE.get(manifestation) == 0) continue;
            list.put(manifestation, this.MANIFESTATIONS_MODE.get(manifestation));
        }
        return list;
    }

    @Override
    public String changeManifestation(int dir) {
        List<Manifestation> unlockedManifestations = this.getAvailableManifestations();
        if (this.selectedManifestation == ManifestationRegistry.NONE.get()) {
            this.selectedManifestation = unlockedManifestations.get(0);
        } else {
            for (int index = 0; index < unlockedManifestations.size(); ++index) {
                Manifestation manifestation = unlockedManifestations.get(index);
                if (this.selectedManifestation != manifestation) continue;
                int selection = index;
                selection += dir < 0 ? 1 : -1;
                selection = (selection + unlockedManifestations.size()) % unlockedManifestations.size();
                this.selectedManifestation = unlockedManifestations.get(selection);
                break;
            }
        }
        return this.selectedManifestation.getTranslationKey();
    }

    @Override
    public void setMode(Manifestation manifestation, int mode) {
        int pMax = manifestation.modeMax(this);
        int pMin = manifestation.modeMin(this);
        mode = Mth.m_14045_((int)mode, (int)pMin, (int)pMax);
        int lastMode = this.MANIFESTATIONS_MODE.put(manifestation, mode);
        manifestation.onModeChange(this, lastMode);
    }

    @Override
    public int getMode(Manifestation manifestation) {
        if (manifestation != null) {
            return this.MANIFESTATIONS_MODE.getOrDefault(manifestation, 0);
        }
        return 0;
    }

    @Override
    public int nextMode(Manifestation aim) {
        int currentMode = this.getMode(aim);
        if (aim.modeWraps(this) && currentMode == aim.modeMax(this)) {
            int modeMin = aim.modeMin(this);
            this.setMode(aim, modeMin);
            return modeMin;
        }
        int mode = Math.min(currentMode + 1, aim.modeMax(this));
        this.setMode(aim, mode);
        return mode;
    }

    @Override
    public int previousMode(Manifestation aim) {
        int currentMode = this.getMode(aim);
        if (aim.modeWraps(this) && currentMode == aim.modeMin(this)) {
            int modeMax = aim.modeMax(this);
            this.setMode(aim, modeMax);
            return modeMax;
        }
        int mode = Math.max(currentMode - 1, aim.modeMin(this));
        this.setMode(aim, mode);
        return mode;
    }

    @Override
    public void syncToClients(@Nullable ServerPlayer serverPlayerEntity) {
        if (this.livingEntity != null && this.livingEntity.m_9236_().f_46443_) {
            throw new IllegalStateException("Don't sync client -> server");
        }
        if (this.getSelectedManifestation() == ManifestationRegistry.NONE.get()) {
            Optional first = this.getAvailableManifestations().stream().findFirst();
            first.ifPresent(this::setSelectedManifestation);
        }
        CompoundTag nbt = this.serializeNBT();
        if (serverPlayerEntity == null) {
            Cosmere.packetHandler().sendToAllInWorld(new SyncPlayerSpiritwebMessage(this.livingEntity.m_19879_(), nbt), (ServerLevel)this.livingEntity.m_9236_());
        } else {
            Cosmere.packetHandler().sendTo(new SyncPlayerSpiritwebMessage(this.livingEntity.m_19879_(), nbt), serverPlayerEntity);
        }
    }
}

