/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.common.charge;

import java.util.Optional;
import java.util.UUID;
import leaf.cosmere.api.Constants;
import leaf.cosmere.api.IHasMetalType;
import leaf.cosmere.api.Manifestations;
import leaf.cosmere.api.Metals;
import leaf.cosmere.api.helpers.StackNBTHelper;
import leaf.cosmere.api.spiritweb.ISpiritweb;
import leaf.cosmere.common.cap.entity.SpiritwebCapability;
import leaf.cosmere.common.config.CosmereConfigs;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

public interface IChargeable {
    default public int getMaxCharge(ItemStack itemStack) {
        int maxCharge = (Integer)CosmereConfigs.SERVER_CONFIG.CHARGEABLE_MAX_VALUE.get();
        return Mth.m_14143_((float)((float)maxCharge * this.getMaxChargeModifier())) * itemStack.m_41613_();
    }

    default public float getMaxChargeModifier() {
        return 1.0f;
    }

    default public int getCharge(ItemStack itemStack) {
        return StackNBTHelper.getInt(itemStack, "charge_level", 0) * itemStack.m_41613_();
    }

    default public void setCharge(ItemStack itemStack, int chargeLevel) {
        StackNBTHelper.setInt(itemStack, "charge_level", Mth.m_14045_((int)chargeLevel, (int)0, (int)this.getMaxCharge(itemStack)));
        if (chargeLevel == 0 && this.getAttunedPlayer(itemStack) != null) {
            StackNBTHelper.removeEntry(itemStack, "attuned_player");
            StackNBTHelper.removeEntry(itemStack, "attuned_player_name");
        }
    }

    default public boolean trySetAttunedPlayer(ItemStack itemStack, Player entity) {
        Item item = itemStack.m_41720_();
        if (item instanceof IHasMetalType) {
            boolean noAttunedPlayer;
            IHasMetalType metalType = (IHasMetalType)item;
            UUID attunedPlayerID = this.getAttunedPlayer(itemStack);
            UUID playerID = entity.m_20148_();
            boolean bl = noAttunedPlayer = attunedPlayerID == null;
            if (noAttunedPlayer && metalType.getMetalType() != Metals.MetalType.ALUMINUM) {
                boolean isStoringIdentity = false;
                Optional data = SpiritwebCapability.get((LivingEntity)entity).filter(obj -> true);
                if (data.isPresent()) {
                    boolean bl2 = isStoringIdentity = Manifestations.ManifestationTypes.FERUCHEMY.getManifestation(Metals.MetalType.ALUMINUM.getID()).getMode((ISpiritweb)data.get()) > 0;
                }
                if (isStoringIdentity) {
                    StackNBTHelper.setUuid(itemStack, "attuned_player", Constants.NBT.UNKEYED_UUID);
                    StackNBTHelper.setString(itemStack, "attuned_player_name", "Unkeyed");
                    return true;
                }
            }
            if (noAttunedPlayer || attunedPlayerID.compareTo(playerID) == 0 || attunedPlayerID.compareTo(Constants.NBT.UNKEYED_UUID) == 0) {
                if (noAttunedPlayer && this.getCharge(itemStack) > 0) {
                    this.setAttunedPlayer(itemStack, entity);
                    this.setAttunedPlayerName(itemStack, entity);
                }
                return true;
            }
        }
        return false;
    }

    default public void setAttunedPlayer(ItemStack itemStack, Player entity) {
        StackNBTHelper.setUuid(itemStack, "attuned_player", entity.m_20148_());
    }

    default public UUID getAttunedPlayer(ItemStack itemStack) {
        return StackNBTHelper.getUuid(itemStack, "attuned_player");
    }

    default public void setAttunedPlayerName(ItemStack itemStack, Player entity) {
        String playerName = entity.m_5446_().getString();
        StackNBTHelper.setString(itemStack, "attuned_player_name", playerName);
    }

    default public String getAttunedPlayerName(ItemStack itemStack) {
        return StackNBTHelper.getString(itemStack, "attuned_player_name", "");
    }

    default public boolean getPlayerIsAttuned(ItemStack itemStack, Player entity) {
        MobEffect aluminumStoreEffect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation("feruchemy", "storing_" + Metals.MetalType.ALUMINUM.m_6082_()));
        if (!1.$assertionsDisabled && aluminumStoreEffect == null) {
            throw new AssertionError();
        }
        MobEffectInstance storingIdentityEffect = entity.m_21124_(aluminumStoreEffect);
        boolean noIdentityPlayer = storingIdentityEffect != null && storingIdentityEffect.m_19557_() > 0;
        UUID itemAttunedPlayerUUID = this.getAttunedPlayer(itemStack);
        return noIdentityPlayer || itemAttunedPlayerUUID == null || itemAttunedPlayerUUID == entity.m_20148_();
    }

    default public void adjustCharge(ItemStack stack, int chargeToAdjustBy) {
        int currentCharge = this.getCharge(stack);
        int goalCharge = currentCharge + chargeToAdjustBy;
        int actualGoalCharge = Math.min(goalCharge, this.getMaxCharge(stack));
        int finalChargeValue = actualGoalCharge / stack.m_41613_();
        this.setCharge(stack, finalChargeValue);
    }

    default public void increaseCurrentCharge(ItemStack itemStack) {
        this.increaseCurrentCharge(itemStack, 1);
    }

    default public void increaseCurrentCharge(ItemStack stack, int i) {
        this.setCharge(stack, this.getCharge(stack) + i);
    }

    default public void decreaseCurrentCharge(ItemStack itemStack) {
        int currentCharge = this.getCharge(itemStack);
        int nextChargeLevel = currentCharge - 1;
        this.setCharge(itemStack, nextChargeLevel);
    }

    default public boolean canGiveChargeToItem(ItemStack stackInSlot, ItemStack stack) {
        return true;
    }

    default public boolean canReceiveChargeFromItem(ItemStack stack, ItemStack stackInSlot) {
        return true;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

