/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.common.charge;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import leaf.cosmere.api.Constants;
import leaf.cosmere.api.Manifestations;
import leaf.cosmere.api.Metals;
import leaf.cosmere.api.spiritweb.ISpiritweb;
import leaf.cosmere.common.cap.entity.SpiritwebCapability;
import leaf.cosmere.common.charge.IChargeable;
import leaf.cosmere.common.compat.curios.CuriosCompat;
import leaf.cosmere.common.items.CapWrapper;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.PlayerInvWrapper;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public class ItemChargeHelper {
    public static List<ItemStack> getChargeItems(Player player) {
        if (player == null) {
            return Collections.emptyList();
        }
        CapWrapper acc = new CapWrapper((IItemHandler)new PlayerInvWrapper(player.m_150109_()));
        List<ItemStack> toReturn = ItemChargeHelper.getChargeableItemStacks(acc);
        return toReturn;
    }

    public static List<ItemStack> getChargeCurios(Player player) {
        if (player == null || !CuriosCompat.CuriosIsPresent()) {
            return Collections.emptyList();
        }
        LazyOptional curiosItemHandler = CuriosApi.getCuriosInventory((LivingEntity)player);
        CapWrapper acc = null;
        if (curiosItemHandler.resolve().isPresent()) {
            acc = new CapWrapper((IItemHandler)((ICuriosItemHandler)curiosItemHandler.resolve().get()).getEquippedCurios());
        }
        ArrayList<ItemStack> toReturn = acc != null ? ItemChargeHelper.getChargeableItemStacks(acc) : new ArrayList<ItemStack>();
        return toReturn;
    }

    private static List<ItemStack> getChargeableItemStacks(Container acc) {
        ArrayList<ItemStack> toReturn = new ArrayList<ItemStack>(acc.m_6643_());
        for (int slot = 0; slot < acc.m_6643_(); ++slot) {
            ItemStack stackInSlot = acc.m_8020_(slot);
            if (stackInSlot.m_41619_() || !(stackInSlot.m_41720_() instanceof IChargeable)) continue;
            toReturn.add(stackInSlot);
        }
        return toReturn;
    }

    public static int requestCharge(ItemStack stack, Player player, int chargeToGet, boolean remove) {
        return ItemChargeHelper.requestCharge(stack, player, chargeToGet, remove, false);
    }

    public static int requestCharge(ItemStack stack, Player player, int chargeToGet, boolean remove, boolean checkPlayerID) {
        if (stack.m_41619_()) {
            return 0;
        }
        List<ItemStack> items = ItemChargeHelper.getChargeItems(player);
        List<ItemStack> acc = ItemChargeHelper.getChargeCurios(player);
        for (ItemStack stackInSlot : Iterables.concat(items, acc)) {
            IChargeable chargeItem;
            if (stackInSlot == stack || !(chargeItem = (IChargeable)stackInSlot.m_41720_()).canGiveChargeToItem(stackInSlot, stack) || chargeItem.getCharge(stackInSlot) <= 0 || stack.m_41720_() instanceof IChargeable && !((IChargeable)stack.m_41720_()).canReceiveChargeFromItem(stack, stackInSlot) || checkPlayerID && !chargeItem.getPlayerIsAttuned(stackInSlot, player)) continue;
            int charge = Math.min(chargeToGet, chargeItem.getCharge(stackInSlot));
            if (remove) {
                chargeItem.adjustCharge(stackInSlot, -charge);
            }
            return charge;
        }
        return 0;
    }

    public static ItemStack adjustChargeExact(Player player, int chargeToGet, boolean remove) {
        return ItemChargeHelper.adjustChargeExact(player, chargeToGet, remove, false);
    }

    public static ItemStack adjustChargeExact(Player player, int chargeToGet, boolean remove, boolean checkPlayer) {
        List<ItemStack> items = ItemChargeHelper.getChargeItems(player);
        List<ItemStack> acc = ItemChargeHelper.getChargeCurios(player);
        return ItemChargeHelper.adjustChargeExact(player, chargeToGet, remove, checkPlayer, items, acc);
    }

    public static ItemStack adjustChargeExact(Player player, int adjustValue, boolean doAdjust, boolean checkPlayer, List<ItemStack> items, List<ItemStack> acc) {
        boolean isStoringIdentity = false;
        Optional data = SpiritwebCapability.get((LivingEntity)player).filter(obj -> true);
        if (data.isPresent()) {
            isStoringIdentity = Manifestations.ManifestationTypes.FERUCHEMY.getManifestation(Metals.MetalType.ALUMINUM.getID()).getMode((ISpiritweb)data.get()) > 0;
        }
        for (ItemStack stackInSlot : Iterables.concat(items, acc)) {
            IChargeable chargeItemSlot = (IChargeable)stackInSlot.m_41720_();
            boolean storing = adjustValue > 0;
            int slotCharge = chargeItemSlot.getCharge(stackInSlot);
            int slotMaxCharge = chargeItemSlot.getMaxCharge(stackInSlot);
            if (!storing && slotCharge <= 0 || storing && slotCharge >= slotMaxCharge) continue;
            boolean playerUnableToAccess = !chargeItemSlot.trySetAttunedPlayer(stackInSlot, player);
            UUID attunedPlayer = chargeItemSlot.getAttunedPlayer(stackInSlot);
            if (checkPlayer && playerUnableToAccess || storing && !isStoringIdentity && attunedPlayer != null && attunedPlayer.compareTo(Constants.NBT.UNKEYED_UUID) == 0 || (!storing || slotCharge + adjustValue > slotMaxCharge) && (storing || slotCharge < -adjustValue)) continue;
            if (doAdjust) {
                chargeItemSlot.adjustCharge(stackInSlot, adjustValue);
            }
            return stackInSlot;
        }
        return ItemStack.f_41583_;
    }

    public static boolean requestChargeExact(ItemStack stack, Player player, int chargeToGet, boolean remove) {
        if (stack.m_41619_()) {
            return false;
        }
        List<ItemStack> items = ItemChargeHelper.getChargeItems(player);
        List<ItemStack> acc = ItemChargeHelper.getChargeCurios(player);
        for (ItemStack stackInSlot : Iterables.concat(items, acc)) {
            IChargeable chargeItemSlot;
            if (stackInSlot == stack || !(chargeItemSlot = (IChargeable)stackInSlot.m_41720_()).canGiveChargeToItem(stackInSlot, stack) || chargeItemSlot.getCharge(stackInSlot) <= chargeToGet || stack.m_41720_() instanceof IChargeable && !((IChargeable)stack.m_41720_()).canReceiveChargeFromItem(stack, stackInSlot)) continue;
            if (remove) {
                chargeItemSlot.adjustCharge(stackInSlot, -chargeToGet);
            }
            return true;
        }
        return false;
    }

    public static int dispatchCharge(Player player, int chargeToSend, boolean add) {
        List<ItemStack> acc;
        List<ItemStack> items = ItemChargeHelper.getChargeItems(player);
        Iterable itemStacksIterable = Iterables.concat(items, acc = ItemChargeHelper.getChargeCurios(player));
        Iterator iterator = itemStacksIterable.iterator();
        if (iterator.hasNext()) {
            ItemStack stackInSlot = (ItemStack)iterator.next();
            IChargeable chargeItemSlot = (IChargeable)stackInSlot.m_41720_();
            int received = chargeItemSlot.getCharge(stackInSlot) + chargeToSend <= chargeItemSlot.getMaxCharge(stackInSlot) ? chargeToSend : chargeToSend - (chargeItemSlot.getCharge(stackInSlot) + chargeToSend - chargeItemSlot.getMaxCharge(stackInSlot));
            if (add) {
                chargeItemSlot.adjustCharge(stackInSlot, chargeToSend);
            }
            return received;
        }
        return 0;
    }

    public static int dispatchCharge(ItemStack stack, Player player, int chargeToSend, boolean add) {
        if (stack.m_41619_()) {
            return 0;
        }
        List<ItemStack> items = ItemChargeHelper.getChargeItems(player);
        List<ItemStack> acc = ItemChargeHelper.getChargeCurios(player);
        for (ItemStack stackInSlot : Iterables.concat(items, acc)) {
            IChargeable chargeItemSlot;
            if (stackInSlot == stack || !(chargeItemSlot = (IChargeable)stackInSlot.m_41720_()).canReceiveChargeFromItem(stackInSlot, stack) || stack.m_41720_() instanceof IChargeable && !((IChargeable)stack.m_41720_()).canGiveChargeToItem(stack, stackInSlot)) continue;
            int received = chargeItemSlot.getCharge(stackInSlot) + chargeToSend <= chargeItemSlot.getMaxCharge(stackInSlot) ? chargeToSend : chargeToSend - (chargeItemSlot.getCharge(stackInSlot) + chargeToSend - chargeItemSlot.getMaxCharge(stackInSlot));
            if (add) {
                chargeItemSlot.adjustCharge(stackInSlot, chargeToSend);
            }
            return received;
        }
        return 0;
    }

    public static boolean dispatchChargeExact(ItemStack stack, Player player, int chargeToSend, boolean add) {
        if (stack.m_41619_()) {
            return false;
        }
        List<ItemStack> items = ItemChargeHelper.getChargeItems(player);
        List<ItemStack> acc = ItemChargeHelper.getChargeCurios(player);
        for (ItemStack stackInSlot : Iterables.concat(items, acc)) {
            IChargeable chargeItemSlot;
            if (stackInSlot == stack || (chargeItemSlot = (IChargeable)stackInSlot.m_41720_()).getCharge(stackInSlot) + chargeToSend > chargeItemSlot.getMaxCharge(stackInSlot) || !chargeItemSlot.canReceiveChargeFromItem(stackInSlot, stack) || stack.m_41720_() instanceof IChargeable && !((IChargeable)stack.m_41720_()).canGiveChargeToItem(stack, stackInSlot)) continue;
            if (add) {
                chargeItemSlot.adjustCharge(stackInSlot, chargeToSend);
            }
            return true;
        }
        return false;
    }

    private static int discountChargeForTool(ItemStack stack, Player player, int inCost) {
        float multiplier = Math.max(0.0f, 1.0f - ItemChargeHelper.getFullDiscountForTools(player, stack));
        return (int)((float)inCost * multiplier);
    }

    public static int requestChargeForTool(ItemStack stack, Player player, int chargeToGet, boolean remove) {
        int cost = ItemChargeHelper.discountChargeForTool(stack, player, chargeToGet);
        return ItemChargeHelper.requestCharge(stack, player, cost, remove);
    }

    public static boolean requestChargeExactForTool(ItemStack stack, Player player, int chargeToGet, boolean remove) {
        int cost = ItemChargeHelper.discountChargeForTool(stack, player, chargeToGet);
        return ItemChargeHelper.requestChargeExact(stack, player, cost, remove);
    }

    public static int getInvocationCountForTool(ItemStack stack, Player player, int chargeToGet) {
        if (stack.m_41619_()) {
            return 0;
        }
        int cost = ItemChargeHelper.discountChargeForTool(stack, player, chargeToGet);
        int invocations = 0;
        List<ItemStack> items = ItemChargeHelper.getChargeItems(player);
        List<ItemStack> acc = ItemChargeHelper.getChargeCurios(player);
        for (ItemStack stackInSlot : Iterables.concat(items, acc)) {
            if (stackInSlot == stack) continue;
            IChargeable chargeItemSlot = (IChargeable)stackInSlot.m_41720_();
            int availableCharge = chargeItemSlot.getCharge(stackInSlot);
            if (!chargeItemSlot.canGiveChargeToItem(stackInSlot, stack) || availableCharge <= cost || stack.m_41720_() instanceof IChargeable && !((IChargeable)stack.m_41720_()).canReceiveChargeFromItem(stack, stackInSlot)) continue;
            invocations += availableCharge / cost;
        }
        return invocations;
    }

    public static float getFullDiscountForTools(Player player, ItemStack tool) {
        float discount = 0.0f;
        return discount;
    }
}

