/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.common.commands.arguments;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import leaf.cosmere.api.CosmereAPI;
import leaf.cosmere.api.Manifestations;
import leaf.cosmere.api.Metals;
import leaf.cosmere.api.manifestation.Manifestation;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class FeruchemyArgumentType
implements ArgumentType<Manifestation> {
    private static final Collection<String> EXAMPLES = Stream.of("feruchemy:" + Metals.MetalType.IRON.m_6082_()).toList();
    public static final DynamicCommandExceptionType INVALID_MANIFESTATION_EXCEPTION = new DynamicCommandExceptionType(manifestation -> Component.m_237110_((String)"argument.cosmere.power.invalid", (Object[])new Object[]{manifestation}));

    public static SuggestionsBuilder addFeruchemyNamesWithTooltip(SuggestionsBuilder builder) {
        for (Manifestation manifestation : CosmereAPI.manifestationRegistry()) {
            if (!manifestation.getManifestationType().equals((Object)Manifestations.ManifestationTypes.FERUCHEMY) && !manifestation.getName().equals("none")) continue;
            builder.suggest(manifestation.getRegistryName().toString(), (Message)Component.m_237115_((String)manifestation.getTranslationKey()).m_130938_(style -> style.m_131140_(ChatFormatting.GREEN)));
        }
        builder.buildFuture();
        return builder;
    }

    public static FeruchemyArgumentType createArgument() {
        return new FeruchemyArgumentType();
    }

    public Manifestation parse(StringReader reader) throws CommandSyntaxException {
        ResourceLocation location = ResourceLocation.m_135818_((StringReader)reader);
        Manifestation manifestation = (Manifestation)CosmereAPI.manifestationRegistry().getValue(location);
        if (manifestation != null) {
            return manifestation;
        }
        throw INVALID_MANIFESTATION_EXCEPTION.create((Object)location);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return context.getSource() instanceof SharedSuggestionProvider ? SharedSuggestionProvider.m_82970_(Collections.emptyList(), (SuggestionsBuilder)FeruchemyArgumentType.addFeruchemyNamesWithTooltip(builder)) : Suggestions.empty();
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

