/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.common.eventHandlers;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import leaf.cosmere.api.Constants;
import leaf.cosmere.api.spiritweb.ISpiritweb;
import leaf.cosmere.common.cap.entity.SpiritwebCapability;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="cosmere", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CapabilitiesHandler {
    @SubscribeEvent
    public static void attachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Entity eventEntity = (Entity)event.getObject();
        if (CapabilitiesHandler.isValidSpiritWebEntity(eventEntity)) {
            final LivingEntity livingEntity = (LivingEntity)eventEntity;
            event.addCapability(Constants.Resources.SPIRITWEB_CAP, (ICapabilityProvider)new ICapabilitySerializable<CompoundTag>(){
                final SpiritwebCapability spiritweb;
                final LazyOptional<ISpiritweb> spiritwebInstance;
                {
                    this.spiritweb = new SpiritwebCapability(livingEntity);
                    this.spiritwebInstance = LazyOptional.of(() -> this.spiritweb);
                }

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                    return cap == SpiritwebCapability.CAPABILITY ? this.spiritwebInstance : LazyOptional.empty();
                }

                public CompoundTag serializeNBT() {
                    return this.spiritweb.serializeNBT();
                }

                public void deserializeNBT(CompoundTag nbt) {
                    this.spiritweb.deserializeNBT(nbt);
                }
            });
        }
    }

    public static boolean isValidSpiritWebEntity(Entity entity) {
        return entity instanceof Player || entity instanceof AbstractVillager || entity instanceof ZombieVillager || entity instanceof Raider && !(entity instanceof Ravager) || entity instanceof AbstractPiglin || entity instanceof Warden || entity instanceof Llama || entity instanceof Cat;
    }
}

