/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.common.fog;

import java.util.Objects;
import java.util.Optional;
import leaf.cosmere.api.CosmereAPI;
import leaf.cosmere.api.InterpolatedValue;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.util.CubicSampler;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class FogManager {
    @Nullable
    public static FogManager densityManager;
    private final Minecraft mc;
    public InterpolatedValue fogStart;
    public InterpolatedValue fogEnd;
    public Vec3 unlitFogColor = Vec3.f_82478_;

    public static FogManager getDensityManager() {
        return Objects.requireNonNull(densityManager, "Attempted to call getDensityManager before it finished loading!");
    }

    public static Optional<FogManager> getDensityManagerOptional() {
        return Optional.ofNullable(densityManager);
    }

    public FogManager() {
        this.mc = Minecraft.m_91087_();
        this.fogStart = new InterpolatedValue(0.9f);
        this.fogEnd = new InterpolatedValue(1.0f);
    }

    public void tick() {
        BlockPos pos = this.mc.f_91063_.m_109153_().m_90588_();
        if (this.mc.f_91073_ == null) {
            return;
        }
        ClientLevel pLevel = this.mc.f_91073_;
        boolean isFogDense = pLevel.m_104583_().m_5781_(pos.m_123341_(), pos.m_123343_()) || this.mc.f_91065_.m_93090_().m_93715_();
        float density = isFogDense ? 0.9f : 1.0f;
        Camera camera = this.mc.f_91063_.m_109153_();
        BiomeManager biomemanager = pLevel.m_7062_();
        Vec3 playerPos = camera.m_90583_().m_82492_(2.0, 2.0, 2.0).m_82490_(0.25);
        this.unlitFogColor = CubicSampler.m_130038_((Vec3)playerPos, (p_109033_, p_109034_, p_109035_) -> pLevel.m_104583_().m_5927_(Vec3.m_82501_((int)((Biome)biomemanager.m_204210_(p_109033_, p_109034_, p_109035_).m_203334_()).m_47539_()), 1.0f));
        this.getDarknessEffectedFog(this.fogStart.defaultValue, this.fogEnd.defaultValue * density);
    }

    public void getDarknessEffectedFog(float fs, float fd) {
        float renderDistance = this.mc.f_91063_.m_109152_() * 16.0f;
        Entity entity = this.mc.f_91075_;
        float fogStart = fs;
        float fogEnd = fd;
        this.fogEnd.setInterpolationSpeed(0.05f);
        this.fogStart.setInterpolationSpeed(0.05f);
        if (entity instanceof LivingEntity) {
            MobEffectInstance effect;
            LivingEntity e = (LivingEntity)entity;
            if (e.m_21023_(MobEffects.f_19610_)) {
                fogStart = 64.0f / renderDistance;
                fogEnd = 128.0f / renderDistance;
            } else if (e.m_21023_(MobEffects.f_216964_) && !(effect = e.m_21124_(MobEffects.f_216964_)).m_216895_().isEmpty()) {
                float factor = ((Double)this.mc.f_91066_.m_231926_().m_231551_()).floatValue();
                float intensity = ((MobEffectInstance.FactorData)effect.m_216895_().get()).m_238413_(e, this.mc.getPartialTick()) * factor;
                float darkness = 1.0f - this.calculateDarknessScale(e, ((MobEffectInstance.FactorData)effect.m_216895_().get()).m_238413_(e, this.mc.getPartialTick()), this.mc.getPartialTick());
                CosmereAPI.logger.info("FogManager darkness intensity: " + intensity);
                fogStart = 128.0f / renderDistance * darkness;
                fogEnd = 240.0f / renderDistance;
            }
        }
        this.fogStart.interpolate(fogStart);
        this.fogEnd.interpolate(fogEnd);
    }

    private float calculateDarknessScale(LivingEntity pEntity, float darknessFactor, float partialTicks) {
        float factor = ((Double)this.mc.f_91066_.m_231926_().m_231551_()).floatValue();
        float f = 0.45f * darknessFactor;
        return Math.max(0.0f, Mth.m_14089_((float)(((float)pEntity.f_19797_ - partialTicks) * (float)Math.PI * 0.025f)) * f) * factor;
    }

    public void close() {
    }

    public static void resetFog() {
        if (densityManager != null) {
            FogManager.densityManager.fogStart.setDefaultValue(0.9f);
            FogManager.densityManager.fogEnd.setDefaultValue(1.0f);
        }
    }
}

