/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.common.items;

import java.util.List;
import leaf.cosmere.api.Constants;
import leaf.cosmere.api.CosmereAPI;
import leaf.cosmere.api.IHasMetalType;
import leaf.cosmere.api.Metals;
import leaf.cosmere.api.manifestation.Manifestation;
import leaf.cosmere.common.cap.entity.SpiritwebCapability;
import leaf.cosmere.common.items.ChargeableItemBase;
import leaf.cosmere.common.properties.PropTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class ChargeableMetalCurioItem
extends ChargeableItemBase
implements IHasMetalType,
ICurioItem {
    private final Metals.MetalType metalType;

    public ChargeableMetalCurioItem(Metals.MetalType metalType) {
        super(PropTypes.Items.ONE.get().m_41497_(metalType.getRarity()));
        this.metalType = metalType;
    }

    @Override
    public Metals.MetalType getMetalType() {
        return this.metalType;
    }

    public List<Component> getAttributesTooltip(List<Component> tooltips, ItemStack stack) {
        return super.getAttributesTooltip(tooltips, stack);
    }

    public boolean makesPiglinsNeutral(SlotContext slotContext, ItemStack stack) {
        return this.makesPiglinsNeutral(stack, slotContext.entity());
    }

    public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
        return this.metalType == Metals.MetalType.GOLD;
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        super.onUnequip(slotContext, newStack, stack);
        if (this.metalType == Metals.MetalType.NICROSIL) {
            SpiritwebCapability.get(slotContext.entity()).ifPresent(data -> {
                for (Manifestation manifestation : CosmereAPI.manifestationRegistry()) {
                    AttributeInstance attributeInstance;
                    Attribute attribute = manifestation.getAttribute();
                    if (attribute == null || (attributeInstance = data.getLiving().m_21051_(attribute)) == null) continue;
                    attributeInstance.m_22120_(Constants.NBT.FERU_NICROSIL_UUID);
                }
            });
        }
    }
}

