/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.common.items;

import java.util.List;
import javax.annotation.Nonnull;
import leaf.cosmere.api.text.TextHelper;
import leaf.cosmere.common.compat.patchouli.PatchouliCompat;
import leaf.cosmere.common.properties.PropTypes;
import leaf.cosmere.common.registry.ItemsRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.patchouli.api.PatchouliAPI;

public class GuideItem
extends Item {
    public GuideItem() {
        super(PropTypes.Items.ONE.get().m_41497_(Rarity.RARE));
    }

    public static boolean isOpen() {
        return ItemsRegistry.GUIDE.getRegistryName().equals((Object)PatchouliAPI.get().getOpenBookGui());
    }

    public static Component getTitle(ItemStack stack) {
        Component title = stack.m_41786_();
        String akashicTomeNBT = "akashictome:displayName";
        if (stack.m_41782_() && stack.m_41783_().m_128441_(akashicTomeNBT)) {
            title = Component.Serializer.m_130701_((String)stack.m_41783_().m_128461_(akashicTomeNBT));
        }
        return title;
    }

    public static BlockHitResult doRayTrace(Level world, Player player, ClipContext.Fluid fluidMode) {
        return Item.m_41435_((Level)world, (Player)player, (ClipContext.Fluid)fluidMode);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)GuideItem.getEdition().m_6881_().m_130940_(ChatFormatting.GRAY));
    }

    public static Component getEdition() {
        if (PatchouliCompat.PatchouliIsPresent()) {
            try {
                return PatchouliAPI.get().getSubtitle(ItemsRegistry.GUIDE.getRegistryName());
            }
            catch (IllegalArgumentException e) {
                return Component.m_237119_();
            }
        }
        return TextHelper.createTranslatedText("tooltip.cosmere.patchouli.not_installed", new Object[0]);
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        if (!PatchouliCompat.PatchouliIsPresent()) {
            playerIn.m_213846_((Component)TextHelper.createTranslatedText("tooltip.cosmere.patchouli.not_installed", new Object[0]));
        } else if (playerIn instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)playerIn;
            PatchouliAPI.get().openBookGUI(player, ItemsRegistry.GUIDE.getRegistryName());
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }
}

