/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.common.network;

import java.util.Optional;
import java.util.function.Function;
import leaf.cosmere.api.Version;
import leaf.cosmere.common.network.ICosmerePacket;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public abstract class BasePacketHandler {
    private int index = 0;

    protected static SimpleChannel createChannel(ResourceLocation name, Version version) {
        String protocolVersion = version.toString();
        return NetworkRegistry.ChannelBuilder.named((ResourceLocation)name).clientAcceptedVersions(protocolVersion::equals).serverAcceptedVersions(protocolVersion::equals).networkProtocolVersion(() -> protocolVersion).simpleChannel();
    }

    protected abstract SimpleChannel getChannel();

    public abstract void initialize();

    protected <MSG extends ICosmerePacket> void registerClientToServer(Class<MSG> type, Function<FriendlyByteBuf, MSG> decoder) {
        this.registerMessage(type, decoder, NetworkDirection.PLAY_TO_SERVER);
    }

    protected <MSG extends ICosmerePacket> void registerServerToClient(Class<MSG> type, Function<FriendlyByteBuf, MSG> decoder) {
        this.registerMessage(type, decoder, NetworkDirection.PLAY_TO_CLIENT);
    }

    private <MSG extends ICosmerePacket> void registerMessage(Class<MSG> type, Function<FriendlyByteBuf, MSG> decoder, NetworkDirection networkDirection) {
        this.getChannel().registerMessage(this.index++, type, ICosmerePacket::encode, decoder, ICosmerePacket::handle, Optional.of(networkDirection));
    }

    public void sendToServer(Object msg) {
        this.getChannel().sendToServer(msg);
    }

    public void sendTo(Object msg, ServerPlayer player) {
        if (!(player instanceof FakePlayer)) {
            this.getChannel().send(PacketDistributor.PLAYER.with(() -> player), msg);
        }
    }

    public void sendPacketToAll(Object packet) {
        this.getChannel().send(PacketDistributor.ALL.noArg(), packet);
    }

    public void sendToAllAround(Object mes, ResourceKey<Level> dim, BlockPos pos, int radius) {
        this.getChannel().send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)radius, dim)), mes);
    }

    public void sendToAllInWorld(Object mes, ServerLevel world) {
        this.getChannel().send(PacketDistributor.DIMENSION.with(() -> ((ServerLevel)world).m_46472_()), mes);
    }

    public void sendToTrackingTE(Object mes, BlockEntity te) {
        if (te != null && !te.m_58904_().f_46443_) {
            this.getChannel().send(PacketDistributor.TRACKING_CHUNK.with(() -> te.m_58904_().m_46745_(te.m_58899_())), mes);
        }
    }
}

