/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.common.registration;

import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import leaf.cosmere.common.Cosmere;
import leaf.cosmere.common.registration.WrappedRegistryObject;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryObject;

public class WrappedDeferredRegister<T> {
    protected final DeferredRegister<T> internal;
    protected final String modid;

    protected WrappedDeferredRegister(DeferredRegister<T> internal, String modid) {
        this.internal = internal;
        this.modid = modid;
    }

    protected WrappedDeferredRegister(String modid, IForgeRegistry<T> registry) {
        this(DeferredRegister.create(registry, (String)modid), modid);
    }

    protected WrappedDeferredRegister(String modid, ResourceKey<? extends Registry<T>> registryName) {
        this(DeferredRegister.create(registryName, (String)modid), modid);
    }

    protected <I extends T, W extends WrappedRegistryObject<I>> W register(String name, Supplier<? extends I> sup, Function<RegistryObject<I>, W> objectWrapper) {
        return (W)((WrappedRegistryObject)objectWrapper.apply(this.internal.register(name, sup)));
    }

    public void register(IEventBus bus) {
        this.internal.register(bus);
    }

    public void createAndRegister(IEventBus bus) {
        this.createAndRegister(bus, UnaryOperator.identity());
    }

    public void createAndRegister(IEventBus bus, UnaryOperator<RegistryBuilder<T>> builder) {
        this.internal.makeRegistry(() -> (RegistryBuilder)builder.apply(new RegistryBuilder()));
        this.register(bus);
    }

    public void createAndRegisterManifestation(IEventBus bus) {
        this.createAndRegister(bus, builder -> builder.hasTags().setDefaultKey(Cosmere.rl("none")));
    }
}

