/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.common.registration.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import leaf.cosmere.api.providers.IBlockProvider;
import leaf.cosmere.common.registration.DoubleDeferredRegister;
import leaf.cosmere.common.registration.impl.BlockRegistryObject;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockDeferredRegister
extends DoubleDeferredRegister<Block, Item> {
    private final List<IBlockProvider> allBlocks = new ArrayList<IBlockProvider>();

    public BlockDeferredRegister(String modid) {
        super(modid, ForgeRegistries.BLOCKS, ForgeRegistries.ITEMS);
    }

    public <BLOCK extends Block> BlockRegistryObject<BLOCK, BlockItem> register(String name, Supplier<? extends BLOCK> blockSupplier) {
        return this.registerDefaultProperties(name, blockSupplier, BlockItem::new, Rarity.COMMON);
    }

    public <BLOCK extends Block> BlockRegistryObject<BLOCK, BlockItem> registerWithRarity(String name, Supplier<? extends BLOCK> blockSupplier, Rarity rarity) {
        return this.registerDefaultProperties(name, blockSupplier, BlockItem::new, rarity);
    }

    public <BLOCK extends Block, ITEM extends BlockItem> BlockRegistryObject<BLOCK, ITEM> registerDefaultProperties(String name, Supplier<? extends BLOCK> blockSupplier, BiFunction<BLOCK, Item.Properties, ITEM> itemCreator, Rarity rarity) {
        return this.register(name, blockSupplier, block -> (BlockItem)itemCreator.apply(block, new Item.Properties().m_41497_(rarity)));
    }

    public <BLOCK extends Block, ITEM extends BlockItem> BlockRegistryObject<BLOCK, ITEM> register(String name, Supplier<? extends BLOCK> blockSupplier, Function<BLOCK, ITEM> itemCreator) {
        BlockRegistryObject registeredBlock = this.register(name, blockSupplier, itemCreator, BlockRegistryObject::new);
        this.allBlocks.add(registeredBlock);
        return registeredBlock;
    }

    public List<IBlockProvider> getAllBlocks() {
        return Collections.unmodifiableList(this.allBlocks);
    }
}

