/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.common.registration.impl;

import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import leaf.cosmere.api.providers.IBlockProvider;
import leaf.cosmere.api.providers.IItemProvider;
import leaf.cosmere.common.registration.WrappedDeferredRegister;
import leaf.cosmere.common.registration.impl.BlockDeferredRegister;
import leaf.cosmere.common.registration.impl.CreativeTabRegistryObject;
import leaf.cosmere.common.registration.impl.ItemDeferredRegister;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.IEventBus;

public class CreativeTabDeferredRegister
extends WrappedDeferredRegister<CreativeModeTab> {
    private final Consumer<BuildCreativeModeTabContentsEvent> addToExistingTabs;
    private final String modid;

    public CreativeTabDeferredRegister(String modid) {
        this(modid, (BuildCreativeModeTabContentsEvent event) -> {});
    }

    public CreativeTabDeferredRegister(String modid, Consumer<BuildCreativeModeTabContentsEvent> addToExistingTabs) {
        super(modid, Registries.f_279569_);
        this.modid = modid;
        this.addToExistingTabs = addToExistingTabs;
    }

    @Override
    public void register(IEventBus bus) {
        super.register(bus);
        bus.addListener(this.addToExistingTabs);
    }

    public CreativeTabRegistryObject registerMain(Component title, IItemProvider icon, UnaryOperator<CreativeModeTab.Builder> operator) {
        return this.register(this.modid, title, icon, operator);
    }

    public CreativeTabRegistryObject register(String name, Component title, IItemProvider icon, UnaryOperator<CreativeModeTab.Builder> operator) {
        return this.register(name, () -> {
            CreativeModeTab.Builder builder = CreativeModeTab.builder().m_257941_(title).m_257737_(icon::getItemStack).withTabFactory(CosmereCreativeTab::new);
            return ((CreativeModeTab.Builder)operator.apply(builder)).m_257652_();
        }, CreativeTabRegistryObject::new);
    }

    public static void addToDisplay(CreativeModeTab.Output output, ItemLike ... items) {
        for (ItemLike item : items) {
            CreativeTabDeferredRegister.addToDisplay(output, item);
        }
    }

    public static void addToDisplay(CreativeModeTab.Output output, ItemLike itemLike) {
        Item item = itemLike.m_5456_();
        if (item instanceof ICustomCreativeTabContents) {
            ICustomCreativeTabContents contents = (ICustomCreativeTabContents)item;
            if (contents.addDefault()) {
                output.m_246326_(itemLike);
            }
            contents.addItems(output);
        } else {
            output.m_246326_(itemLike);
        }
    }

    public static void addToDisplay(ItemDeferredRegister register, CreativeModeTab.Output output) {
        for (IItemProvider itemProvider : register.getAllItems()) {
            CreativeTabDeferredRegister.addToDisplay(output, (ItemLike)itemProvider);
        }
    }

    public static void addToDisplay(BlockDeferredRegister register, CreativeModeTab.Output output) {
        for (IBlockProvider itemProvider : register.getAllBlocks()) {
            CreativeTabDeferredRegister.addToDisplay(output, (ItemLike)itemProvider);
        }
    }

    public static interface ICustomCreativeTabContents {
        public void addItems(CreativeModeTab.Output var1);

        default public boolean addDefault() {
            return true;
        }
    }

    public static class CosmereCreativeTab
    extends CreativeModeTab {
        protected CosmereCreativeTab(CreativeModeTab.Builder builder) {
            super(builder);
        }

        public int getLabelColor() {
            return -12566464;
        }
    }
}

