/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.common.world.height;

import java.util.function.Supplier;
import leaf.cosmere.common.resource.ore.OreAnchor;
import leaf.cosmere.common.world.height.AnchorType;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.Nullable;

public record ConfigurableVerticalAnchor(Supplier<AnchorType> anchorType, Supplier<Integer> value) {
    public static ConfigurableVerticalAnchor create(ForgeConfigSpec.Builder builder, String path, String comment, OreAnchor defaultAnchor, @Nullable ConfigurableVerticalAnchor minAnchor) {
        builder.comment(comment).push(path);
        ForgeConfigSpec.EnumValue type = builder.comment(new String[]{"Type of anchor.", "Absolute -> y = value", "Above Bottom -> y = minY + value", "Below Top -> y = depth - 1 + minY - value"}).defineEnum("type", (Enum)defaultAnchor.type());
        ForgeConfigSpec.Builder valueBuilder = builder.comment("Value used for calculating y for the anchor based on the type.");
        ForgeConfigSpec.ConfigValue value = minAnchor == null ? valueBuilder.define("value", (Object)defaultAnchor.value()) : valueBuilder.define("value", (Object)defaultAnchor.value(), o -> {
            if (o instanceof Integer) {
                Integer v = (Integer)o;
                return minAnchor.anchorType.get() != type.get() || v >= minAnchor.value.get();
            }
            return false;
        });
        builder.pop();
        return new ConfigurableVerticalAnchor((Supplier<AnchorType>)type, (Supplier<Integer>)value);
    }

    public int resolveY(WorldGenerationContext context) {
        return this.anchorType.get().resolveY(context, this.value.get());
    }

    @Override
    public String toString() {
        return switch (this.anchorType.get()) {
            default -> throw new IncompatibleClassChangeError();
            case AnchorType.ABSOLUTE -> this.value.get() + " absolute";
            case AnchorType.ABOVE_BOTTOM -> this.value.get() + " above bottom";
            case AnchorType.BELOW_TOP -> this.value.get() + " below top";
        };
    }
}

