/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.mixin;

import java.util.Optional;
import leaf.cosmere.api.CosmereAPI;
import leaf.cosmere.api.InterpolatedValue;
import leaf.cosmere.api.Metals;
import leaf.cosmere.api.manifestation.Manifestation;
import leaf.cosmere.api.math.MathHelper;
import leaf.cosmere.api.spiritweb.ISpiritweb;
import leaf.cosmere.common.cap.entity.SpiritwebCapability;
import leaf.cosmere.common.registration.impl.AttributeRegistryObject;
import leaf.cosmere.common.registry.AttributesRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.LazyOptional;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.ModifyConstant;

@Mixin(value={LightTexture.class})
public class LightTextureMixin {
    @Unique
    private static final ResourceLocation TIN_RL = new ResourceLocation("allomancy", Metals.MetalType.TIN.m_6082_());
    @Unique
    private final InterpolatedValue _cosmere$nightVision = new InterpolatedValue(0.0f);

    @ModifyConstant(method={"updateLightTexture"}, constant={@Constant(floatValue=0.0f, ordinal=1)})
    private float updateLightTextureConstant(float prev) {
        AttributeRegistryObject<Attribute> attributeRegistryObject;
        AttributeInstance attribute;
        Minecraft mc = Minecraft.m_91087_();
        Entity entity = Minecraft.m_91087_().m_91288_();
        if (!(entity instanceof Player)) {
            return prev;
        }
        Player clientPlayer = (Player)entity;
        LazyOptional<ISpiritweb> iSpiritwebLazyOptional = SpiritwebCapability.get((LivingEntity)clientPlayer);
        float tinAlloVal = 0.0f;
        if (iSpiritwebLazyOptional.isPresent()) {
            Object t;
            Optional spiritweb = iSpiritwebLazyOptional.resolve();
            Manifestation tinAllomancy = (Manifestation)CosmereAPI.manifestationRegistry().getValue(TIN_RL);
            if (spiritweb.isPresent() && (t = spiritweb.get()) instanceof SpiritwebCapability) {
                SpiritwebCapability data = (SpiritwebCapability)t;
                if (tinAllomancy != null && tinAllomancy.isActive((ISpiritweb)spiritweb.get())) {
                    float currentBurnStrength = (float)(tinAllomancy.getStrength(data, false) * (double)data.getMode(tinAllomancy));
                    RangedAttribute attribute2 = (RangedAttribute)tinAllomancy.getAttribute();
                    float maxTinFlareStrengthPossible = (float)(attribute2.m_147362_() * 2.0);
                    tinAlloVal = Mth.m_14179_((float)MathHelper.clamp01(currentBurnStrength / maxTinFlareStrengthPossible), (float)0.0f, (float)0.95f);
                }
            }
        }
        float v = (attribute = clientPlayer.m_21051_((Attribute)(attributeRegistryObject = AttributesRegistry.NIGHT_VISION_ATTRIBUTE).get())) != null ? (float)attribute.m_22135_() : prev;
        float total = v + tinAlloVal;
        this._cosmere$nightVision.setDefaultValue(MathHelper.clamp01(total));
        this._cosmere$nightVision.interpolate();
        return this._cosmere$nightVision.get(mc.getPartialTick());
    }
}

