/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.api;

import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;
import leaf.cosmere.api.CosmereAPI;
import leaf.cosmere.api.Metals;
import leaf.cosmere.api.Roshar;
import leaf.cosmere.api.Taldain;
import leaf.cosmere.api.manifestation.Manifestation;
import net.minecraft.resources.ResourceLocation;

public class Manifestations {
    public static final int ALLOMANCY_ID = 1;
    public static final int FERUCHEMY_ID = 2;
    public static final int HEMALURGY_ID = 7;
    public static final int SURGEBINDING_ID = 3;
    public static final int AONDOR_ID = 4;
    public static final int AWAKENING_ID = 5;
    public static final int SANDMASTERY_ID = 6;
    public static final int AVIAR_ID = 8;

    public static enum ManifestationTypes {
        NONE(0),
        ALLOMANCY(1),
        FERUCHEMY(2),
        HEMALURGY(7),
        SURGEBINDING(3),
        AON_DOR(4),
        AWAKENING(5),
        SANDMASTERY(6),
        AVIAR(8);

        final int id;

        private ManifestationTypes(int id) {
            this.id = id;
        }

        public int getID() {
            return this.id;
        }

        public static Optional<ManifestationTypes> valueOf(int value) {
            return Arrays.stream(ManifestationTypes.values()).filter(powerTypes -> powerTypes.id == value).findFirst();
        }

        public String getName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public Manifestation getManifestation(int powerID) {
            switch (this) {
                case ALLOMANCY: 
                case FERUCHEMY: {
                    Optional<Metals.MetalType> metalType = Metals.MetalType.valueOf(powerID);
                    if (!metalType.isPresent()) break;
                    return (Manifestation)CosmereAPI.manifestationRegistry().getValue(new ResourceLocation(this.getName(), metalType.get().m_6082_()));
                }
                case SURGEBINDING: {
                    Optional<Roshar.Surges> value = Roshar.Surges.valueOf(powerID);
                    if (!value.isPresent()) break;
                    return (Manifestation)CosmereAPI.manifestationRegistry().getValue(new ResourceLocation(this.getName(), value.get().getName()));
                }
                case AON_DOR: {
                    break;
                }
                case AWAKENING: {
                    break;
                }
                case SANDMASTERY: {
                    Optional<Taldain.Mastery> masteryStyle = Taldain.Mastery.valueOf(powerID);
                    if (!masteryStyle.isPresent()) break;
                    return (Manifestation)CosmereAPI.manifestationRegistry().getValue(new ResourceLocation(this.getName(), masteryStyle.get().getName()));
                }
            }
            return (Manifestation)CosmereAPI.manifestationRegistry().getValue(new ResourceLocation("cosmere", "none"));
        }
    }
}

