/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.api;

import java.awt.Color;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import leaf.cosmere.api.CosmereTags;
import leaf.cosmere.api.helpers.TimeHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.entity.animal.Pufferfish;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class Metals {

    private static class MistingNames {
        public static final String ALL = "mistborn";
        public static final String IRON = "lurcher";
        public static final String STEEL = "coinshot";
        public static final String TIN = "tineye";
        public static final String PEWTER = "thug";
        public static final String ALUMINUM = "aluminum_gnat";
        public static final String DURALUMIN = "duralumin_gnat";
        public static final String CHROMIUM = "leecher";
        public static final String NICROSIL = "nicroburst";
        public static final String ZINC = "rioter";
        public static final String BRASS = "soother";
        public static final String COPPER = "smoker";
        public static final String BRONZE = "seeker";
        public static final String GOLD = "augur";
        public static final String ELECTRUM = "oracle";
        public static final String CADMIUM = "pulser";
        public static final String BENDALLOY = "slider";
        public static final String ATIUM = "seer";

        private MistingNames() {
        }
    }

    private static class FerringNames {
        public static final String ALL = "feruchemist";
        public static final String IRON = "skimmer";
        public static final String STEEL = "steelrunner";
        public static final String TIN = "windwhisperer";
        public static final String PEWTER = "brute";
        public static final String ALUMINUM = "trueself";
        public static final String DURALUMIN = "connector";
        public static final String CHROMIUM = "spinner";
        public static final String NICROSIL = "soulbearer";
        public static final String ZINC = "sparker";
        public static final String BRASS = "firesoul";
        public static final String COPPER = "archivist";
        public static final String BRONZE = "sentry";
        public static final String GOLD = "bloodmaker";
        public static final String ELECTRUM = "pinnacle";
        public static final String CADMIUM = "gasper";
        public static final String BENDALLOY = "subsumer";
        public static final String ATIUM = "elderling";

        private FerringNames() {
        }
    }

    private static class MetalColor {
        public static final Color IRON = Color.decode("#f2f2f2");
        public static final Color STEEL = Color.decode("#737173");
        public static final Color TIN = Color.decode("#b0c9c3");
        public static final Color PEWTER = Color.decode("#a9a1a1");
        public static final Color ALUMINUM = Color.decode("#819393");
        public static final Color DURALUMIN = Color.decode("#7a8f90");
        public static final Color CHROMIUM = Color.decode("#595959");
        public static final Color NICROSIL = Color.decode("#9296b6");
        public static final Color ZINC = Color.decode("#d9debc");
        public static final Color BRASS = Color.decode("#fed679");
        public static final Color COPPER = Color.decode("#c15a36");
        public static final Color BRONZE = Color.decode("#8c5b30");
        public static final Color GOLD = Color.decode("#faf25e");
        public static final Color ELECTRUM = Color.decode("#b29988");
        public static final Color CADMIUM = Color.decode("#a94934");
        public static final Color BENDALLOY = Color.decode("#6d4c22");
        public static final Color LERASIUM = Color.decode("#e0e3d6");
        public static final Color ATIUM = Color.decode("#363434");
        public static final Color MALATIUM = Color.decode("#e0e3d6");
        public static final Color HARMONIUM = Color.decode("#9895aa");
        public static final Color LERASATIUM = Color.decode("#73788a");
        public static final Color NICKEL = Color.decode("#c4c091");
        public static final Color LEAD = Color.decode("#312f50");
        public static final Color SILVER = Color.decode("#d3e5eb");

        private MetalColor() {
        }
    }

    public static enum MetalType implements Tier,
    ArmorMaterial
    {
        IRON(0, 0, 0, 0.0f, 0.0f, 0),
        STEEL(1, 3, 1024, 8.0f, 4.0f, 8),
        TIN(2, 0, 159, 6.0f, 1.2f, 10),
        PEWTER(3, 2, 202, 5.0f, 3.0f, 10),
        ZINC(4, 2, 276, 16.0f, 0.5f, 12),
        BRASS(5, 2, 142, 10.0f, 0.0f, 16),
        COPPER(6, 2, 131, 9.0f, 2.0f, 32),
        BRONZE(7, 2, 400, 8.0f, 1.8f, 16),
        ALUMINUM(8, 0, 50, 8.0f, 1.0f, -100),
        DURALUMIN(9, 2, 1500, 6.0f, 5.8f, 28),
        CHROMIUM(10, 2, 1500, 5.0f, 2.8f, 10),
        NICROSIL(11, 2, 1250, 3.0f, 3.8f, 28),
        CADMIUM(12, 2, 32, 12.0f, 1.0f, 20),
        BENDALLOY(13, 2, 60, 6.0f, 2.0f, 16),
        GOLD(14, 0, 0, 0.0f, 0.0f, 0),
        ELECTRUM(15, 2, 45, 17.0f, 0.0f, 20),
        ATIUM(16, 3, 3000, 14.0f, 6.0f, 1),
        LERASIUM(17, 3, 6000, 12.0f, 4.8f, 0),
        HARMONIUM(18, 3, 1, 99.0f, 16.0f, 0),
        MALATIUM(19, 3, 300, 10.0f, 2.8f, 3),
        LERASATIUM(20, 3, 5000, 12.0f, 4.3f, 0),
        NICKEL(21, 2, 350, 6.0f, 1.8f, 14),
        LEAD(22, 2, 16, 6.0f, 12.0f, 2),
        SILVER(23, 2, 32, 12.0f, 0.0f, 15);

        private final int id;
        private final int level;
        private final int uses;
        private final float speed;
        private final float damage;
        private final int enchantmentValue;

        private MetalType(int id, int level, int uses, float speed, float damage, int enchantmentValue) {
            this.id = id;
            this.level = level;
            this.uses = uses;
            this.speed = speed;
            this.damage = damage;
            this.enchantmentValue = enchantmentValue;
        }

        public static Optional<MetalType> valueOf(int value) {
            return Arrays.stream(MetalType.values()).filter(metalType -> metalType.id == value).findFirst();
        }

        public int getID() {
            return this.id;
        }

        public String m_6082_() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public Rarity getRarity() {
            switch (this) {
                case ATIUM: 
                case MALATIUM: {
                    return Rarity.RARE;
                }
                case LERASIUM: 
                case LERASATIUM: 
                case HARMONIUM: {
                    return Rarity.EPIC;
                }
            }
            return Rarity.COMMON;
        }

        public boolean isGodMetal() {
            switch (this) {
                case ATIUM: 
                case LERASIUM: 
                case LERASATIUM: 
                case HARMONIUM: {
                    return true;
                }
            }
            return false;
        }

        public boolean hasAssociatedManifestation() {
            switch (this) {
                case MALATIUM: 
                case LERASIUM: 
                case LERASATIUM: 
                case HARMONIUM: 
                case NICKEL: 
                case SILVER: 
                case LEAD: {
                    return false;
                }
            }
            return true;
        }

        public boolean hasHemalurgicEffect() {
            switch (this) {
                case MALATIUM: 
                case HARMONIUM: 
                case NICKEL: 
                case SILVER: 
                case LEAD: {
                    return false;
                }
            }
            return true;
        }

        public boolean isPhysicalSpike() {
            switch (this) {
                case ATIUM: 
                case LERASIUM: 
                case LERASATIUM: 
                case IRON: 
                case STEEL: 
                case TIN: 
                case PEWTER: {
                    return true;
                }
            }
            return false;
        }

        public boolean isMentalSpike() {
            switch (this) {
                case ATIUM: 
                case LERASIUM: 
                case LERASATIUM: 
                case ZINC: 
                case BRASS: 
                case COPPER: 
                case BRONZE: {
                    return true;
                }
            }
            return false;
        }

        public boolean isSpiritualSpike() {
            switch (this) {
                case ATIUM: 
                case LERASIUM: 
                case LERASATIUM: 
                case CHROMIUM: 
                case NICROSIL: 
                case ALUMINUM: 
                case DURALUMIN: {
                    return true;
                }
            }
            return false;
        }

        public boolean isTemporalSpike() {
            switch (this) {
                case ATIUM: 
                case LERASIUM: 
                case LERASATIUM: 
                case CADMIUM: 
                case BENDALLOY: 
                case GOLD: 
                case ELECTRUM: {
                    return true;
                }
            }
            return false;
        }

        public boolean hasFeruchemicalEffect() {
            switch (this) {
                case MALATIUM: 
                case LERASIUM: 
                case LERASATIUM: 
                case HARMONIUM: 
                case NICKEL: 
                case SILVER: 
                case LEAD: {
                    return false;
                }
            }
            return true;
        }

        public boolean hasOre() {
            switch (this) {
                case NICKEL: 
                case SILVER: 
                case LEAD: 
                case TIN: 
                case ZINC: 
                case CHROMIUM: 
                case ALUMINUM: 
                case CADMIUM: {
                    return true;
                }
            }
            return false;
        }

        public boolean isAlloy() {
            switch (this) {
                case STEEL: 
                case PEWTER: 
                case BRASS: 
                case BRONZE: 
                case NICROSIL: 
                case DURALUMIN: 
                case BENDALLOY: 
                case ELECTRUM: {
                    return true;
                }
            }
            return false;
        }

        public boolean hasMaterialItem() {
            switch (this) {
                case IRON: 
                case GOLD: {
                    return false;
                }
            }
            return true;
        }

        public TagKey<Item> getMetalRawTag() {
            return CosmereTags.Items.METAL_RAW_TAGS.get((Object)this);
        }

        public TagKey<Item> getMetalBlendTag() {
            return CosmereTags.Items.METAL_DUST_TAGS.get((Object)this);
        }

        public TagKey<Item> getMetalIngotTag() {
            return CosmereTags.Items.METAL_INGOT_TAGS.get((Object)this);
        }

        public TagKey<Item> getMetalNuggetTag() {
            return CosmereTags.Items.METAL_NUGGET_TAGS.get((Object)this);
        }

        public TagKey<Item> getGodMetalAlloyNuggetTag(MetalType alloyedMetalType) {
            return CosmereTags.Items.GOD_METAL_ALLOY_NUGGET_TAGS.get((Object)this).get((Object)alloyedMetalType);
        }

        public Color getColor() {
            switch (this) {
                default: {
                    return MetalColor.IRON;
                }
                case STEEL: {
                    return MetalColor.STEEL;
                }
                case TIN: {
                    return MetalColor.TIN;
                }
                case PEWTER: {
                    return MetalColor.PEWTER;
                }
                case ALUMINUM: {
                    return MetalColor.ALUMINUM;
                }
                case DURALUMIN: {
                    return MetalColor.DURALUMIN;
                }
                case CHROMIUM: {
                    return MetalColor.CHROMIUM;
                }
                case NICROSIL: {
                    return MetalColor.NICROSIL;
                }
                case ZINC: {
                    return MetalColor.ZINC;
                }
                case BRASS: {
                    return MetalColor.BRASS;
                }
                case COPPER: {
                    return MetalColor.COPPER;
                }
                case BRONZE: {
                    return MetalColor.BRONZE;
                }
                case GOLD: {
                    return MetalColor.GOLD;
                }
                case ELECTRUM: {
                    return MetalColor.ELECTRUM;
                }
                case CADMIUM: {
                    return MetalColor.CADMIUM;
                }
                case BENDALLOY: {
                    return MetalColor.BENDALLOY;
                }
                case LERASIUM: {
                    return MetalColor.LERASIUM;
                }
                case ATIUM: {
                    return MetalColor.ATIUM;
                }
                case MALATIUM: {
                    return MetalColor.MALATIUM;
                }
                case LERASATIUM: {
                    return MetalColor.LERASATIUM;
                }
                case HARMONIUM: {
                    return MetalColor.HARMONIUM;
                }
                case NICKEL: {
                    return MetalColor.NICKEL;
                }
                case LEAD: {
                    return MetalColor.LEAD;
                }
                case SILVER: 
            }
            return MetalColor.SILVER;
        }

        public int getColorValue() {
            return this.getColor().getRGB();
        }

        public String getFerringName() {
            switch (this) {
                case IRON: {
                    return "skimmer";
                }
                case STEEL: {
                    return "steelrunner";
                }
                case TIN: {
                    return "windwhisperer";
                }
                case PEWTER: {
                    return "brute";
                }
                case ALUMINUM: {
                    return "trueself";
                }
                case DURALUMIN: {
                    return "connector";
                }
                case CHROMIUM: {
                    return "spinner";
                }
                case NICROSIL: {
                    return "soulbearer";
                }
                case ZINC: {
                    return "sparker";
                }
                case BRASS: {
                    return "firesoul";
                }
                case COPPER: {
                    return "archivist";
                }
                case BRONZE: {
                    return "sentry";
                }
                case GOLD: {
                    return "bloodmaker";
                }
                case ELECTRUM: {
                    return "pinnacle";
                }
                case CADMIUM: {
                    return "gasper";
                }
                case BENDALLOY: {
                    return "subsumer";
                }
                case ATIUM: {
                    return "elderling";
                }
                case LERASATIUM: {
                    return "feruchemist";
                }
            }
            return "ferring_" + this.m_6082_();
        }

        public boolean isPushMetal() {
            switch (this) {
                case STEEL: 
                case PEWTER: 
                case BRASS: 
                case BRONZE: 
                case NICROSIL: 
                case DURALUMIN: 
                case BENDALLOY: 
                case ELECTRUM: {
                    return true;
                }
            }
            return false;
        }

        public boolean isPullMetal() {
            switch (this) {
                case IRON: 
                case TIN: 
                case ZINC: 
                case COPPER: 
                case CHROMIUM: 
                case ALUMINUM: 
                case CADMIUM: 
                case GOLD: {
                    return true;
                }
            }
            return false;
        }

        public String getMistingName() {
            switch (this) {
                case IRON: {
                    return "lurcher";
                }
                case STEEL: {
                    return "coinshot";
                }
                case TIN: {
                    return "tineye";
                }
                case PEWTER: {
                    return "thug";
                }
                case ALUMINUM: {
                    return "aluminum_gnat";
                }
                case DURALUMIN: {
                    return "duralumin_gnat";
                }
                case CHROMIUM: {
                    return "leecher";
                }
                case NICROSIL: {
                    return "nicroburst";
                }
                case ZINC: {
                    return "rioter";
                }
                case BRASS: {
                    return "soother";
                }
                case COPPER: {
                    return "smoker";
                }
                case BRONZE: {
                    return "seeker";
                }
                case GOLD: {
                    return "augur";
                }
                case ELECTRUM: {
                    return "oracle";
                }
                case CADMIUM: {
                    return "pulser";
                }
                case BENDALLOY: {
                    return "slider";
                }
                case ATIUM: {
                    return "seer";
                }
                case LERASIUM: {
                    return "mistborn";
                }
            }
            return "misting_" + this.m_6082_();
        }

        public Collection<MetalType> getHemalurgyStealWhitelist() {
            switch (this) {
                case STEEL: 
                case PEWTER: {
                    return Arrays.asList(IRON, STEEL, TIN, PEWTER);
                }
                case BRASS: 
                case BRONZE: {
                    return Arrays.asList(ZINC, BRASS, COPPER, BRONZE);
                }
                case CADMIUM: 
                case GOLD: {
                    return Arrays.asList(CADMIUM, BENDALLOY, GOLD, ELECTRUM);
                }
                case BENDALLOY: 
                case ELECTRUM: {
                    return Arrays.asList(CHROMIUM, NICROSIL, ALUMINUM, DURALUMIN);
                }
                case ATIUM: 
                case LERASIUM: {
                    return Arrays.stream(MetalType.values()).filter(MetalType::hasAssociatedManifestation).collect(Collectors.toList());
                }
            }
            return null;
        }

        public int getAllomancyBurnTimeSeconds() {
            double burnTimeInSeconds = switch (this) {
                case IRON, STEEL -> TimeHelper.MinutesToSeconds(5.0);
                case TIN -> TimeHelper.MinutesToSeconds(15.0);
                case PEWTER -> TimeHelper.MinutesToSeconds(2.5);
                case ZINC, BRASS -> TimeHelper.MinutesToSeconds(5.0);
                case COPPER -> TimeHelper.MinutesToSeconds(10.0);
                case BRONZE -> TimeHelper.MinutesToSeconds(7.5);
                case CHROMIUM, NICROSIL, ALUMINUM, DURALUMIN -> TimeHelper.MinutesToSeconds(0.5);
                case CADMIUM -> TimeHelper.MinutesToSeconds(7.5);
                case BENDALLOY -> TimeHelper.MinutesToSeconds(2.5);
                case GOLD, ELECTRUM -> TimeHelper.MinutesToSeconds(2.5);
                case ATIUM -> TimeHelper.MinutesToSeconds(0.5);
                case MALATIUM -> TimeHelper.MinutesToSeconds(1.0);
                default -> 99.0;
            };
            return Mth.m_14107_((double)burnTimeInSeconds);
        }

        public double getEntityAbilityStrength(LivingEntity killedEntity, Player playerEntity) {
            double strengthToAdd = 0.0;
            switch (this) {
                case IRON: {
                    AttributeMap attributes = killedEntity.m_21204_();
                    if (!attributes.m_22171_(Attributes.f_22281_)) break;
                    strengthToAdd = attributes.m_22185_(Attributes.f_22281_) * 0.7;
                    break;
                }
                case TIN: {
                    if (killedEntity instanceof EnderDragon) {
                        strengthToAdd = 0.77;
                        break;
                    }
                    if (killedEntity instanceof Phantom) {
                        strengthToAdd = 0.66;
                        break;
                    }
                    if (killedEntity instanceof Player) {
                        strengthToAdd = 0.25;
                        break;
                    }
                    if (killedEntity instanceof Cat) {
                        strengthToAdd = 0.5;
                        break;
                    }
                    AttributeInstance attribute = killedEntity.m_21051_(Attributes.f_22277_);
                    if (attribute != null) {
                        int hemalurgicDecay = 150;
                        strengthToAdd = attribute.m_22115_() / 150.0;
                        break;
                    }
                    strengthToAdd = 0.1;
                    break;
                }
                case COPPER: {
                    float potentialRewardRate = (float)killedEntity.m_213860_() / 150.0f;
                    if (killedEntity instanceof Player) {
                        Attribute xpAttribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("cosmere", COPPER.m_6082_()));
                        if (xpAttribute == null) break;
                        AttributeInstance attribute = killedEntity.m_21051_(xpAttribute);
                        if (attribute != null) {
                            strengthToAdd = attribute.m_22135_() * 0.7;
                            double newBaseValue = attribute.m_22135_() * 0.25;
                            attribute.m_22100_((double)((float)((int)(newBaseValue * 100.0)) / 100.0f));
                            break;
                        }
                        strengthToAdd = potentialRewardRate;
                        break;
                    }
                    if (killedEntity instanceof EnderDragon) {
                        EnderDragon dragonEntity = (EnderDragon)killedEntity;
                        strengthToAdd = dragonEntity.m_31158_() != null && !dragonEntity.m_31158_().m_64099_() ? 1.0 : 0.33;
                        break;
                    }
                    strengthToAdd = potentialRewardRate;
                    break;
                }
                case ZINC: {
                    break;
                }
                case ALUMINUM: {
                    break;
                }
                case DURALUMIN: {
                    break;
                }
                case CHROMIUM: {
                    if (killedEntity instanceof Rabbit) {
                        strengthToAdd = 0.25;
                        break;
                    }
                    if (killedEntity instanceof WitherSkeleton) {
                        strengthToAdd = -1.0;
                        break;
                    }
                    if (killedEntity instanceof WitherBoss) {
                        strengthToAdd = -3.0;
                        break;
                    }
                    if (killedEntity instanceof Pufferfish) {
                        strengthToAdd = -0.5;
                        break;
                    }
                    if (!(killedEntity instanceof Cat)) break;
                    Cat cat = (Cat)killedEntity;
                    CatVariant catType = cat.m_28554_();
                    if (catType.f_218151_().m_135815_().contains("black")) {
                        strengthToAdd = -5.0;
                        break;
                    }
                    if (!catType.f_218151_().m_135815_().contains("white")) break;
                    strengthToAdd = 1.0;
                    break;
                }
            }
            return strengthToAdd;
        }

        public String getShortHemalurgicUseString() {
            switch (this) {
                case IRON: {
                    return "Steals physical strength.";
                }
                case STEEL: {
                    return "Steals a physical allomantic power.";
                }
                case TIN: {
                    return "Steals senses.";
                }
                case PEWTER: {
                    return "Steals a physical feruchemical power.";
                }
                case ZINC: {
                    return "Steals emotional fortitude.";
                }
                case BRASS: {
                    return "Steals a cognitive feruchemical power.";
                }
                case COPPER: {
                    return "Steals mental fortitude, memory, and intelligence.";
                }
                case BRONZE: {
                    return "Steals a Mental Allomantic power.";
                }
                case ALUMINUM: {
                    return "Removes all powers.";
                }
                case DURALUMIN: {
                    return "Steals Connection/Identity.";
                }
                case CHROMIUM: {
                    return "Might steal destiny...";
                }
                case NICROSIL: {
                    return "Steals Investiture.";
                }
                case CADMIUM: {
                    return "Steals a Temporal Allomantic power.";
                }
                case GOLD: {
                    return "Steals a Hybrid Feruchemical power.";
                }
                case BENDALLOY: {
                    return "Steals a Spiritual Feruchemical power.";
                }
                case ELECTRUM: {
                    return "Steals an Enhancement Allomantic power.";
                }
                case ATIUM: {
                    return "Steals an Allomantic or Feruchemical power. Must be refined.";
                }
                case LERASIUM: {
                    return "Steals all powers...";
                }
            }
            return "Unknown...";
        }

        public String getFeruchemyMetalmindUse() {
            switch (this) {
                case IRON: {
                    return "Stores Weight. Less weight slows descent. A Skimmer Ferring using this will decrease the pull of gravity on them in exchange for increasing it later.";
                }
                case STEEL: {
                    return "Stores Physical Speed. A Steelrunner Ferring using this will be physically slower now in exchange for being faster later.";
                }
                case TIN: {
                    return "Stores Eyesight senses. Tapping will zoom in.";
                }
                case PEWTER: {
                    return "Stores Strength. A Brute Ferring using this will lessen the size of his muscles to increase them later.";
                }
                case ZINC: {
                    return "Stores Mental Speed. A Sparker Ferring storing zinc will gain experience very slowly in exchange for gaining experience faster later.";
                }
                case BRASS: {
                    return "Stores Warmth. Firesoul Ferrings using this will cool themselves in exchange for being able to warm themselves later by tapping the metalmind.";
                }
                case COPPER: {
                    return "Stores Experience. An Archivist Ferring using this will be able to store experience inside copper, then withdraw it later from the metal.";
                }
                case BRONZE: {
                    return "Stores Wakefulness. A Sentry Ferring using this will sleep or be drowsier now in exchange for staying awake longer later.";
                }
                case ALUMINUM: {
                    return "Stores Identity. Trueself Ferrings can store their spiritual sense of self within an aluminum metalmind.";
                }
                case DURALUMIN: {
                    return "Stores Connection. A Connector Ferring can store spiritual connection inside a metalmind, reducing outside awareness during active storage. Tapping not yet implemented.";
                }
                case CHROMIUM: {
                    return "Stores Fortune. A Spinner Ferring will become unlucky during active storage in exchange for increased fortune later.";
                }
                case NICROSIL: {
                    return "Stores Investiture. Little is known about Soulbearer Ferrings. (Not yet implemented)";
                }
                case CADMIUM: {
                    return "Stores Breath. A Gasper Ferring may hyperventilate while storing breath in exchange for eliminating or reducing the need to breathe later on.";
                }
                case GOLD: {
                    return "Stores Health. A Bloodmaker Ferring using this will feel sick now in exchange for increased regeneration and healing later.";
                }
                case ELECTRUM: {
                    return "Stores Determination. A Pinnacle Ferring using this will take more damage in exchange for taking less damage later.";
                }
                case BENDALLOY: {
                    return "Stores Energy. A Subsumer Ferring using this can consume large quantities of food and store the calories in the metalmind, in exchange for the ability to forgo eating later.";
                }
                case ATIUM: {
                    return "Stores Height. Atium ferrings become smaller during active storage, and can tap it later to be come larger.";
                }
            }
            return "Unknown...";
        }

        public int m_6609_() {
            return this.uses;
        }

        public float m_6624_() {
            return this.speed;
        }

        public float m_6631_() {
            return this.damage;
        }

        public int m_6604_() {
            return this.level;
        }

        public int m_6646_() {
            return this.enchantmentValue;
        }

        @NotNull
        public Ingredient m_6230_() {
            return Ingredient.m_204132_(this.getMetalIngotTag());
        }

        public SoundEvent m_7344_() {
            return SoundEvents.f_11677_;
        }

        public float m_6651_() {
            return 0.0f;
        }

        public float m_6649_() {
            return 0.0f;
        }

        public int m_266425_(ArmorItem.Type pType) {
            float multiplier = switch (pType) {
                default -> 0.0f;
                case ArmorItem.Type.HELMET -> 0.3f;
                case ArmorItem.Type.CHESTPLATE -> 0.5f;
                case ArmorItem.Type.LEGGINGS -> 0.4f;
                case ArmorItem.Type.BOOTS -> 0.25f;
            };
            return Mth.m_14143_((float)((float)this.m_6609_() * multiplier));
        }

        public int m_7366_(ArmorItem.Type pType) {
            int n = this.m_6604_();
            return n + (switch (pType) {
                default -> 0;
                case ArmorItem.Type.HELMET, ArmorItem.Type.BOOTS -> 0;
                case ArmorItem.Type.LEGGINGS -> 3;
                case ArmorItem.Type.CHESTPLATE -> 4;
            });
        }

        public Item getNugget() {
            if (!this.hasMaterialItem()) {
                switch (this) {
                    case IRON: {
                        return Items.f_42749_;
                    }
                    case GOLD: {
                        return Items.f_42587_;
                    }
                }
            }
            ResourceLocation resourceLoc = new ResourceLocation("cosmere", this.m_6082_() + "_nugget");
            return (Item)ForgeRegistries.ITEMS.getValue(resourceLoc);
        }

        public String getTranslationKey() {
            return "metal.cosmere." + this.m_6082_();
        }
    }
}

