/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.api.cosmereEffect;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import leaf.cosmere.api.CosmereAPI;
import leaf.cosmere.api.cosmereEffect.AttributeModifierInfo;
import leaf.cosmere.api.cosmereEffect.CosmereEffect;
import leaf.cosmere.api.helpers.EffectsHelper;
import leaf.cosmere.api.providers.ICosmereEffectProvider;
import leaf.cosmere.api.spiritweb.ISpiritweb;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import org.jetbrains.annotations.NotNull;

public class CosmereEffectInstance
implements ICosmereEffectProvider {
    private CosmereEffect effect;
    private UUID uuid;
    private double strength;
    private int duration;
    private final Map<Attribute, AttributeModifierInfo> dynamicAttributeModifiers = Maps.newHashMap();

    public CosmereEffectInstance() {
    }

    public CosmereEffectInstance(CosmereEffect effect, UUID uuid, double strength, int duration) {
        this.effect = effect;
        this.uuid = uuid;
        this.strength = strength;
        this.duration = duration;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public CosmereEffect getEffect() {
        return this.effect;
    }

    public int getDuration() {
        return this.duration;
    }

    public double getStrength() {
        return this.strength;
    }

    public Tag save(CompoundTag compoundTag) {
        compoundTag.m_128359_("effect_id", this.getEffect().getRegistryName().toString());
        compoundTag.m_128362_("uuid", this.uuid);
        compoundTag.m_128347_("strength", this.strength);
        compoundTag.m_128405_("duration", this.duration);
        if (!this.dynamicAttributeModifiers.isEmpty()) {
            ListTag listtag = new ListTag();
            for (AttributeModifierInfo info : this.dynamicAttributeModifiers.values()) {
                listtag.add((Object)info.save(new CompoundTag()));
            }
            compoundTag.m_128365_("dynamic_attributes", (Tag)listtag);
        }
        return compoundTag;
    }

    @Nullable
    public static CosmereEffectInstance load(CompoundTag compoundtag) {
        ResourceLocation effectID = new ResourceLocation(compoundtag.m_128461_("effect_id"));
        if (CosmereAPI.cosmereEffectRegistry().containsKey(effectID)) {
            CosmereEffectInstance effectInstance = new CosmereEffectInstance();
            effectInstance.effect = (CosmereEffect)CosmereAPI.cosmereEffectRegistry().getValue(effectID);
            effectInstance.uuid = compoundtag.m_128342_("uuid");
            effectInstance.strength = compoundtag.m_128459_("strength");
            effectInstance.duration = compoundtag.m_128451_("duration");
            if (compoundtag.m_128441_("dynamic_attributes")) {
                ListTag listtag = (ListTag)compoundtag.m_128423_("dynamic_attributes");
                for (int i = 0; i < listtag.size(); ++i) {
                    CompoundTag attributeTag = listtag.m_128728_(i);
                    AttributeModifierInfo ami = AttributeModifierInfo.load(attributeTag);
                    if (ami == null) continue;
                    effectInstance.dynamicAttributeModifiers.put(ami.getAttribute(), ami);
                }
            }
            return effectInstance;
        }
        return null;
    }

    public boolean tick(ISpiritweb data) {
        if (this.duration > 0) {
            if (this.effect.isActiveTick(data)) {
                this.effect.applyEffectTick(data, this.strength);
            }
            this.decreaseDuration();
        }
        return this.duration > 0;
    }

    private void decreaseDuration() {
        --this.duration;
    }

    public void applyAttributeModifiers(LivingEntity livingEntity, AttributeMap pAttributeMap) {
        UUID effectInstanceUUID;
        AttributeModifierInfo attributeModifierInfo;
        AttributeInstance attributeinstance;
        for (Map.Entry<Attribute, AttributeModifierInfo> entry : this.getEffect().getAttributeModifiers().entrySet()) {
            attributeinstance = pAttributeMap.m_22146_(entry.getKey());
            if (attributeinstance == null) continue;
            attributeModifierInfo = entry.getValue();
            effectInstanceUUID = this.getUUID();
            attributeinstance.m_22120_(effectInstanceUUID);
            attributeinstance.m_22125_(new AttributeModifier(effectInstanceUUID, String.format("%s - %s: %s", this.getRegistryName(), this.getStrength(), effectInstanceUUID.toString()), this.getAttributeModifierValue(this.getStrength(), attributeModifierInfo), attributeModifierInfo.getOperation()));
        }
        for (Map.Entry<Attribute, AttributeModifierInfo> entry : this.dynamicAttributeModifiers.entrySet()) {
            attributeinstance = pAttributeMap.m_22146_(entry.getKey());
            if (attributeinstance == null) continue;
            attributeModifierInfo = entry.getValue();
            effectInstanceUUID = this.getUUID();
            attributeinstance.m_22120_(effectInstanceUUID);
            attributeinstance.m_22125_(new AttributeModifier(effectInstanceUUID, String.format("%s - %s: %s", this.getRegistryName(), this.getStrength(), effectInstanceUUID.toString()), this.getAttributeModifierValue(this.getStrength(), attributeModifierInfo), attributeModifierInfo.getOperation()));
        }
    }

    public void removeAttributeModifiers(AttributeMap attributeMap) {
        AttributeInstance attributeinstance;
        for (Map.Entry<Attribute, AttributeModifierInfo> entry : this.getEffect().getAttributeModifiers().entrySet()) {
            attributeinstance = attributeMap.m_22146_(entry.getKey());
            if (attributeinstance == null) continue;
            attributeinstance.m_22120_(this.uuid);
        }
        for (Map.Entry<Attribute, AttributeModifierInfo> entry : this.dynamicAttributeModifiers.entrySet()) {
            attributeinstance = attributeMap.m_22146_(entry.getKey());
            if (attributeinstance == null) continue;
            attributeinstance.m_22120_(this.uuid);
        }
    }

    public double getAttributeModifierValue(double strength, AttributeModifierInfo modifier) {
        return modifier.getAmount() * strength;
    }

    public void setDynamicAttribute(Attribute attribute, double strength, AttributeModifier.Operation operation) {
        AttributeModifierInfo ami;
        if (this.dynamicAttributeModifiers.containsKey(attribute)) {
            ami = this.dynamicAttributeModifiers.get(attribute);
            ami.update(strength, operation);
        } else {
            ami = new AttributeModifierInfo(attribute, strength, operation);
        }
        this.dynamicAttributeModifiers.put(attribute, ami);
    }

    public void removeDynamicAttribute(Attribute attribute) {
        this.dynamicAttributeModifiers.remove(attribute);
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    private void setStrength(double strength) {
        this.strength = strength;
    }

    @NotNull
    public static CosmereEffectInstance getOrCreateEffect(CosmereEffect cosmereEffect, ISpiritweb data, LivingEntity sourceEntity, double strength) {
        return CosmereEffectInstance.getOrCreateEffect(cosmereEffect, data, sourceEntity.m_20149_(), strength);
    }

    public static CosmereEffectInstance getOrCreateEffect(CosmereEffect cosmereEffect, ISpiritweb data, String uuid, double strength) {
        CosmereEffect effect = cosmereEffect;
        CosmereEffectInstance effectInstance = data.getEffect(EffectsHelper.getEffectUUID(effect, uuid));
        if (effectInstance == null) {
            effectInstance = EffectsHelper.getNewEffect(effect, (Entity)data.getLiving(), strength);
        } else {
            data.removeEffect(effectInstance.getUUID());
            effectInstance.setDuration(93);
            effectInstance.setStrength(strength);
        }
        return effectInstance;
    }

    public Map<Attribute, AttributeModifierInfo> getDynamicModifiers() {
        return this.dynamicAttributeModifiers;
    }
}

