/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.api.helpers;

import java.util.UUID;
import leaf.cosmere.api.cosmereEffect.CosmereEffect;
import leaf.cosmere.api.cosmereEffect.CosmereEffectInstance;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class EffectsHelper {
    public static MobEffectInstance getNewEffect(MobEffect effect, int amplifier) {
        MobEffectInstance effectInstance = new MobEffectInstance(effect, 63, Math.max(0, amplifier), true, false, true);
        return effectInstance;
    }

    public static MobEffectInstance getNewEffect(MobEffect effect, int amplifier, int duration) {
        MobEffectInstance effectInstance = new MobEffectInstance(effect, duration, Math.max(0, amplifier), true, false, true);
        return effectInstance;
    }

    public static CosmereEffectInstance getNewEffect(CosmereEffect effect, Entity effectSource, double strength) {
        return EffectsHelper.getNewEffect(effect, effectSource, strength, 93);
    }

    public static CosmereEffectInstance getNewEffect(CosmereEffect effect, Entity effectSource, double strength, int duration) {
        UUID uuid = EffectsHelper.getEffectUUID(effect, effectSource);
        return EffectsHelper.getNewEffect(effect, uuid, strength, duration);
    }

    @NotNull
    public static UUID getEffectUUID(CosmereEffect effect, Entity effectSource) {
        return EffectsHelper.getEffectUUID(effect, effectSource.m_20149_());
    }

    @NotNull
    public static UUID getEffectUUID(CosmereEffect effect, String uuidSource) {
        String sourceAndEffect = uuidSource + effect.getRegistryName();
        UUID uuid = UUID.nameUUIDFromBytes(sourceAndEffect.getBytes());
        return uuid;
    }

    public static CosmereEffectInstance getNewEffect(CosmereEffect effect, UUID uuid, double strength, int duration) {
        CosmereEffectInstance effectInstance = new CosmereEffectInstance(effect, uuid, Math.max(0.0, strength), duration);
        return effectInstance;
    }
}

