/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.common.commands.subcommands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import leaf.cosmere.api.cosmereEffect.AttributeModifierInfo;
import leaf.cosmere.api.cosmereEffect.CosmereEffectInstance;
import leaf.cosmere.api.text.TextHelper;
import leaf.cosmere.common.cap.entity.SpiritwebCapability;
import leaf.cosmere.common.commands.subcommands.ModCommand;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class CosmereEffectCommand
extends ModCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"effects").requires(context -> context.m_6761_(2))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"check").executes(CosmereEffectCommand::checkEffects)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91470_()).requires(context -> context.m_6761_(2))).executes(CosmereEffectCommand::checkEffects)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"clear").requires(context -> context.m_6761_(2))).executes(CosmereEffectCommand::clear)).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91470_()).executes(CosmereEffectCommand::clear)));
    }

    private static int checkEffects(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection<ServerPlayer> players = CosmereEffectCommand.getPlayers(context, 3);
        for (ServerPlayer player : players) {
            CosmereEffectCommand.reportEffectsFoundOnPlayer(context, player);
        }
        return 1;
    }

    private static void reportEffectsFoundOnPlayer(CommandContext<CommandSourceStack> context, ServerPlayer player) {
        SpiritwebCapability.get((LivingEntity)player).ifPresent(spiritweb -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            MutableComponent found = Component.m_237110_((String)"command.cosmere.effects.found", (Object[])new Object[]{TextHelper.getPlayerTextObject(player.m_284548_(), player.m_20148_())});
            MutableComponent leftBracketTextComponent = Component.m_237113_((String)"[");
            MutableComponent rightBracketTextComponent = Component.m_237113_((String)"]");
            MutableComponent space = Component.m_237113_((String)" ");
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry<UUID, CosmereEffectInstance> entry : spiritweb.getEffects()) {
                AttributeModifier.Operation operation;
                double amount;
                String attributeName;
                AttributeModifierInfo attributeModifierInfo;
                found.m_7220_((Component)leftBracketTextComponent);
                MutableComponent baseText = (MutableComponent)entry.getValue().getTextComponent();
                stringBuilder.append("Ticks Remaining: ").append(entry.getValue().getDuration()).append("\n");
                stringBuilder.append("Attribute Multiplier: x").append(entry.getValue().getStrength()).append("\n");
                for (Map.Entry<Attribute, AttributeModifierInfo> attributeEntry : entry.getValue().getEffect().getAttributeModifiers().entrySet()) {
                    attributeModifierInfo = attributeEntry.getValue();
                    attributeName = attributeModifierInfo.getAttribute().m_22087_();
                    amount = attributeModifierInfo.getAmount();
                    operation = attributeModifierInfo.getOperation();
                    stringBuilder.append(attributeName).append(": ").append(amount).append(" : Operation: ").append(operation).append("\n");
                }
                for (Map.Entry<Attribute, AttributeModifierInfo> attributeEntry : entry.getValue().getDynamicModifiers().entrySet()) {
                    attributeModifierInfo = attributeEntry.getValue();
                    attributeName = attributeModifierInfo.getAttribute().m_22087_();
                    amount = attributeModifierInfo.getAmount();
                    operation = attributeModifierInfo.getOperation();
                    stringBuilder.append(attributeName).append(": ").append(amount).append(" : Operation: ").append(operation).append("\n");
                }
                String s = stringBuilder.toString();
                stringBuilder.setLength(0);
                MutableComponent tooltip = Component.m_237113_((String)s);
                found.m_7220_((Component)TextHelper.createTextWithTooltip(baseText, tooltip));
                found.m_7220_((Component)rightBracketTextComponent);
                found.m_7220_((Component)space);
            }
            source.m_288197_(() -> found, true);
        });
    }

    private static int clear(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection<ServerPlayer> players = CosmereEffectCommand.getPlayers(context, 3);
        for (ServerPlayer player : players) {
            SpiritwebCapability.get((LivingEntity)player).ifPresent(iSpiritweb -> {
                CommandSourceStack source = (CommandSourceStack)context.getSource();
                Set<Map.Entry<UUID, CosmereEffectInstance>> playerEffects = iSpiritweb.getEffects();
                for (Map.Entry<UUID, CosmereEffectInstance> entry : playerEffects) {
                    iSpiritweb.onEffectRemoved(entry.getValue());
                }
                playerEffects.clear();
                iSpiritweb.syncToClients(null);
                MutableComponent playerTextObject = TextHelper.getPlayerTextObject(((CommandSourceStack)context.getSource()).m_81372_(), player.m_20148_());
                source.m_288197_(() -> Component.m_237110_((String)"command.cosmere.effects.clear", (Object[])new Object[]{playerTextObject}), false);
            });
        }
        return 1;
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return 1;
    }
}

