/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.common.config;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import java.nio.file.Path;
import java.util.function.Function;
import leaf.cosmere.common.config.ICosmereConfig;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.config.ConfigFileTypeHandler;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;

public class CosmereModConfig
extends ModConfig {
    private static final CosmereConfigFileTypeHandler COSMERE_TOML = new CosmereConfigFileTypeHandler();
    private final ICosmereConfig cosmereConfig;

    public CosmereModConfig(ModContainer container, ICosmereConfig config) {
        super(config.getConfigType(), (IConfigSpec)config.getConfigSpec(), container, "cosmere/" + config.getFileName() + ".toml");
        this.cosmereConfig = config;
    }

    public ConfigFileTypeHandler getHandler() {
        return COSMERE_TOML;
    }

    public void clearCache() {
        this.cosmereConfig.clearCache();
    }

    private static class CosmereConfigFileTypeHandler
    extends ConfigFileTypeHandler {
        private CosmereConfigFileTypeHandler() {
        }

        private static Path getPath(Path configBasePath) {
            if (configBasePath.endsWith("serverconfig")) {
                return FMLPaths.CONFIGDIR.get();
            }
            return configBasePath;
        }

        public Function<ModConfig, CommentedFileConfig> reader(Path configBasePath) {
            return super.reader(CosmereConfigFileTypeHandler.getPath(configBasePath));
        }

        public void unload(Path configBasePath, ModConfig config) {
            super.unload(CosmereConfigFileTypeHandler.getPath(configBasePath), config);
        }
    }
}

