/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.common.eventHandlers;

import com.mojang.brigadier.CommandDispatcher;
import java.util.List;
import leaf.cosmere.common.commands.CosmereCommand;
import leaf.cosmere.common.registration.impl.ItemRegistryObject;
import leaf.cosmere.common.registry.BlocksRegistry;
import leaf.cosmere.common.registry.ItemsRegistry;
import leaf.cosmere.common.registry.VillagerProfessionRegistry;
import leaf.cosmere.common.resource.ore.OreBlockType;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.BasicItemListing;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="cosmere", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CommonEvents {
    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        CosmereCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void registerTrades(VillagerTradesEvent event) {
        if (event.getType() == VillagerProfessionRegistry.METAL_TRADER.get()) {
            block6: for (int i = 1; i <= 5; ++i) {
                List tradesForLevel = (List)event.getTrades().get(i);
                switch (i) {
                    case 1: {
                        CommonEvents.addNuggetTrades(tradesForLevel, Rarity.COMMON);
                        continue block6;
                    }
                    case 2: {
                        CommonEvents.addRawOreTrades(tradesForLevel, Rarity.COMMON);
                        continue block6;
                    }
                    case 3: 
                    case 4: {
                        CommonEvents.addBlendTrades(tradesForLevel, Rarity.COMMON);
                        continue block6;
                    }
                    case 5: {
                        CommonEvents.addOreTrades(tradesForLevel, Rarity.COMMON);
                    }
                }
            }
        }
    }

    private static void addNuggetTrades(List<VillagerTrades.ItemListing> tradesForLevel, Rarity rarity) {
        for (ItemRegistryObject<Item> item : ItemsRegistry.METAL_NUGGETS.values()) {
            if (((Item)item.get()).m_41460_(ItemStack.f_41583_) != rarity) continue;
            ItemStack itemStackForSale = new ItemStack((ItemLike)item.get(), 1);
            tradesForLevel.add(CommonEvents.makeTrade(itemStackForSale));
        }
    }

    private static void addBlendTrades(List<VillagerTrades.ItemListing> tradesForLevel, Rarity rarity) {
        for (ItemRegistryObject<Item> item : ItemsRegistry.METAL_RAW_BLEND.values()) {
            if (((Item)item.get()).m_41460_(ItemStack.f_41583_) != rarity) continue;
            ItemStack itemStackForSale = new ItemStack((ItemLike)item.get(), 1);
            tradesForLevel.add(CommonEvents.makeTrade(itemStackForSale));
        }
    }

    private static void addRawOreTrades(List<VillagerTrades.ItemListing> tradesForLevel, Rarity rarity) {
        for (ItemRegistryObject<Item> item : ItemsRegistry.METAL_RAW_ORE.values()) {
            if (((Item)item.get()).m_41460_(ItemStack.f_41583_) != rarity) continue;
            ItemStack itemStackForSale = new ItemStack((ItemLike)item.get(), 1);
            tradesForLevel.add(CommonEvents.makeTrade(itemStackForSale));
        }
    }

    private static void addOreTrades(List<VillagerTrades.ItemListing> tradesForLevel, Rarity rarity) {
        for (OreBlockType oreType : BlocksRegistry.METAL_ORE.values()) {
            if (oreType.stone().getBlock().m_5456_().m_41460_(ItemStack.f_41583_) != rarity) continue;
            ItemStack itemStackForSale = new ItemStack((ItemLike)oreType.stone().getBlock().m_5456_(), 1);
            tradesForLevel.add(CommonEvents.makeTrade(itemStackForSale));
        }
    }

    private static VillagerTrades.ItemListing makeTrade(ItemStack itemStack) {
        itemStack.m_41764_(CommonEvents.getCount(itemStack));
        return new BasicItemListing(CommonEvents.getCost(itemStack), itemStack, CommonEvents.getMaxTradesPerDay(itemStack), CommonEvents.getXpPerTrade(itemStack));
    }

    private static int getCost(ItemStack item) {
        int cost = 0;
        switch (item.m_41720_().m_41460_(item)) {
            case COMMON: {
                cost = 1;
                break;
            }
            case UNCOMMON: {
                cost = 16;
                break;
            }
            case RARE: {
                cost = 32;
                break;
            }
            case EPIC: {
                cost = 64;
            }
        }
        return cost;
    }

    private static int getCount(ItemStack item) {
        int count = 0;
        switch (item.m_41720_().m_41460_(item)) {
            case COMMON: {
                count = 16;
                break;
            }
            case UNCOMMON: {
                count = 8;
                break;
            }
            case RARE: {
                count = 4;
                break;
            }
            case EPIC: {
                count = 1;
            }
        }
        return count;
    }

    private static int getMaxTradesPerDay(ItemStack item) {
        int count = 0;
        switch (item.m_41720_().m_41460_(item)) {
            case COMMON: {
                count = 8;
                break;
            }
            case UNCOMMON: {
                count = 5;
                break;
            }
            case RARE: {
                count = 3;
                break;
            }
            case EPIC: {
                count = 1;
            }
        }
        return count;
    }

    private static int getXpPerTrade(ItemStack item) {
        int count = 0;
        switch (item.m_41720_().m_41460_(item)) {
            case COMMON: {
                count = 2;
                break;
            }
            case UNCOMMON: {
                count = 4;
                break;
            }
            case RARE: {
                count = 6;
                break;
            }
            case EPIC: {
                count = 8;
            }
        }
        return count;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onResourceReload(AddReloadListenerEvent event) {
    }
}

