/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.common.eventHandlers;

import leaf.cosmere.api.CosmereAPI;
import leaf.cosmere.api.Manifestations;
import leaf.cosmere.api.Metals;
import leaf.cosmere.api.helpers.EntityHelper;
import leaf.cosmere.api.manifestation.Manifestation;
import leaf.cosmere.api.math.MathHelper;
import leaf.cosmere.api.spiritweb.ISpiritweb;
import leaf.cosmere.common.cap.entity.SpiritwebCapability;
import leaf.cosmere.common.config.CosmereConfigs;
import leaf.cosmere.common.config.CosmereServerConfig;
import leaf.cosmere.common.registry.AttributesRegistry;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="cosmere", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EntityEventHandler {
    @SubscribeEvent
    public static void onEntityJoinWorldEvent(EntityJoinLevelEvent event) {
        Entity eventEntity = event.getEntity();
        if (eventEntity.m_9236_().f_46443_ || !(eventEntity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)eventEntity;
        SpiritwebCapability.get(livingEntity).ifPresent(iSpiritweb -> {
            SpiritwebCapability spiritweb = (SpiritwebCapability)iSpiritweb;
            if (spiritweb.hasBeenInitialized() || spiritweb.hasAnyPowers()) {
                return;
            }
            if (eventEntity instanceof Player) {
                if (CosmereConfigs.SERVER_CONFIG.POWER_GENERATION.get() == CosmereServerConfig.PowerGeneration.NONE) {
                    spiritweb.setHasBeenInitialized();
                } else if (CosmereConfigs.SERVER_CONFIG.POWER_GENERATION.get() == CosmereServerConfig.PowerGeneration.RANDOM) {
                    EntityEventHandler.giveEntityStartingManifestation(livingEntity, spiritweb);
                    spiritweb.setHasBeenInitialized();
                } else {
                    Player player = (Player)eventEntity;
                    String command = "/cosmere choose_metalborn_powers ";
                    MutableComponent instructionComponent = Component.m_237113_((String)"To choose powers, use ");
                    instructionComponent.m_7220_((Component)Component.m_237113_((String)"\u00a76\u00a7n/cosmere choose_metalborn_powers [allomancy] [feruchemy]").m_6270_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, command))));
                    player.m_213846_((Component)instructionComponent);
                }
            } else if (EntityEventHandler.canStartWithPowers(eventEntity)) {
                int chance;
                int raiderPowersChance = (Integer)CosmereConfigs.SERVER_CONFIG.RAIDER_POWERS_CHANCE.get();
                int mobPowersChance = (Integer)CosmereConfigs.SERVER_CONFIG.MOB_POWERS_CHANCE.get();
                int n = chance = eventEntity instanceof Raider ? raiderPowersChance : mobPowersChance;
                if (MathHelper.chance(chance)) {
                    EntityEventHandler.giveEntityStartingManifestation(livingEntity, spiritweb);
                }
                spiritweb.setHasBeenInitialized();
            } else if (eventEntity instanceof Warden) {
                Warden warden = (Warden)eventEntity;
                Attribute attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("allomancy:bronze"));
                if (attribute == null) {
                    return;
                }
                AttributeInstance manifestationAttribute = livingEntity.m_21051_(attribute);
                if (manifestationAttribute != null) {
                    manifestationAttribute.m_22100_(9.0);
                }
                spiritweb.setHasBeenInitialized();
            }
        });
    }

    public static boolean canStartWithPowers(Entity entity) {
        return entity instanceof Player || entity instanceof AbstractVillager || entity instanceof ZombieVillager || entity instanceof Raider && !(entity instanceof Ravager) || entity instanceof AbstractPiglin;
    }

    public static void giveEntityStartingManifestation(LivingEntity entity, SpiritwebCapability spiritwebCapability) {
        boolean isPlayerEntity = entity instanceof Player;
        if (isPlayerEntity && !MathHelper.chance((Integer)CosmereConfigs.SERVER_CONFIG.PLAYER_METALBORN_CHANCE.get())) {
            EntityEventHandler.addOtherPowers(spiritwebCapability);
            return;
        }
        Integer chanceOfFullPowers = (Integer)CosmereConfigs.SERVER_CONFIG.FULLBORN_POWERS_CHANCE.get();
        Integer chanceOfTwinborn = isPlayerEntity ? (Integer)CosmereConfigs.SERVER_CONFIG.TWINBORN_POWERS_CHANCE_PLAYER.get() : (Integer)CosmereConfigs.SERVER_CONFIG.TWINBORN_POWERS_CHANCE_MOB.get();
        boolean isFullPowersFromOneType = MathHelper.chance(chanceOfFullPowers);
        boolean isTwinborn = MathHelper.chance(chanceOfTwinborn);
        int allomancyPowerID = MathHelper.randomInt(0, 15);
        int feruchemyPowerID = MathHelper.randomInt(0, 15);
        Metals.MetalType allomancyMetal = Metals.MetalType.valueOf(allomancyPowerID).get();
        Metals.MetalType feruchemyMetal = Metals.MetalType.valueOf(feruchemyPowerID).get();
        boolean allomancyLoaded = ModList.get().isLoaded("allomancy");
        boolean feruchemyLoaded = ModList.get().isLoaded("feruchemy");
        boolean isAllomancy = MathHelper.randomBool();
        if (isFullPowersFromOneType) {
            Object manifestation2;
            Manifestations.ManifestationTypes manifestationType;
            if (allomancyLoaded && feruchemyLoaded) {
                manifestationType = isAllomancy ? Manifestations.ManifestationTypes.ALLOMANCY : Manifestations.ManifestationTypes.FERUCHEMY;
            } else if (allomancyLoaded) {
                manifestationType = Manifestations.ManifestationTypes.ALLOMANCY;
            } else if (feruchemyLoaded) {
                manifestationType = Manifestations.ManifestationTypes.FERUCHEMY;
            } else {
                return;
            }
            CosmereAPI.logger.info("Entity {} has full powers! {}", (Object)spiritwebCapability.getLiving().m_7755_().getString(), (Object)manifestationType);
            for (Object manifestation2 : CosmereAPI.manifestationRegistry()) {
                if (((Manifestation)manifestation2).getManifestationType() != manifestationType) continue;
                spiritwebCapability.giveManifestation((Manifestation)manifestation2, 9);
            }
            manifestation2 = spiritwebCapability.getLiving();
            if (manifestation2 instanceof Player) {
                Player player = (Player)manifestation2;
                spiritwebCapability.getSubmodule(manifestationType).GiveStartingItem(player);
            }
        } else {
            Manifestation allomancyPower = Manifestations.ManifestationTypes.ALLOMANCY.getManifestation(allomancyMetal.getID());
            Manifestation feruchemyPower = Manifestations.ManifestationTypes.FERUCHEMY.getManifestation(feruchemyMetal.getID());
            if (isTwinborn) {
                Player player;
                LivingEntity livingEntity;
                if (allomancyLoaded) {
                    spiritwebCapability.giveManifestation(allomancyPower, 9);
                    livingEntity = spiritwebCapability.getLiving();
                    if (livingEntity instanceof Player) {
                        player = (Player)livingEntity;
                        spiritwebCapability.getSubmodule(Manifestations.ManifestationTypes.ALLOMANCY).GiveStartingItem(player, allomancyPower);
                    }
                    CosmereAPI.logger.info("Entity {} has been granted allomantic {}!", (Object)spiritwebCapability.getLiving().m_7755_().getString(), (Object)allomancyMetal);
                }
                if (feruchemyLoaded) {
                    spiritwebCapability.giveManifestation(feruchemyPower, 9);
                    livingEntity = spiritwebCapability.getLiving();
                    if (livingEntity instanceof Player) {
                        player = (Player)livingEntity;
                        spiritwebCapability.getSubmodule(Manifestations.ManifestationTypes.FERUCHEMY).GiveStartingItem(player, feruchemyPower);
                    }
                    CosmereAPI.logger.info("Entity {} has been granted feruchemical {}!", (Object)spiritwebCapability.getLiving().m_7755_().getString(), (Object)feruchemyMetal);
                }
            } else {
                Manifestation manifestation;
                boolean bl = isPlayerEntity ? MathHelper.randomInt(0, 99) < (Integer)CosmereConfigs.SERVER_CONFIG.PLAYER_MISTING_TO_FERRING_DISTRIBUTION.get() : (isAllomancy = MathHelper.randomBool());
                if (allomancyLoaded && feruchemyLoaded) {
                    manifestation = isAllomancy ? allomancyPower : feruchemyPower;
                } else if (allomancyLoaded) {
                    manifestation = allomancyPower;
                } else if (feruchemyLoaded) {
                    manifestation = feruchemyPower;
                } else {
                    return;
                }
                spiritwebCapability.giveManifestation(manifestation, 9);
                LivingEntity livingEntity = spiritwebCapability.getLiving();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    spiritwebCapability.getSubmodule(isAllomancy ? Manifestations.ManifestationTypes.ALLOMANCY : Manifestations.ManifestationTypes.FERUCHEMY).GiveStartingItem(player, manifestation);
                }
                CosmereAPI.logger.info("Entity {} has been granted {}, with metal {}!", new Object[]{spiritwebCapability.getLiving().m_7755_().getString(), isAllomancy ? Manifestations.ManifestationTypes.ALLOMANCY.getName() : Manifestations.ManifestationTypes.FERUCHEMY.getName(), isAllomancy ? allomancyMetal : feruchemyMetal});
            }
        }
        EntityEventHandler.addOtherPowers(spiritwebCapability);
    }

    public static void addOtherPowers(SpiritwebCapability spiritwebCapability) {
        for (Manifestation manifestation : CosmereAPI.manifestationRegistry()) {
            if (manifestation.getManifestationType() != Manifestations.ManifestationTypes.SANDMASTERY) continue;
            int ribbonCount = MathHelper.randomInt(1, 24);
            spiritwebCapability.giveManifestation(manifestation, ribbonCount);
            CosmereAPI.logger.info("Setting entity {} ribbons to {}", (Object)spiritwebCapability.getLiving().m_7755_().getString(), (Object)ribbonCount);
            break;
        }
    }

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent event) {
        SpiritwebCapability.get(event.getEntity()).ifPresent(ISpiritweb::tick);
    }

    @SubscribeEvent
    public static void onLootingLevelEvent(LootingLevelEvent event) {
        LivingEntity sourceLiving;
        int total;
        Entity entity;
        if (event.getDamageSource() == null) {
            return;
        }
        if (!event.getEntity().m_9236_().f_46443_ && (entity = event.getDamageSource().m_7639_()) instanceof LivingEntity && (total = (int)EntityHelper.getAttributeValue(sourceLiving = (LivingEntity)entity, AttributesRegistry.COSMERE_FORTUNE.getAttribute())) != 0) {
            event.setLootingLevel(event.getLootingLevel() + total);
        }
    }

    @SubscribeEvent
    public static void onLivingHurtEvent(LivingHurtEvent event) {
        if (event.isCanceled()) {
            return;
        }
        float total = (float)EntityHelper.getAttributeValue(event.getEntity(), AttributesRegistry.DETERMINATION.getAttribute());
        if ((double)total > 0.1) {
            float maxDetermination = 23.125f;
            float percentageOfMaxDetermination = total / 23.125f;
            float damageReduction = 1.0f - Mth.m_14179_((float)percentageOfMaxDetermination, (float)0.0f, (float)0.8f);
            event.setAmount(event.getAmount() * damageReduction);
        } else if ((double)total < -0.1) {
            float minDetermination = 3.0f;
            float percentageOfMinDetermination = Math.abs(total) / 3.0f;
            float damageIncrease = Mth.m_14179_((float)percentageOfMinDetermination, (float)1.0f, (float)1.25f);
            event.setAmount(event.getAmount() * damageIncrease);
        }
    }
}

